/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard;

import com.installshield.wizard.FilteredWizardTreeIterator;
import com.installshield.wizard.WizardBean;
import com.installshield.wizard.WizardBeanFilter;
import com.installshield.wizard.WizardTree;
import java.util.Vector;

public class StandardWizardTreeIterator
implements FilteredWizardTreeIterator {
    private WizardBean root;
    private WizardBean begin = new Marker();
    private WizardBean end = new Marker();
    private Vector filters = new Vector();

    public StandardWizardTreeIterator(WizardBean wizardBean) {
        this.root = wizardBean;
    }

    public StandardWizardTreeIterator(WizardTree wizardTree) {
        this(wizardTree.getRoot());
    }

    protected final boolean accept(WizardBean wizardBean) {
        boolean bl = true;
        Vector vector = this.filters;
        synchronized (vector) {
            int n = this.filters.size();
            int n2 = 0;
            while (bl && n2 < n) {
                if (!((WizardBeanFilter)this.filters.elementAt(n2)).accept(wizardBean)) {
                    bl = false;
                }
                ++n2;
            }
        }
        return bl;
    }

    public void addFilter(WizardBeanFilter wizardBeanFilter) {
        this.filters.addElement(wizardBeanFilter);
    }

    public WizardBean begin() {
        return this.begin;
    }

    public WizardBean end() {
        return this.end;
    }

    private WizardBean getFirst() {
        return this.accept(this.root) ? this.root : null;
    }

    private WizardBean getLast() {
        WizardBean wizardBean = null;
        if (this.accept(this.root)) {
            WizardBean wizardBean2 = this.root.getWizardTree().getLastChild(this.root);
            while (wizardBean2 != null && !this.accept(wizardBean2)) {
                wizardBean2 = wizardBean2.getWizardTree().getPreviousSibling(wizardBean2);
            }
            while (wizardBean2 != null) {
                wizardBean = wizardBean2;
                wizardBean2 = wizardBean2.getWizardTree().getLastChild(wizardBean2);
                while (wizardBean2 != null && !this.accept(wizardBean2)) {
                    wizardBean2 = wizardBean2.getWizardTree().getPreviousSibling(wizardBean2);
                }
            }
            if (wizardBean == null) {
                wizardBean = this.root;
            }
        }
        return wizardBean;
    }

    public WizardBean getNext(WizardBean wizardBean) {
        if (wizardBean == null || wizardBean == this.end()) {
            return null;
        }
        if (wizardBean == this.begin()) {
            WizardBean wizardBean2 = this.getFirst();
            return wizardBean2 != null ? wizardBean2 : this.end();
        }
        WizardBean wizardBean3 = wizardBean.getWizardTree().getFirstChild(wizardBean);
        while (wizardBean3 != null) {
            if (this.accept(wizardBean3)) {
                return wizardBean3;
            }
            wizardBean3 = wizardBean3.getWizardTree().getNextSibling(wizardBean3);
        }
        if (wizardBean == this.root) {
            return this.end();
        }
        wizardBean3 = wizardBean.getWizardTree().getNextSibling(wizardBean);
        while (wizardBean3 != null) {
            if (this.accept(wizardBean3)) {
                return wizardBean3;
            }
            wizardBean3 = wizardBean3.getWizardTree().getNextSibling(wizardBean3);
        }
        while (wizardBean != null && wizardBean != this.root) {
            if ((wizardBean = wizardBean.getWizardTree().getParent(wizardBean)) == null || wizardBean == this.root) continue;
            wizardBean3 = wizardBean.getWizardTree().getNextSibling(wizardBean);
            while (wizardBean3 != null) {
                if (this.accept(wizardBean3)) {
                    return wizardBean3;
                }
                wizardBean3 = wizardBean3.getWizardTree().getNextSibling(wizardBean3);
            }
        }
        return this.end();
    }

    public WizardBean getPrevious(WizardBean wizardBean) {
        if (wizardBean == null || wizardBean == this.begin()) {
            return null;
        }
        if (wizardBean == this.end()) {
            WizardBean wizardBean2 = this.getLast();
            return wizardBean2 != null ? wizardBean2 : this.begin();
        }
        if (wizardBean == this.root) {
            return this.begin();
        }
        WizardBean wizardBean3 = wizardBean.getWizardTree().getPreviousSibling(wizardBean);
        while (wizardBean3 != null && !this.accept(wizardBean3)) {
            wizardBean3 = wizardBean3.getWizardTree().getPreviousSibling(wizardBean3);
        }
        if (wizardBean3 != null) {
            WizardBean wizardBean4 = wizardBean3.getWizardTree().getLastChild(wizardBean3);
            while (wizardBean4 != null && !this.accept(wizardBean4)) {
                wizardBean4 = wizardBean4.getWizardTree().getPreviousSibling(wizardBean4);
            }
            while (wizardBean4 != null) {
                wizardBean3 = wizardBean4;
                wizardBean4 = wizardBean4.getWizardTree().getLastChild(wizardBean4);
                while (wizardBean4 != null && !this.accept(wizardBean4)) {
                    wizardBean4 = wizardBean4.getWizardTree().getPreviousSibling(wizardBean4);
                }
            }
        }
        if (wizardBean3 == null) {
            wizardBean3 = wizardBean.getWizardTree().getParent(wizardBean);
        }
        if (wizardBean3 != null) {
            return wizardBean3;
        }
        return this.begin();
    }

    public void removeFilter(WizardBeanFilter wizardBeanFilter) {
        this.filters.removeElement(wizardBeanFilter);
    }

    class Marker
    extends WizardBean {
        Marker() {
        }
    }
}

