/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.awt;

import com.installshield.wizard.awt.InsetsPanel;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;

public class AWTImageButton
extends Panel {
    private boolean boolExpanded = true;
    private InsetsPanel insetsOne = null;
    private Insets insets = null;
    private Rectangle iconBounds = null;
    private final int iconWidth = 10;
    private final int iconHeight = 10;
    private Vector vecActionListeners = new Vector();

    public AWTImageButton() {
        this.insets = new Insets(1, 1, 1, 1);
        this.insetsOne = new InsetsPanel(0, 1, 0, 0);
        this.enableEvents(16L);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.vecActionListeners.addElement(actionListener);
    }

    public boolean getExpanded() {
        return this.boolExpanded;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.insets.left + 10 + this.insets.right, this.insets.top + 10 + this.insets.bottom);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return true;
    }

    public void paint(Graphics graphics) {
        int n = 2;
        Rectangle rectangle = graphics.getClipBounds();
        this.iconBounds = new Rectangle(this.insets.left, (rectangle.height - 10) / 2, 10, 10);
        graphics.setColor(Color.white);
        graphics.fillRect(this.iconBounds.x, this.iconBounds.y, this.iconBounds.width, this.iconBounds.height);
        graphics.setColor(Color.black);
        graphics.drawRect(this.iconBounds.x, this.iconBounds.y, this.iconBounds.width, this.iconBounds.height);
        int n2 = this.iconBounds.y + this.iconBounds.height / 2;
        graphics.drawLine(this.iconBounds.x + 2, n2, this.iconBounds.x + this.iconBounds.width - 2, n2);
        int n3 = this.iconBounds.x + this.iconBounds.width / 2;
        if (!this.boolExpanded) {
            graphics.drawLine(n3, this.iconBounds.y + 2, n3, this.iconBounds.y + this.iconBounds.height - 2);
        }
        graphics.finalize();
        graphics.dispose();
    }

    public void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent.getSource() instanceof AWTImageButton) {
            AWTImageButton aWTImageButton = (AWTImageButton)aWTEvent.getSource();
            if (aWTEvent.getID() == 500) {
                if (aWTImageButton.getExpanded()) {
                    aWTImageButton.setExpanded(false);
                } else {
                    aWTImageButton.setExpanded(true);
                }
                aWTImageButton.repaint();
            }
            Enumeration enumeration = this.vecActionListeners.elements();
            while (enumeration.hasMoreElements()) {
                ActionListener actionListener = (ActionListener)enumeration.nextElement();
                ActionEvent actionEvent = new ActionEvent(aWTEvent.getSource(), aWTEvent.getID(), aWTEvent.toString());
                actionListener.actionPerformed(actionEvent);
            }
        }
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.vecActionListeners.removeElement(actionListener);
    }

    public void setExpanded(boolean bl) {
        this.boolExpanded = bl;
    }
}

