/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.common.environment;

import com.installshield.util.FileUtils;
import com.installshield.wizard.platform.common.environment.GenericEnvironmentVariableManager;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.zip.CRC32;

public abstract class ScriptEnvironmentVariableManager
extends GenericEnvironmentVariableManager {
    public static final String lineSeparator = System.getProperty("line.separator");
    public static final String spaceSeparator = new String(new byte[]{32});
    private static final String header = " Begin INSTALLSHIELD Environment Variable Section";
    private static final String footer = " End INSTALLSHIELD Environment Variable Section";
    private static final String doNotEdit = " Do not edit this section manually.";
    private String scriptFile = null;
    private Hashtable sectionBuffer = new Hashtable();
    private Hashtable delimiters = new Hashtable();
    private byte[] fileBuffer = new byte[0];

    public ScriptEnvironmentVariableManager(String string) {
        this.scriptFile = string;
    }

    public void appendVariable(String string, String string2, String string3) {
        super.appendVariable(string, string2, string3);
        this.setDelimiterForVariable(string, string3);
    }

    public void deleteVariable(String string) {
        if (this.sectionBuffer.containsKey(string)) {
            this.sectionBuffer.remove(string);
        }
    }

    protected abstract String getBackupFileName(String var1, String var2);

    protected final Dictionary getSectionBuffer() {
        return this.sectionBuffer;
    }

    private String getValueWithoutEcho(String string, String string2) {
        String string3 = this.getEchoCommandString(string);
        if (string3 == null || string3.length() == 0) {
            return string2;
        }
        String string4 = string2;
        String string5 = (String)this.delimiters.get(string);
        int n = string3.length();
        int n2 = -1;
        int n3 = 0;
        if (string5 == null || string5.length() == 0) {
            n2 = string2.indexOf(string3);
            if (n2 >= 0) {
                n3 = n;
            }
        } else {
            int n4 = string5.length();
            n2 = string2.indexOf(String.valueOf(string5) + string3);
            if (n2 >= 0) {
                n3 = n4 + n;
            } else {
                n2 = string2.indexOf(String.valueOf(string3) + string5);
                if (n2 >= 0) {
                    n3 = n + n4;
                }
            }
        }
        if (n2 >= 0) {
            string4 = string2.substring(0, n2);
            string4 = String.valueOf(string4) + string2.substring(n2 + n3);
        }
        return string4;
    }

    public String getVariable(String string) {
        return (String)this.sectionBuffer.get(string);
    }

    protected void initializeImpl() throws IOException {
        this.loadFile();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadFile() throws IOException {
        RandomAccessFile randomAccessFile;
        block10: {
            block11: {
                randomAccessFile = null;
                try {
                    String string;
                    int n;
                    if (System.getProperty("is.debug") != null) {
                        System.out.println("loading " + this.scriptFile + " for environmental variable update");
                    }
                    if ((n = (int)(randomAccessFile = new RandomAccessFile(this.scriptFile, "r")).length()) == 0) {
                        Object var3_3 = null;
                        if (randomAccessFile == null) return;
                        break block10;
                    }
                    this.fileBuffer = new byte[n];
                    int n2 = 0;
                    int n3 = 0;
                    while (true) {
                        if (n2 > n || (n3 = randomAccessFile.read(this.fileBuffer)) == -1) {
                            String string2 = new String(this.fileBuffer);
                            int n4 = string2.indexOf(header);
                            if (n4 >= 0) {
                                randomAccessFile.seek(n4);
                                randomAccessFile.readLine();
                                string = randomAccessFile.readLine().trim();
                                break;
                            }
                            break block11;
                        }
                        n2 += n3;
                    }
                    while (string != null && !string.equals(String.valueOf(this.getCommentString()) + footer)) {
                        try {
                            this.loadVariable(string);
                        }
                        catch (NoSuchElementException noSuchElementException) {}
                        string = randomAccessFile.readLine().trim();
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    if (randomAccessFile == null) throw throwable;
                    randomAccessFile.close();
                    throw throwable;
                }
            }
            Object var3_4 = null;
            if (randomAccessFile == null) return;
            randomAccessFile.close();
            return;
        }
        randomAccessFile.close();
    }

    private void loadVariable(String string) {
        if (string.startsWith(String.valueOf(this.getCommentString()) + spaceSeparator + "var")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken();
            String string3 = null;
            if (string2.equals("1")) {
                string3 = stringTokenizer.nextToken();
            }
            String string4 = stringTokenizer.nextToken("=").trim();
            this.setDelimiterForVariable(string4, string3);
            if (stringTokenizer.hasMoreTokens()) {
                this.getSectionBuffer().put(string4, stringTokenizer.nextToken().trim());
            } else {
                this.getSectionBuffer().put(string4, new String(""));
            }
        }
    }

    public void makeUpdatePersistent() throws IOException {
        CharSequence charSequence;
        String string = new String(this.fileBuffer);
        int n = string.indexOf(String.valueOf(this.getCommentString()) + header);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (n >= 0) {
            byteArrayOutputStream.write(this.fileBuffer, 0, n);
        } else {
            charSequence = new String(this.fileBuffer, 0, this.fileBuffer.length);
            if (!((String)charSequence).endsWith(lineSeparator)) {
                charSequence = String.valueOf(charSequence) + lineSeparator;
            }
            byteArrayOutputStream.write(((String)charSequence).getBytes());
        }
        this.removeUnmodifiers();
        if (this.sectionBuffer.size() > 0) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(this.getCommentString()).append(header).append(lineSeparator);
            byteArrayOutputStream.write(((StringBuffer)charSequence).toString().getBytes());
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(this.getCommentString()).append(doNotEdit).append(lineSeparator);
            byteArrayOutputStream.write(((StringBuffer)charSequence).toString().getBytes());
            byteArrayOutputStream.write(this.writeAllVariables().getBytes());
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(this.getCommentString()).append(footer).append(lineSeparator);
            byteArrayOutputStream.write(((StringBuffer)charSequence).toString().getBytes());
        }
        if ((n = string.indexOf(String.valueOf(this.getCommentString()) + footer)) > 0) {
            int n2 = n + this.getCommentString().length() + footer.length() + lineSeparator.length();
            byteArrayOutputStream.write(this.fileBuffer, n2, this.fileBuffer.length - n2);
        }
        CRC32 cRC32 = new CRC32();
        cRC32.update(this.fileBuffer);
        long l = cRC32.getValue();
        cRC32.reset();
        cRC32.update(byteArrayOutputStream.toByteArray());
        long l2 = cRC32.getValue();
        if (l != l2) {
            FileOutputStream fileOutputStream = new FileOutputStream(this.getBackupFileName(FileUtils.getParent(this.scriptFile), FileUtils.getName(this.scriptFile)));
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            byteArrayOutputStream2.write(this.fileBuffer);
            byteArrayOutputStream2.flush();
            byteArrayOutputStream2.close();
            byteArrayOutputStream2.writeTo(fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
            if (System.getProperty("is.debug") != null) {
                System.out.println("commiting environmental variable update to script file = " + this.scriptFile);
            }
            fileOutputStream = new FileOutputStream(this.scriptFile);
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            byteArrayOutputStream.writeTo(fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
    }

    public void prependVariable(String string, String string2, String string3) {
        super.prependVariable(string, string2, string3);
        this.setDelimiterForVariable(string, string3);
    }

    private void removeUnmodifiers() {
        Enumeration enumeration = this.sectionBuffer.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.sectionBuffer.get(string);
            if (!this.getEchoCommandString(string).equals(string2)) continue;
            this.sectionBuffer.remove(string);
        }
    }

    private void setDelimiterForVariable(String string, String string2) {
        if (string2 == null || string2.length() <= 0) {
            this.delimiters.remove(string);
        } else {
            this.delimiters.put(string, string2);
        }
    }

    public void setVariable(String string, String string2) {
        this.sectionBuffer.put(string, string2);
    }

    public void unAppendVariable(String string, String string2, String string3) {
        super.unAppendVariable(string, string2, string3);
        this.setDelimiterForVariable(string, string3);
    }

    public void unPrependVariable(String string, String string2, String string3) {
        super.unPrependVariable(string, string2, string3);
        this.setDelimiterForVariable(string, string3);
    }

    public boolean variableExists(String string) {
        return this.sectionBuffer.containsKey(string);
    }

    protected String writeAllVariables() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.sectionBuffer.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.sectionBuffer.get(string);
            if (string == null || string2 == null) continue;
            stringBuffer.append(this.getCommentString());
            stringBuffer.append(" var ");
            String string3 = (String)this.delimiters.get(string);
            stringBuffer.append(string3 == null || string3.length() == 0 ? "0 " : "1 ");
            if (string3 != null && string3.length() > 0) {
                stringBuffer.append(String.valueOf(string3) + " ");
            }
            stringBuffer.append(string);
            stringBuffer.append("=");
            stringBuffer.append(string2);
            stringBuffer.append(lineSeparator);
            stringBuffer.append(this.writeVariable(string, string2, this.getValueWithoutEcho(string, string2)));
            stringBuffer.append(lineSeparator);
        }
        return stringBuffer.toString();
    }

    protected abstract String writeVariable(String var1, String var2, String var3);
}

