/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32;

import com.installshield.util.FileAttributes;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.win32.Win32Platform;
import com.installshield.wizard.platform.win32.Win32Utils;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileServiceImplementor;
import com.installshield.wizard.service.file.PureJavaFileServiceImpl;
import com.installshield.wizard.service.system.SystemUtilService;
import java.io.File;
import java.util.GregorianCalendar;

public class Win32FileServiceImpl
extends PureJavaFileServiceImpl
implements FileServiceImplementor {
    public static final String PLATFORM_ID = "win32ppk";
    public static final String OS_MAIN_DIR = "os_main";
    public static final String COMMON_DIR = "common";

    public boolean canRead(String s) {
        boolean flag = this.win32EnableAbort(false);
        boolean flag1 = super.canRead(s);
        this.win32EnableAbort(flag);
        return flag1;
    }

    public int copyFile(String s, String s1, boolean flag) throws ServiceException {
        SystemUtilService systemutilservice;
        int i = this.win32CopyFile(s, s1, flag);
        if (i == 1 && (systemutilservice = (SystemUtilService)this.getServices().getService("systemUtilService")) != null) {
            systemutilservice.setRebootRequired(true);
        }
        return i;
    }

    public int deleteDirectory(String s) throws ServiceException {
        return this.deleteDirectory(s, true, false);
    }

    public int deleteDirectory(String s, boolean flag, boolean flag1) throws ServiceException {
        SystemUtilService systemutilservice;
        String s1 = this.createFileName(this.getCurrentDirectory(), s);
        if (this.fileExists(s1) && this.isDirectory(s1) && this.getParent(s1) == null) {
            throw new ServiceException(305, "deleteDirectory cannot be used to delete the root directory");
        }
        int i = this.win32DeleteDirectory(s, flag, flag1);
        if (i == 1 && (systemutilservice = (SystemUtilService)this.getServices().getService("systemUtilService")) != null) {
            systemutilservice.setRebootRequired(true);
        }
        return i;
    }

    public int deleteFile(String s) throws ServiceException {
        SystemUtilService systemutilservice;
        int i;
        String s1 = this.createFileName(this.getCurrentDirectory(), s);
        File f1 = new File(s1);
        if (f1.exists() && !f1.isDirectory()) {
            try {
                if (f1.delete()) {
                    return 0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String additional = "";
            String sd = s;
            while (true) {
                try {
                    sd = String.valueOf(s1) + additional + ".delete_on_reboot";
                    if (f1.renameTo(new File(sd))) {
                        s = sd;
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (additional.length() != 0) break;
                additional = Long.toString(System.currentTimeMillis());
                additional = "." + additional.substring(additional.length() - 6, additional.length() - 3);
            }
        }
        if ((i = this.win32DeleteFile(s)) == 1 && (systemutilservice = (SystemUtilService)this.getServices().getService("systemUtilService")) != null) {
            systemutilservice.setRebootRequired(true);
        }
        return i;
    }

    public native FileAttributes getFileAttributes(String var1) throws ServiceException;

    public native String getFileOwner(String var1) throws ServiceException;

    public native String getFileOwnerGroup(String var1) throws ServiceException;

    protected native String getLibraryDirectory() throws ServiceException;

    public String getNamedDirectory(String s) throws ServiceException {
        boolean flag = true;
        String s1 = "";
        if (s.equals(OS_MAIN_DIR)) {
            s1 = this.win32GetWindowsDirectory();
        } else if (s.equals(COMMON_DIR)) {
            s1 = this.win32GetCommonDirectory();
        } else {
            s1 = super.getNamedDirectory(s);
            flag = false;
        }
        if (flag && FileUtils.getParent(s1) != null && (s1.endsWith("/") || s1.endsWith("\\") || s1.endsWith(File.separator))) {
            s1 = s1.substring(0, s1.length() - 1);
        }
        return s1;
    }

    public native String getPartitionFormat(String var1) throws ServiceException;

    public native long getPartitionFreeSpace(String var1) throws ServiceException;

    public native String[] getPartitionNames() throws ServiceException;

    public native int getPartitionType(String var1) throws ServiceException;

    protected String getPlatformIdImpl() {
        return PLATFORM_ID;
    }

    protected native String getStandardInstallDirectory() throws ServiceException;

    public int getSystemCompatibility() {
        int byte0 = 0;
        try {
            if (Win32Platform.isCompatibleWith(1, 1)) {
                byte0 = 5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byte0;
    }

    protected native String getTempDirectory() throws ServiceException;

    protected void initialized() {
        super.initialized();
        try {
            Win32Utils.loadDLL(this.getResource(Win32Utils.getJNIDLLResourceName()), Win32Utils.getJNIDLLName());
        }
        catch (Exception exception) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "serviceCannotLoadJniDll", new String[]{"fileService", Win32Utils.getJNIDLLName()}));
            exception.printStackTrace();
        }
    }

    public native boolean isDirectoryWritable(String var1);

    public int moveFile(String s, String s1, boolean flag) throws ServiceException {
        SystemUtilService systemutilservice;
        int i = this.win32MoveFile(s, s1, flag);
        if (i == 1 && (systemutilservice = (SystemUtilService)this.getServices().getService("systemUtilService")) != null) {
            systemutilservice.setRebootRequired(true);
        }
        return i;
    }

    private long normalizeDate(long l) {
        GregorianCalendar gregoriancalendar = new GregorianCalendar();
        gregoriancalendar.set(1601, 0, 1);
        long l1 = gregoriancalendar.getTime().getTime();
        gregoriancalendar.set(1970, 0, 1);
        long l2 = gregoriancalendar.getTime().getTime();
        return (l + l2 - l1) * 10000L;
    }

    public native void setFileAttributes(String var1, FileAttributes var2) throws ServiceException;

    public void setFileCreated(String s, long l) throws ServiceException {
        l = this.normalizeDate(l);
        this.win32SetFileCreated(s, l);
    }

    public void setFileExecutable(String s) throws ServiceException {
        File file = new File(s);
        if (!file.isFile()) {
            throw new ServiceException(399, LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32FileServiceImpl.fileDoesNotExist", new String[]{s.toString()}));
        }
    }

    public void setFileModified(String s, long l) throws ServiceException {
        l = this.normalizeDate(l);
        this.win32SetFileModified(s, l);
    }

    public native void setFileOwner(String var1, String var2) throws ServiceException;

    public native void setFileOwnerGroup(String var1, String var2) throws ServiceException;

    public void setFileTimes(String s, long l, long l1, long l2) throws ServiceException {
        l = this.normalizeDate(l);
        l1 = this.normalizeDate(l1);
        l2 = this.normalizeDate(l2);
        this.win32SetFileTimes(s, l, l1, l2);
    }

    public native boolean supportsLongFileNames(String var1);

    public void validateFileName(String s) throws ServiceException {
        String s1 = ":*?\"<>|";
        int i = 0;
        while (i < s.length()) {
            if (s1.indexOf(s.charAt(i)) != -1 && (s.charAt(i) != ':' || i != 1)) {
                throw new ServiceException(315, LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "FileServiceImpl.invalidCharacters", new String[]{s1}));
            }
            ++i;
        }
    }

    private native int win32CopyFile(String var1, String var2, boolean var3) throws ServiceException;

    private native int win32DeleteDirectory(String var1, boolean var2, boolean var3) throws ServiceException;

    public native int win32DeleteFile(String var1) throws ServiceException;

    public native boolean win32EnableAbort(boolean var1);

    protected native String win32GetCommonDirectory();

    protected native String win32GetWindowsDirectory();

    private native int win32MoveFile(String var1, String var2, boolean var3) throws ServiceException;

    private native void win32SetFileCreated(String var1, long var2) throws ServiceException;

    private native void win32SetFileModified(String var1, long var2) throws ServiceException;

    private native void win32SetFileTimes(String var1, long var2, long var4, long var6) throws ServiceException;
}

