/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.win32.Win32Platform;
import com.installshield.wizard.platform.win32.Win32Utils;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.security.GroupSpecification;
import com.installshield.wizard.service.security.PureJavaSecurityServiceImpl;
import com.installshield.wizard.service.security.SecurityServiceImplementor;
import com.installshield.wizard.service.security.UserSpecification;

public class Win32SecurityServiceImpl
extends PureJavaSecurityServiceImpl
implements SecurityServiceImplementor {
    public void createGroup(GroupSpecification groupSpecification) throws ServiceException {
        this.win32CreateGroup(groupSpecification.getGroupName(), groupSpecification.getUsers());
    }

    public void createUser(UserSpecification userSpecification) throws ServiceException {
        String[] stringArray = new String[]{userSpecification.getAccountExpirationDate() < 0L ? Long.toString(userSpecification.getAccountExpirationDate()) : new Long(userSpecification.getAccountExpirationDate() / 1000L).toString(), userSpecification.getDescription(), userSpecification.getHomeDirectory(), userSpecification.getLogonScript(), userSpecification.getPassword(), userSpecification.getUserFullName(), userSpecification.getUserName(), userSpecification.isAccountDisabled() ? "1" : "0", userSpecification.isPasswordChangeRequired() ? "1" : "0"};
        this.win32CreateUser(stringArray, userSpecification.getGroups());
    }

    public native void deleteGroup(String var1) throws ServiceException;

    public native void deleteUser(String var1) throws ServiceException;

    public int getSystemCompatibility() {
        int n = 0;
        try {
            if (Win32Platform.isCompatibleWith(1, 1)) {
                n = 5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    protected void initialized() {
        super.initialized();
        try {
            Win32Utils.loadDLL(this.getResource(Win32Utils.getJNIDLLResourceName()), Win32Utils.getJNIDLLName());
        }
        catch (Exception exception) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "serviceCannotLoadJniDll", new String[]{"securityService", Win32Utils.getJNIDLLName()}));
            exception.printStackTrace();
        }
    }

    public native boolean isCurrentUserAdmin() throws ServiceException;

    public native void win32CreateGroup(String var1, String[] var2) throws ServiceException;

    private native void win32CreateUser(String[] var1, String[] var2) throws ServiceException;
}

