/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32.win32service;

import com.installshield.wizard.WizardAction;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.platform.win32.Win32Service;
import com.installshield.wizard.platform.win32.win32service.NTServiceConfig;
import com.installshield.wizard.platform.win32.win32service.Win2kServiceFailureActions;
import com.installshield.wizard.platform.win32.win32service.Win32ServiceUtils;
import com.installshield.wizard.service.ServiceException;
import java.util.Dictionary;
import java.util.Vector;

public class WindowsServiceCreateAction
extends WizardAction {
    private String name = "";
    private NTServiceConfig config = new NTServiceConfig();
    private boolean enableFailureActions = false;
    private Win2kServiceFailureActions failureActions = new Win2kServiceFailureActions();
    private String serviceDescription = "";
    private boolean startAfterInstalling = true;
    private Vector startArguments = new Vector();
    private String description = "$L(com.installshield.wizard.platform.win32.i18n.Win32Resources, windowsServiceCreateAction.progress, ...)";

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        this.config.validateForBuild(wizardBuilderSupport, this);
        wizardBuilderSupport.putRequiredService("win32Service");
    }

    public Dictionary buildCategories() {
        Dictionary dictionary = super.buildCategories();
        dictionary.put("win32ppk", "");
        return dictionary;
    }

    public void execute(WizardBeanEvent wizardBeanEvent) {
        Win32Service win32Service = null;
        this.getState().setStatusDescription(this.resolveString(this.description));
        NTServiceConfig nTServiceConfig = this.config.resolve(this.getServices());
        Win2kServiceFailureActions win2kServiceFailureActions = this.failureActions.resolve(this.getServices());
        try {
            win32Service = (Win32Service)this.getService("win32Service");
            String[] stringArray = this.getStartArguments();
            this.resolveStrings(stringArray);
            Win32ServiceUtils.installService(win32Service, this.resolveString(this.name), nTServiceConfig, this.enableFailureActions, win2kServiceFailureActions, this.resolveString(this.serviceDescription), this.startAfterInstalling, stringArray, this, this);
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
    }

    public NTServiceConfig getConfig() {
        return this.config;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getEnableFailureActions() {
        return this.enableFailureActions;
    }

    public Win2kServiceFailureActions getFailureActions() {
        return this.failureActions;
    }

    public String getName() {
        return this.name;
    }

    public String getServiceDescription() {
        return this.serviceDescription;
    }

    public boolean getStartAfterInstalling() {
        return this.startAfterInstalling;
    }

    public String[] getStartArguments() {
        Object[] objectArray = new String[this.startArguments.size()];
        this.startArguments.copyInto(objectArray);
        return objectArray;
    }

    private void resolveStrings(String[] stringArray) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = this.resolveString(stringArray[n]);
                ++n;
            }
        }
    }

    public void setConfig(NTServiceConfig nTServiceConfig) {
        this.config = nTServiceConfig;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setEnableFailureActions(boolean bl) {
        this.enableFailureActions = bl;
    }

    public void setFailureActions(Win2kServiceFailureActions win2kServiceFailureActions) {
        this.failureActions = win2kServiceFailureActions;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setServiceDescription(String string) {
        this.serviceDescription = string;
    }

    public void setStartAfterInstalling(boolean bl) {
        this.startAfterInstalling = bl;
    }

    public void setStartArguments(String[] stringArray) {
        this.startArguments.removeAllElements();
        int n = 0;
        while (n < stringArray.length) {
            this.startArguments.addElement(stringArray[n]);
            ++n;
        }
    }
}

