/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service;

import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.StringResolverMethod;
import com.installshield.util.UserInputRequest;
import com.installshield.util.UserInputResponse;
import com.installshield.wizard.Wizard;
import com.installshield.wizard.service.AbstractWizardServices;
import com.installshield.wizard.service.Service;
import com.installshield.wizard.service.ServiceDef;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.ServiceFactory;
import com.installshield.wizard.service.ServicesDefinition;
import com.installshield.wizard.service.WizardServices;
import com.installshield.wizard.service.WizardServicesFactory;
import com.installshield.wizard.service.WizardServicesImpl;
import com.installshield.wizard.service.WizardServicesUI;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class LocalWizardServices
extends AbstractWizardServices {
    private String id;
    private WizardServicesUI ui;
    private Hashtable wizardServices = new Hashtable();
    private Hashtable services = new Hashtable();

    public LocalWizardServices(String string, String string2, ServicesDefinition servicesDefinition, WizardServicesUI wizardServicesUI) {
        this(string, string2, "", servicesDefinition, wizardServicesUI);
    }

    public LocalWizardServices(String string, String string2, String string3, ServicesDefinition servicesDefinition, WizardServicesUI wizardServicesUI) {
        this(string, string2, string2, FileUtils.getParent(string2), string3, servicesDefinition, wizardServicesUI);
    }

    public LocalWizardServices(String string, String string2, String string3, String string4, String string5, ServicesDefinition servicesDefinition, WizardServicesUI wizardServicesUI) {
        super(string, string2, string3, string4, string5, servicesDefinition);
        this.ui = wizardServicesUI;
    }

    protected void addStringResolverMethod(StringResolverMethod stringResolverMethod, int n) {
        this.addStringResolverMethod(stringResolverMethod);
    }

    public void displayUserMessage(String string, String string2, int n) throws ServiceException {
        if (this.ui == null) {
            throw new ServiceException(317);
        }
        String string3 = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "okWithMn");
        this.userInputRequested(new UserInputRequest(string, string2, n, null, string3));
    }

    public Service getService(String string) throws ServiceException {
        Object object = this.services.get(string);
        if (object == null) {
            object = this.loadService(string);
        }
        if (object instanceof Throwable) {
            throw new ServiceException(301, ((Throwable)object).getMessage());
        }
        return (Service)object;
    }

    public Object getUserInput(String string, String string2, Object[] objectArray, Object object) throws ServiceException {
        if (this.ui == null) {
            throw new ServiceException(317);
        }
        UserInputRequest userInputRequest = new UserInputRequest();
        userInputRequest.setTitle(string);
        userInputRequest.setPrompt(string2);
        userInputRequest.setResponseOptions(objectArray);
        if (object != null) {
            userInputRequest.setDefaultResponse(object);
        }
        return this.userInputRequested(userInputRequest).getResponse();
    }

    public WizardServices getWizardServices(String string) throws ServiceException {
        WizardServices wizardServices = (WizardServices)this.wizardServices.get(string);
        if (wizardServices == null) {
            try {
                String string2 = FileUtils.canonizePath(FileUtils.createFileName(FileUtils.getParent(this.getHome()), string));
                if (!new File(string2).exists()) {
                    throw new ServiceException(315, "Wizard home does not exist: " + string2);
                }
                Wizard wizard = Wizard.loadWizard(string2, new String[0]);
                if (wizard.getWizardInf().getResId() == null) {
                    throw new ServiceException(320);
                }
                wizardServices = WizardServicesFactory.createLocalWizardServices(wizard.getWizardInf().getResId(), string2, wizard.getServicesDefinition(), this.ui, wizard.getWizardLog());
                this.wizardServices.put(string, wizardServices);
            }
            catch (Exception exception) {
                throw new ServiceException(exception);
            }
        }
        return wizardServices;
    }

    public boolean isServiceAvailable(String string) throws ServiceException {
        Object object = this.services.get(string);
        if (object == null) {
            object = this.loadService(string);
        }
        return object instanceof Service;
    }

    private Object loadService(String string) {
        if (this.getServicesDefinition() == null) {
            return null;
        }
        try {
            Service service = ServiceFactory.createService(string, this.getServicesDefinition(), this);
            this.services.put(string, service);
            return service;
        }
        catch (ServiceException serviceException) {
            return new Throwable("Could not load service:  " + string);
        }
    }

    public Enumeration services() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.getServicesDefinition().services();
        while (enumeration.hasMoreElements()) {
            vector.addElement(((ServiceDef)enumeration.nextElement()).getName());
        }
        return vector.elements();
    }

    public void setWizardServices(String string, WizardServices wizardServices) throws ServiceException {
        if (wizardServices != null) {
            this.wizardServices.put(string, wizardServices);
        } else {
            this.wizardServices.remove(string);
        }
    }

    public void shutdown() {
        Enumeration enumeration = this.wizardServices.elements();
        while (enumeration.hasMoreElements()) {
            ((WizardServicesImpl)enumeration.nextElement()).shutdown();
        }
        Enumeration enumeration2 = this.services.keys();
        while (enumeration2.hasMoreElements()) {
            Service service = (Service)this.services.get(enumeration2.nextElement());
            try {
                ServiceFactory.shutdownService(service);
            }
            catch (ServiceException serviceException) {
                System.err.println("ERROR shutting down " + service.getName() + ": " + serviceException);
            }
        }
        super.shutdown();
    }

    public UserInputResponse userInputRequested(UserInputRequest userInputRequest) throws ServiceException {
        if (this.ui == null) {
            throw new ServiceException(317);
        }
        return this.ui.userInputRequested(userInputRequest);
    }
}

