/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.panels;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.MnemonicString;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.awt.AWTText;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.awt.DefaultAWTWizardPanelImpl;
import com.installshield.wizard.awt.InsetsPanel;
import com.installshield.wizardx.panels.RebootPanel;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class RebootPanelAWTImpl
extends DefaultAWTWizardPanelImpl
implements ItemListener {
    private AWTText msg = null;
    private Checkbox restartNow = null;
    private Checkbox restartLater = null;

    protected RebootPanel getRP() {
        return (RebootPanel)this.getPanel();
    }

    public void initialize(WizardBeanEvent wizardBeanEvent) {
        super.initialize(wizardBeanEvent);
        this.getContentPane().setLayout(new BorderLayout());
        RebootPanel rebootPanel = (RebootPanel)this.getPanel();
        String string = this.resolveString(rebootPanel.getText());
        this.msg = new AWTText(string, 1, true);
        this.getContentPane().add((Component)this.msg, "Center");
        if (!this.getRP().getRestartWizard()) {
            InsetsPanel insetsPanel = new InsetsPanel(7, 15, 0, 15);
            this.getContentPane().add((Component)insetsPanel, "South");
            insetsPanel.setLayout(new ColumnLayout());
            CheckboxGroup checkboxGroup = new CheckboxGroup();
            String string2 = LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "RebootPanel.restartNow");
            this.restartNow = new Checkbox(MnemonicString.stripMn(string2), checkboxGroup, false);
            insetsPanel.add((Component)this.restartNow, ColumnConstraints.createLeftAlign());
            this.restartNow.addItemListener(this);
            String string3 = LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "RebootPanel.restartLater");
            this.restartLater = new Checkbox(MnemonicString.stripMn(string3), checkboxGroup, false);
            insetsPanel.add((Component)this.restartLater, ColumnConstraints.createLeftAlign());
            this.restartLater.addItemListener(this);
            this.refreshRebootOption();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.restartNow == null) {
            throw new IllegalStateException("panel not initialized -- use initialize(WizardBeanEvent)");
        }
        this.getRP().setPropertyNotification(false);
        this.getRP().setRebootSelected(this.restartNow.getState());
        this.getRP().setPropertyNotification(true);
    }

    public void propertyChanged(String string) {
        super.propertyChanged(string);
        if (string.equals("rebootSelected")) {
            this.refreshRebootOption();
        }
    }

    private void refreshRebootOption() {
        if (this.restartNow != null && this.restartLater != null) {
            if (this.getRP().getRebootSelected()) {
                this.restartNow.setState(true);
            } else {
                this.restartLater.setState(true);
            }
        }
    }
}

