/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.progress;

import com.installshield.util.Progress;
import com.installshield.util.PropertyUtils;
import com.installshield.wizard.awt.AWTProgressRendererImpl;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.awt.ComponentUtils;
import com.installshield.wizard.awt.FlowLabel;
import com.installshield.wizard.awt.ISProgressBar;
import com.installshield.wizard.awt.Spacing;
import com.installshield.wizardx.progress.StandardProgressRenderer;
import java.awt.Button;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Panel;

public class StandardProgressRendererAWTImpl
extends AWTProgressRendererImpl {
    private FlowLabel caption = null;
    private FlowLabel detail = null;
    private Button cancelButton = null;
    private ISProgressBar progressBar = null;
    private boolean isProgressHidden = false;

    public Component getComponent() {
        return this;
    }

    public void initialize() {
        StandardProgressRenderer standardProgressRenderer = (StandardProgressRenderer)this.getProgressRenderer();
        this.setInsets(new Insets(0, 10, 0, 10));
        this.setLayout(new ColumnLayout());
        this.caption = new FlowLabel(" ");
        this.add((Component)this.caption, new ColumnConstraints(1, 2));
        this.add(Spacing.createVerticalSpacing(30));
        this.detail = new FlowLabel(" ");
        this.add((Component)this.detail, ColumnConstraints.createHorizontalFill());
        this.add(Spacing.createVerticalSpacing(4));
        this.progressBar = new ISProgressBar();
        this.add((Component)this.progressBar, ColumnConstraints.createHorizontalFill());
        this.progressBar.setForeground(PropertyUtils.createColor(standardProgressRenderer.getProgressForeground(), this.progressBar.getForeground()));
        this.progressBar.setBackground(PropertyUtils.createColor(standardProgressRenderer.getProgressBackground(), this.progressBar.getBackground()));
        this.add((Component)new Panel(), ColumnConstraints.createVerticalFill());
    }

    public void starting() {
        Font font = this.caption.getFont();
        Font font2 = new Font(font.getName(), 1, font.getSize());
        this.caption.setFont(font2);
        this.progressBar.setProgress(0);
    }

    public void updateProgress(Progress progress) {
        Object object;
        boolean bl = false;
        String string = progress.getStatusDescription();
        if (!string.equals(this.caption.getText())) {
            if (string.length() > 0) {
                object = this.caption.getFont();
                Font font = new Font(((Font)object).getName(), 1, ((Font)object).getSize());
                this.caption.setFont(font);
                this.caption.setText(string);
            } else {
                this.caption.setText(" ");
            }
            bl = true;
        }
        if (!((String)(object = ((StandardProgressRenderer)this.getProgressRenderer()).getWrapDetail() ? progress.getStatusDetail() : ComponentUtils.spliceFileName(progress.getStatusDetail(), this.detail))).equals(this.detail.getText())) {
            if (((String)object).length() > 0) {
                this.detail.setText((String)object);
            } else {
                this.detail.setText(" ");
            }
            bl = true;
        }
        int n = progress.getPercentComplete();
        this.progressBar.setProgress(n);
        if (bl) {
            this.validate();
            this.repaint();
        }
    }
}

