/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.ActiveBox;
import ice.htmlbrowser.Box;
import ice.htmlbrowser.BrowserURLLoader;
import ice.htmlbrowser.DocContainer;
import ice.htmlbrowser.ImageMap;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.net.MalformedURLException;
import java.net.URL;

class BoxImage
extends Box
implements ActiveBox,
ImageObserver {
    private Object size_lock = new Object();
    private int somebits_y;
    private Image image;
    private volatile boolean imageError = false;
    private volatile boolean doImageAnim = false;
    private int iwidth = -1;
    private int iheight = -1;
    private int v_space;
    private int h_space;
    private int v_align = 0;
    private String curLink;
    private String curTargetFrame;
    private boolean is_map = false;
    private boolean use_map = false;
    static final int ALIGN_BOTTOM = 0;
    static final int ALIGN_MIDDLE = 1;
    static final int ALIGN_TOP = 2;

    BoxImage(DocContainer docContainer, String string, int n, int n2) {
        super(docContainer);
        URL uRL;
        this.iwidth = n;
        this.iheight = n2;
        this.image = null;
        try {
            uRL = new URL(this.doc.getDocumentBase(), string);
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        BrowserURLLoader browserURLLoader = new BrowserURLLoader(uRL);
        this.image = browserURLLoader.getImage();
        if (this.image != null) {
            docContainer.registerImage(this.image);
        }
    }

    public synchronized void activeShow() {
        this.doImageAnim = true;
        if (this.image != null) {
            this.doc.prepareImage(this.image, this);
            this.doc.repaintBox(this);
        }
    }

    public void activeHide() {
        this.doImageAnim = false;
        this.imageError = true;
    }

    public void activeInterrupt() {
        this.doImageAnim = false;
    }

    public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        Object object;
        if (this.imageError) {
            return false;
        }
        if ((n & 0xC0) != 0) {
            this.imageError = true;
            object = this.size_lock;
            synchronized (object) {
                this.size_lock.notify();
            }
        }
        if ((n & 3) != 0 && (this.iwidth < 0 || this.iheight < 0)) {
            object = this.size_lock;
            synchronized (object) {
                if ((n & 1) != 0 && this.iwidth < 0) {
                    this.iwidth = n4;
                }
                if ((n & 2) != 0 && this.iheight < 0) {
                    this.iheight = n5;
                }
                if (this.iwidth > 0 && this.iheight > 0) {
                    this.doResize();
                    this.size_lock.notify();
                }
            }
        }
        int n6 = n & 0x38;
        if (this.doImageAnim && n6 != 0) {
            if (n6 == 8) {
                if (n3 - this.somebits_y >= 20) {
                    this.somebits_y = n3;
                }
            } else {
                this.doc.repaintBox(this);
            }
        }
        return (n & 0xE0) == 0;
    }

    void layout(int n, boolean bl) {
        if (!(this.image == null || this.imageError || this.iwidth >= 0 && this.iheight >= 0)) {
            int n2 = this.image.getWidth(this);
            int n3 = this.image.getHeight(this);
            Object object = this.size_lock;
            synchronized (object) {
                if (this.iwidth < 0) {
                    this.iwidth = n2;
                }
                if (this.iheight < 0) {
                    this.iheight = n3;
                }
                if (this.iwidth < 0 || this.iheight < 0) {
                    try {
                        this.size_lock.wait(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        this.doResize();
    }

    void paint(Graphics graphics) {
        if (this.imageError || this.image == null) {
            graphics.setColor(this.color);
            if (this.iwidth < 0 || this.iheight < 0) {
                graphics.draw3DRect(this.h_space + 1, this.v_space + 1, 30, 30, false);
                return;
            }
            graphics.draw3DRect(this.h_space, this.v_space, this.iwidth - 1, this.iheight - 1, false);
            return;
        }
        if (this.backColor != null) {
            graphics.setColor(this.backColor);
            graphics.fillRect(0, 0, this.width, this.height);
            graphics.drawImage(this.image, this.h_space, this.v_space, this.iwidth, this.iheight, this);
            return;
        }
        if (this.doc.getBackgroundImage() != null) {
            graphics.drawImage(this.image, this.h_space, this.v_space, this.iwidth, this.iheight, this);
            return;
        }
        graphics.drawImage(this.image, this.h_space, this.v_space, this.iwidth, this.iheight, this.doc.getBackground(), this);
    }

    void setColor(Color color) {
        if (color.equals(Color.white)) {
            color = color.darker().darker();
        }
        if (color.equals(Color.black)) {
            color = Color.white;
        }
        super.setColor(color);
    }

    private void doResize() {
        if (this.iwidth < 0 || this.iheight < 0) {
            super.resize(32 + this.h_space * 2, 32 + this.v_space * 2);
            return;
        }
        super.resize(this.iwidth + this.h_space * 2, this.iheight + this.v_space * 2);
    }

    void setHSpace(int n) {
        this.h_space = n;
        if (this.link != null) {
            ++this.h_space;
        }
    }

    void setVSpace(int n) {
        this.v_space = n;
        if (this.link != null) {
            ++this.v_space;
        }
    }

    void setVAlign(int n) {
        this.v_align = n;
    }

    int getBaseLine() {
        if (this.v_align == 2 && this.height > 10) {
            return 10;
        }
        if (this.v_align == 1) {
            return this.height / 2;
        }
        return this.height;
    }

    void setLink(String string, String string2) {
        this.curLink = string;
        this.curTargetFrame = string2;
        super.setLink(string, string2);
    }

    void setIsMap(boolean bl) {
        this.is_map = bl;
    }

    void setUseMap(String string) {
        this.use_map = true;
        this.setLink(string, this.linkTargetFrame);
    }

    boolean isImageMap() {
        return this.is_map || this.use_map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Box mouseClicked(int n, int n2) {
        if (this.link == null) return null;
        if (this.use_map) {
            ImageMap imageMap = this.doc.getImageMap(this.link);
            if (imageMap == null || !imageMap.findLink(n, n2, this.width, this.height)) return null;
            this.curLink = imageMap.getLink();
            this.curTargetFrame = imageMap.getLinkTargetFrame();
            return this;
        } else {
            if (!this.is_map) return this;
            this.curLink = String.valueOf(this.link) + "?" + String.valueOf(n) + "," + String.valueOf(n2);
            this.curTargetFrame = this.linkTargetFrame;
        }
        return this;
    }

    Box mouseMoved(int n, int n2) {
        return this.mouseClicked(n, n2);
    }

    String getLink() {
        return this.curLink;
    }

    String getLinkTargetFrame() {
        return this.curTargetFrame;
    }
}

