/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.AuthDialog;
import ice.htmlbrowser.Htuu;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;

class BrowserTools
implements FilenameFilter {
    private static String cwd;
    private FileDialog fd;
    private static Hashtable authByRealm;
    private static Hashtable authByLocation;
    private Frame frameHandle;

    BrowserTools(Frame frame) {
        this.frameHandle = frame;
    }

    BrowserTools(Component component) {
        this.frameHandle = BrowserTools.findFrame(component);
    }

    static void nukeAuthCache(String string, URL uRL) {
        authByRealm.remove(string);
        if (uRL != null) {
            authByLocation.remove(BrowserTools.stripLoc(uRL));
        }
    }

    static String getAuthForLocation(URL uRL) {
        return (String)authByLocation.get(BrowserTools.stripLoc(uRL));
    }

    synchronized String getAuthForRealm(String string, URL uRL) {
        String string2 = (String)authByRealm.get(string);
        if (string2 == null) {
            AuthDialog authDialog = new AuthDialog(this.frameHandle, string);
            String string3 = authDialog.getAuthName();
            String string4 = authDialog.getAuthPassword();
            if (string3 == null || string4 == null) {
                string2 = null;
            } else {
                string2 = "Basic " + Htuu.encode(String.valueOf(string3) + ":" + string4);
                authByRealm.put(string, string2);
            }
        }
        if (string2 != null && uRL != null) {
            authByLocation.put(BrowserTools.stripLoc(uRL), string2);
        }
        return string2;
    }

    private static String stripLoc(URL uRL) {
        String string = uRL.toExternalForm();
        int n = string.indexOf(63);
        if (n > 0) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf(35)) > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    void saveFromStream(InputStream inputStream, String string) {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        this.fd = new FileDialog(this.frameHandle, "Save to file", 1);
        if (cwd == null) {
            this.updateCwd(System.getProperty("user.dir"));
        }
        System.out.println("FILENAME: " + string);
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            this.fd.setFile(string);
        }
        this.fd.setDirectory(cwd);
        this.fd.setFilenameFilter(this);
        this.fd.show();
        if (this.fd.getFilenameFilter() != this) {
            throw new RuntimeException("Internal Error");
        }
        if (this.fd.getFile() == null) {
            return;
        }
        this.updateCwd(this.fd.getDirectory());
        try {
            int n;
            File file = new File(this.fd.getDirectory());
            File file2 = new File(file, this.fd.getFile());
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            while ((n = bufferedInputStream.read()) != -1) {
                fileOutputStream.write(n);
            }
            ((FilterInputStream)bufferedInputStream).close();
            fileOutputStream.close();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public boolean accept(File file, String string) {
        return true;
    }

    private synchronized void updateCwd(String string) {
        cwd = string;
    }

    static Frame findFrame(Component component) {
        Component component2 = component;
        while (component2 != null) {
            if (component2 instanceof Frame) {
                return (Frame)component2;
            }
            component2 = component2.getParent();
        }
        return null;
    }

    static boolean sameFile(URL uRL, URL uRL2) {
        if (uRL == null || uRL2 == null) {
            return false;
        }
        if (!uRL.getProtocol().equals(uRL2.getProtocol())) {
            return false;
        }
        if (!uRL.getFile().equals(uRL2.getFile())) {
            return false;
        }
        if (uRL.getPort() != uRL2.getPort()) {
            return false;
        }
        String string = uRL.getHost();
        String string2 = uRL2.getHost();
        if (string == null || string.equals("")) {
            string = "localhost";
        }
        if (string2 == null || string2.equals("")) {
            string2 = "localhost";
        }
        return string.equals(string2);
    }

    static {
        authByRealm = new Hashtable();
        authByLocation = new Hashtable();
    }
}

