/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.Browser;
import ice.htmlbrowser.BrowserTools;
import ice.htmlbrowser.Document;
import ice.htmlbrowser.DocumentFrame;
import ice.htmlbrowser.FontInfo;
import ice.htmlbrowser.FrameHistory;
import ice.htmlbrowser.LexCache;
import ice.htmlbrowser.LexCacheCell;
import ice.htmlbrowser.MouseOverLinkEvent;
import ice.htmlbrowser.Queue;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.event.MouseEvent;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import java.util.Vector;

class FrameInfo {
    private Stack framesetStack;
    private boolean isFrameset;
    private String name;
    private Document parent;
    private URL baseURL;
    private URL prevURL;
    private boolean baseChangeFlag = false;
    private int frameNameCounter;
    private String progress = "_self 0 0";
    private DocumentFrame doc;
    private int marginWidth = 10;
    private int marginHeight = 10;
    private int[] colValues = new int[]{100};
    private int[] colTypes = new int[]{1};
    private int[] rowValues = new int[]{100};
    private int[] rowTypes = new int[]{1};
    private Vector frames;

    private void addFrame(FrameInfo frameinfo) {
        if (!this.isFrameset) {
            return;
        }
        if (this.frames.size() < this.colValues.length * this.rowValues.length) {
            this.frames.addElement(frameinfo);
        }
    }

    void passScrollPosition() {
        if (this.parent.getCurrentFrame().equals(this.name)) {
            this.parent.firePropertyChange("scrollPosition", null, this.getScrollPosition());
        }
    }

    void printDoc(PrintJob printjob) {
        if (!this.isFrameset && this.doc != null) {
            this.doc.printDoc(printjob);
        }
    }

    void addNames(Vector vector) {
        vector.addElement(this.name);
        if (this.isFrameset) {
            if (this.frames.size() < 1) {
                return;
            }
            int i = 0;
            while (i < this.frames.size()) {
                ((FrameInfo)this.frames.elementAt(i)).addNames(vector);
                ++i;
            }
        }
    }

    Dimension getDocumentSize() {
        if (!this.isFrameset && this.doc != null) {
            return this.doc.getDocumentSize();
        }
        return new Dimension(0, 0);
    }

    private String makeFrameName(FrameInfo frameinfo) {
        String s = frameinfo.getName() + "#" + frameinfo.frameNameCounter;
        ++frameinfo.frameNameCounter;
        return s;
    }

    void processEvent(AWTEvent awtevent) {
        this.parent.processEvent(awtevent);
    }

    void htmlAppend(String s) {
        if (this.isFrameset) {
            this.htmlClear();
        }
        this.doc.htmlAppend(new StringReader(s), "text/html", s.length());
    }

    void htmlAppend(Reader reader, String s) {
        if (this.isFrameset) {
            this.htmlClear();
        }
        this.doc.htmlAppend(reader, s, -1);
    }

    void htmlAppend(String s, String s1) {
        LexCacheCell lexcachecell;
        if (this.isFrameset) {
            this.htmlClear();
        }
        try {
            this.setDocumentBaseString(s);
        }
        catch (MalformedURLException _ex) {
            this.htmlAppend("");
            return;
        }
        this.setDocumentTitle(this.getDocumentBaseString());
        LexCache lexcache = Browser.getLexCache();
        if (lexcache != null && this.baseURL != null && s1 == null && (lexcachecell = lexcache.getCachedURL(this.baseURL)) != null) {
            this.doc.htmlAppend(lexcachecell, lexcachecell.getMimeType(), lexcachecell.getLength());
            this.doc.setWaitForRef(this.baseURL);
            return;
        }
        this.doc.htmlAppend(this.baseURL, s1);
    }

    void parseEndFrameset() {
        if (!this.framesetStack.empty()) {
            FrameInfo frameinfo = (FrameInfo)this.framesetStack.pop();
            if (!this.framesetStack.empty()) {
                FrameInfo frameinfo1 = (FrameInfo)this.framesetStack.peek();
                frameinfo1.addFrame(frameinfo);
                return;
            }
            if (this.isFrameset) {
                this.removeFrames();
            }
            this.isFrameset = true;
            this.frames.addElement(frameinfo);
            if (this.doc != null) {
                this.parent.remove(this.doc);
                DocumentFrame documentframe = this.doc;
                this.doc = null;
                this.parent.validate();
                documentframe.htmlEndDocument();
            }
        }
    }

    void restore(Queue queue) {
        if (queue.empty()) {
            return;
        }
        FrameHistory framehistory = (FrameHistory)queue.pop();
        queue.push(framehistory);
        this.name = framehistory.name;
        if (framehistory.isFrameset) {
            if (!this.isFrameset || framehistory.numSubFrames != this.frames.size() || !framehistory.loc.equals(this.getDocumentBaseString())) {
                this.removeFrames();
                this.isFrameset = true;
                this.colValues = framehistory.colValues;
                this.colTypes = framehistory.colTypes;
                this.rowValues = framehistory.rowValues;
                this.rowTypes = framehistory.rowTypes;
                try {
                    this.setDocumentBaseString(framehistory.loc);
                }
                catch (MalformedURLException _ex) {
                    // empty catch block
                }
                int i = 0;
                while (i < framehistory.numSubFrames) {
                    FrameInfo frameinfo = new FrameInfo(this.parent, "temp");
                    this.frames.addElement(frameinfo);
                    frameinfo.restore(queue);
                    ++i;
                }
                return;
            }
            int j = 0;
            while (j < this.frames.size()) {
                ((FrameInfo)this.frames.elementAt(j)).restore(queue);
                ++j;
            }
            return;
        }
        this.setCurrentLocation(framehistory.loc, null, framehistory.pos);
    }

    void htmlInterrupt() {
        if (this.doc != null) {
            this.doc.htmlInterrupt();
        }
    }

    private void doLayoutFrame(int i, int j, int k, int l) {
        if (this.doc != null) {
            this.doc.setBounds(i, j, k, l);
        }
    }

    void setScrollPosition(int i, int j) {
        if (!this.isFrameset && this.doc != null) {
            this.doc.setScrollPosition(i, j);
        }
    }

    Point getScrollPosition() {
        if (!this.isFrameset && this.doc != null) {
            return this.doc.getScrollPosition();
        }
        return new Point(0, 0);
    }

    void htmlWait(boolean flag) {
        if (this.doc != null) {
            this.doc.htmlWait(flag);
        }
    }

    void save(Queue queue) {
        if (this.isFrameset) {
            if (this.frames.size() < 1) {
                return;
            }
            FrameHistory framehistory = new FrameHistory(this.getDocumentBaseString(), this.name, this.colValues, this.colTypes, this.rowValues, this.rowTypes, this.frames.size());
            queue.push(framehistory);
            int i = 0;
            while (i < this.frames.size()) {
                ((FrameInfo)this.frames.elementAt(i)).save(queue);
                ++i;
            }
            return;
        }
        FrameHistory framehistory1 = new FrameHistory(this.getDocumentBaseString(), this.name, this.doc.getScrollPosition());
        queue.push(framehistory1);
    }

    void restart() {
        this.removeFrames();
        this.isFrameset = true;
    }

    void showStatus(String s) {
        this.parent.setStatusString(s);
    }

    String getName() {
        return this.name;
    }

    Dimension getViewportSize() {
        if (!this.isFrameset && this.doc != null) {
            return this.doc.getViewportSize();
        }
        return new Dimension(0, 0);
    }

    int getMarginHeight() {
        return this.marginHeight;
    }

    void parseBeginFrameset(int[] ai, int[] ai1, int[] ai2, int[] ai3) {
        FrameInfo frameinfo = this;
        if (!this.framesetStack.empty()) {
            frameinfo = (FrameInfo)this.framesetStack.peek();
        }
        FrameInfo frameinfo1 = new FrameInfo(this.parent, this.makeFrameName(frameinfo), ai, ai1, ai2, ai3);
        this.framesetStack.push(frameinfo1);
    }

    void doLayout(int i, int j, int k, int l) {
        if (this.isFrameset) {
            this.doLayoutFrameset(i, j, k, l);
            return;
        }
        if (this.doc != null) {
            this.doc.setBounds(i, j, k, l);
        }
    }

    void setDocumentTitle(String s) {
        if ("_top".equals(this.name)) {
            this.parent.setDocumentTitle(s);
        }
    }

    String getSelectedText() {
        return this.doc.getSelectedText();
    }

    void passParsingProgress(int i, int j) {
        this.progress = i + " " + j + " " + this.name;
        this.parent.firePropertyChange("parsingProgress", null, this.progress);
    }

    int search(int i, String s) {
        if (this.isFrameset) {
            return -1;
        }
        return this.doc.search(i, s);
    }

    private void doLayoutFrameset(int i, int j, int k, int l) {
        int[] ai = new int[this.colValues.length];
        int[] ai1 = new int[this.rowValues.length];
        int i1 = k;
        int j1 = 0;
        int k1 = 0;
        while (k1 < this.colValues.length) {
            if (this.colTypes[k1] == 1) {
                int j3 = this.colValues[k1] * k / 100;
                i1 -= j3;
                ai[k1] = j3;
            } else if (this.colTypes[k1] == 2) {
                j1 += this.colValues[k1];
                ai[k1] = 0;
            } else {
                i1 -= this.colValues[k1];
                ai[k1] = this.colValues[k1];
            }
            ++k1;
        }
        if (i1 > 0 && j1 > 0) {
            int l1 = 0;
            while (l1 < this.colValues.length) {
                if (this.colTypes[l1] == 2) {
                    ai[l1] = i1 * this.colValues[l1] / j1;
                }
                ++l1;
            }
        } else if (i1 != 0) {
            int i2 = 0;
            while (i2 < this.colValues.length) {
                int n = i2;
                ai[n] = ai[n] + i1 * ai[i2] / (k - i1);
                ++i2;
            }
        }
        i1 = l;
        j1 = 0;
        int j2 = 0;
        while (j2 < this.rowValues.length) {
            if (this.rowTypes[j2] == 1) {
                int k3 = this.rowValues[j2] * l / 100;
                i1 -= k3;
                ai1[j2] = k3;
            } else if (this.rowTypes[j2] == 2) {
                j1 += this.rowValues[j2];
                ai1[j2] = 0;
            } else {
                i1 -= this.rowValues[j2];
                ai1[j2] = this.rowValues[j2];
            }
            ++j2;
        }
        if (i1 > 0 && j1 > 0) {
            int k2 = 0;
            while (k2 < this.rowValues.length) {
                if (this.rowTypes[k2] == 2) {
                    ai1[k2] = i1 * this.rowValues[k2] / j1;
                }
                ++k2;
            }
        } else if (i1 != 0) {
            int l2 = 0;
            while (l2 < this.rowValues.length) {
                int n = l2;
                ai1[n] = ai1[n] + i1 * ai1[l2] / (l - i1);
                ++l2;
            }
        }
        int l3 = this.frames.size();
        int i4 = 0;
        int j4 = 0;
        int k4 = i;
        int l4 = j;
        int i3 = 0;
        while (i3 < l3) {
            FrameInfo frameinfo = (FrameInfo)this.frames.elementAt(i3);
            frameinfo.doLayout(k4, l4, ai[i4], ai1[j4]);
            k4 += ai[i4];
            if (++i4 >= ai.length) {
                i4 = 0;
                k4 = i;
                l4 += ai1[j4];
                ++j4;
            }
            ++i3;
        }
    }

    String getEncoding() {
        return this.parent.getEncoding();
    }

    FrameInfo(Document document, String s) {
        this.framesetStack = new Stack();
        this.frames = new Vector();
        this.parent = document;
        this.name = s;
        this.isFrameset = true;
    }

    private FrameInfo(Document document, String s, int[] ai, int[] ai1, int[] ai2, int[] ai3) {
        this.framesetStack = new Stack();
        this.frames = new Vector();
        this.parent = document;
        this.name = s;
        this.colValues = ai;
        this.colTypes = ai1;
        this.rowValues = ai2;
        this.rowTypes = ai3;
        this.isFrameset = true;
    }

    private FrameInfo(Document document, String s, String s1, String s2, int i, int j, int k) {
        this.framesetStack = new Stack();
        this.frames = new Vector();
        this.parent = document;
        this.name = s1;
        this.isFrameset = false;
        this.doc = new DocumentFrame(this, k);
        document.add(this.doc);
        this.marginWidth = i;
        this.marginHeight = j;
        this.htmlAppend(s, s2);
    }

    URL getReferer() {
        return this.prevURL;
    }

    FrameInfo findFrame(String s) {
        if (s.equals(this.name)) {
            return this;
        }
        FrameInfo frameinfo = null;
        if (this.isFrameset) {
            int j = this.frames.size();
            int i = 0;
            while (i < j && frameinfo == null) {
                frameinfo = (FrameInfo)this.frames.elementAt(i);
                frameinfo = frameinfo.findFrame(s);
                ++i;
            }
        }
        return frameinfo;
    }

    URL getDocumentBase() {
        return this.baseURL;
    }

    void setDocumentBase(URL url) {
        this.baseURL = url;
        this.baseChangeFlag = true;
        if ("_top".equals(this.name)) {
            this.parent.firePropertyChange("documentBase", null, this.getDocumentBaseString());
        }
        this.baseChangeFlag = false;
    }

    String getDocumentBaseString() {
        if (this.baseURL == null) {
            return "";
        }
        return this.baseURL.toString();
    }

    void setDocumentBaseString(String s) throws MalformedURLException {
        if (this.baseChangeFlag) {
            return;
        }
        this.prevURL = this.baseURL;
        this.baseURL = this.baseURL == null ? new URL(s) : new URL(this.baseURL, s);
        this.setDocumentBase(this.baseURL);
    }

    void passMouseOverLink(int i, String s, String s1, String s2, MouseEvent mouseevent) {
        if (s1.equals("_self")) {
            s1 = this.name;
        }
        try {
            if (s.startsWith("#")) {
                s = this.baseURL.getFile() + s;
            }
            URL url = new URL(this.baseURL, s);
            s = url.toString();
        }
        catch (MalformedURLException _ex) {
            // empty catch block
        }
        MouseOverLinkEvent mouseoverlinkevent = new MouseOverLinkEvent(i, s, s1, s2, mouseevent);
        this.parent.fireMouseOverLink(mouseoverlinkevent);
    }

    int getMarginWidth() {
        return this.marginWidth;
    }

    String getParsingProgress() {
        return this.progress;
    }

    private void removeFrames() {
        if (this.isFrameset) {
            int j = this.frames.size();
            int i = 0;
            while (i < j) {
                FrameInfo frameinfo = (FrameInfo)this.frames.elementAt(i);
                frameinfo.removeFrames();
                ++i;
            }
            this.frames = new Vector();
        } else if (this.doc != null) {
            this.doc.htmlEndDocument();
            this.parent.remove(this.doc);
            this.doc = null;
        }
        this.frameNameCounter = 0;
    }

    private void setCurrentLocation(String s, String s1, Point point) {
        if (this.isFrameset) {
            this.htmlAppend(s, s1);
            if (point != null) {
                this.doc.setWaitForPos(point);
            }
            return;
        }
        URL url = null;
        try {
            url = new URL(this.baseURL, s);
        }
        catch (MalformedURLException _ex) {
            // empty catch block
        }
        if (s1 == null && BrowserTools.sameFile(url, this.baseURL)) {
            this.prevURL = this.baseURL;
            this.setDocumentBase(url);
            this.doc.setWaitForRef(this.baseURL);
            if (point != null) {
                this.doc.setWaitForPos(point);
            }
            this.doc.finalDocumentDimension(false);
            return;
        }
        this.htmlClear();
        this.htmlAppend(s, s1);
        if (point != null) {
            this.doc.setWaitForPos(point);
        }
    }

    void setCurrentLocation(String s, String s1) {
        this.setCurrentLocation(s, s1, null);
    }

    void htmlClear() {
        if (this.isFrameset) {
            this.removeFrames();
            this.isFrameset = false;
            this.doc = new DocumentFrame(this, 0);
            this.parent.add(this.doc);
            this.parent.validate();
        } else {
            this.doc.htmlEndDocument();
            this.doc.htmlBeginDocument();
        }
        this.setDocumentTitle("empty");
    }

    void dispose() {
        this.removeFrames();
    }

    FontInfo getFontInfo() {
        return this.parent.getFontInfo();
    }

    void parseAddFrame(String s, String s1, int i, int j, int k) {
        FrameInfo frameinfo = this;
        if (!this.framesetStack.empty()) {
            frameinfo = (FrameInfo)this.framesetStack.peek();
        }
        try {
            if (k < 0) {
                k = 0;
            }
            if (i >= 0 || j >= 0) {
                if (i < 0) {
                    i = 0;
                }
                if (j < 0) {
                    j = 0;
                }
            } else {
                j = 10;
                i = 10;
            }
            URL url = new URL(this.getDocumentBase(), s);
            if (frameinfo.frames.size() >= frameinfo.colValues.length * frameinfo.rowValues.length) {
                return;
            }
            if (s1 == null) {
                s1 = this.makeFrameName(frameinfo);
            }
            FrameInfo frameinfo1 = new FrameInfo(this.parent, url.toString(), s1, null, i, j, k);
            frameinfo.addFrame(frameinfo1);
            return;
        }
        catch (MalformedURLException _ex) {
            return;
        }
    }
}

