/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.LexCache;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;

class LexCacheCell
extends Reader {
    URL url;
    int firstCluster;
    int size;
    boolean inuse;
    private LexCache cache;
    private int pos;
    private int end_pos;
    private char[] data;
    private String mimeType;
    private int readerPos;
    private int readerEnd;
    private int readerCluster;
    private int readerCount;

    LexCacheCell(LexCache lexCache, URL uRL, String string, int n) {
        this.cache = lexCache;
        this.url = uRL;
        this.mimeType = string;
        this.firstCluster = n;
        this.data = lexCache.cache;
        this.restartCaching();
    }

    void appendChar(int n) {
        if (this.pos >= this.end_pos) {
            int n2 = this.cache.allocCluster(this.firstCluster);
            this.pos = n2 * 8192;
            this.end_pos = this.pos + 8192;
        }
        this.data[this.pos] = (char)n;
        ++this.pos;
    }

    void restartCaching() {
        this.inuse = false;
        this.size = 0;
        this.pos = this.firstCluster * 8192;
        this.end_pos = this.pos + 8192;
    }

    void endCaching() {
        this.size = this.cache.countClusters(this.firstCluster);
        this.size = this.size * 8192 - this.end_pos + this.pos;
        this.inuse = false;
    }

    void initReader() {
        this.readerCluster = this.firstCluster;
        this.readerPos = this.readerCluster * 8192;
        this.readerEnd = this.readerPos + 8192;
        this.readerCount = this.size;
        this.inuse = true;
    }

    String getMimeType() {
        return this.mimeType;
    }

    int getLength() {
        return this.size;
    }

    public int read() throws IOException {
        if (this.readerCount <= 0) {
            this.inuse = false;
            return -1;
        }
        if (this.readerPos >= this.readerEnd) {
            this.readerCluster = this.cache.nextCluster[this.readerCluster];
            this.readerPos = this.readerCluster * 8192;
            this.readerEnd = this.readerPos + 8192;
        }
        char c = this.data[this.readerPos];
        ++this.readerPos;
        --this.readerCount;
        return c;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n2 > 0) {
            int n4 = this.read();
            if (n4 < 0) break;
            cArray[n + n3] = (char)n4;
            --n2;
            ++n3;
        }
        if (n3 == 0) {
            n3 = -1;
        }
        return n3;
    }

    public void close() {
        this.inuse = false;
    }
}

