/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.HostAddresses;
import com.ibm.security.krb5.internal.HostAddress;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.krb5.internal.KrbCredInfo;
import com.ibm.security.krb5.internal.RealmException;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;

public class EncKrbCredPart {
    public KrbCredInfo[] ticketInfo;
    public Integer nonce;
    public KerberosTime timeStamp;
    public Integer usec;
    public HostAddress sAddress;
    public HostAddresses rAddress;

    public EncKrbCredPart(KrbCredInfo[] krbCredInfoArray, KerberosTime kerberosTime, Integer n2, Integer n3, HostAddress hostAddress, HostAddresses hostAddresses) {
        this.ticketInfo = krbCredInfoArray;
        this.nonce = n3;
        this.timeStamp = kerberosTime;
        this.usec = n2;
        this.sAddress = hostAddress;
        this.rAddress = hostAddresses;
    }

    public EncKrbCredPart(byte[] byArray) throws Asn1Exception, IOException, RealmException {
        this.a(new DerValue(byArray));
    }

    public EncKrbCredPart(DerValue derValue) throws Asn1Exception, IOException, RealmException {
        this.a(derValue);
    }

    private void a(DerValue derValue) throws Asn1Exception, IOException, RealmException {
        this.nonce = null;
        this.timeStamp = null;
        this.usec = null;
        this.sAddress = null;
        this.rAddress = null;
        if ((derValue.getTag() & 0x1F) != 29 || !derValue.isApplication() || !derValue.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) == 0) {
            DerValue[] derValueArray = derValue3.getData().getSequence(1);
            this.ticketInfo = new KrbCredInfo[derValueArray.length];
            for (int i2 = 0; i2 < derValueArray.length; ++i2) {
                this.ticketInfo[i2] = new KrbCredInfo(derValueArray[i2]);
            }
        } else {
            throw new Asn1Exception(906);
        }
        if (derValue2.getData().available() > 0 && ((byte)derValue2.getData().peekByte() & 0x1F) == 1) {
            derValue3 = derValue2.getData().getDerValue();
            this.nonce = new Integer(derValue3.getData().getBigInteger().intValue());
        }
        if (derValue2.getData().available() > 0) {
            this.timeStamp = KerberosTime.parse(derValue2.getData(), (byte)2, true);
        }
        if (derValue2.getData().available() > 0 && ((byte)derValue2.getData().peekByte() & 0x1F) == 3) {
            derValue3 = derValue2.getData().getDerValue();
            this.usec = new Integer(derValue3.getData().getBigInteger().intValue());
        }
        if (derValue2.getData().available() > 0) {
            this.sAddress = HostAddress.parse(derValue2.getData(), (byte)4, true);
        }
        if (derValue2.getData().available() > 0) {
            this.rAddress = HostAddresses.parse(derValue2.getData(), (byte)5, true);
        }
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerValue[] derValueArray = new DerValue[this.ticketInfo.length];
        for (int i2 = 0; i2 < this.ticketInfo.length; ++i2) {
            derValueArray[i2] = new DerValue(this.ticketInfo[i2].asn1Encode());
        }
        derOutputStream2.putSequence(derValueArray);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream2);
        if (this.nonce != null) {
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putInteger(BigInteger.valueOf(this.nonce.intValue()));
            derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream2);
        }
        if (this.timeStamp != null) {
            derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), this.timeStamp.asn1Encode());
        }
        if (this.usec != null) {
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putInteger(BigInteger.valueOf(this.usec.intValue()));
            derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)3), derOutputStream2);
        }
        if (this.sAddress != null) {
            derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)4), this.sAddress.asn1Encode());
        }
        if (this.rAddress != null) {
            derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)5), this.rAddress.asn1Encode());
        }
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        derOutputStream = new DerOutputStream();
        derOutputStream.write(DerValue.createTag((byte)64, (boolean)true, (byte)29), derOutputStream2);
        return derOutputStream.toByteArray();
    }
}

