/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.Krb5Debug;
import com.ibm.security.krb5.internal.KrbApErrException;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class HostAddress
implements Cloneable {
    public int addrType;
    public byte[] address;
    private static byte[] a;
    private static String[] z;

    private HostAddress(int n2) {
    }

    public Object clone() {
        HostAddress hostAddress = new HostAddress(0);
        hostAddress.addrType = this.addrType;
        if (this.address != null) {
            hostAddress.address = new byte[this.address.length];
            System.arraycopy(this.address, 0, hostAddress.address, 0, this.address.length);
        }
        return hostAddress;
    }

    public boolean equals(HostAddress hostAddress) {
        if (this.addrType != hostAddress.addrType || this.address != null && hostAddress.address == null || this.address == null && hostAddress.address != null) {
            return false;
        }
        if (this.address != null && hostAddress.address != null) {
            if (this.address.length != hostAddress.address.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.address.length; ++i2) {
                if (this.address[i2] == hostAddress.address[i2]) continue;
                return false;
            }
        }
        return true;
    }

    public static void refreshLocalInetAddress() throws UnknownHostException {
        a = InetAddress.getLocalHost().getAddress();
    }

    public static byte[] getLocalInetAddress() throws UnknownHostException {
        if (a == null) {
            HostAddress.refreshLocalInetAddress();
        }
        if (a == null) {
            throw new UnknownHostException();
        }
        byte[] byArray = new byte[a.length];
        System.arraycopy(a, 0, byArray, 0, a.length);
        return byArray;
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        if (this.addrType == 2 || this.addrType == 23) {
            return InetAddress.getByAddress(this.address);
        }
        return null;
    }

    private int a(InetAddress inetAddress) {
        int n2 = 0;
        if (inetAddress instanceof Inet4Address) {
            n2 = 2;
        } else if (inetAddress instanceof Inet6Address) {
            n2 = 23;
        }
        return n2;
    }

    public HostAddress() throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByAddress(HostAddress.getLocalInetAddress());
        this.addrType = this.a(inetAddress);
        this.address = inetAddress.getAddress();
    }

    public HostAddress(int n2, byte[] byArray) throws KrbApErrException {
        switch (n2) {
            case 2: {
                if (byArray.length == 4) break;
                throw new KrbApErrException(0, z[4]);
            }
            case 5: {
                if (byArray.length == 2) break;
                throw new KrbApErrException(0, z[0]);
            }
            case 7: {
                break;
            }
            case 6: {
                if (byArray.length == 6) break;
                throw new KrbApErrException(0, z[5]);
            }
            case 16: {
                if (byArray.length == 3) break;
                throw new KrbApErrException(0, z[1]);
            }
            case 12: {
                if (byArray.length == 2) break;
                throw new KrbApErrException(0, z[6]);
            }
            case 24: {
                if (byArray.length == 16) break;
                throw new KrbApErrException(0, z[2]);
            }
        }
        this.addrType = n2;
        this.address = byArray;
        if (Krb5Debug.on(5) && this.addrType == 2) {
            Krb5Debug krb5Debug = new Krb5Debug(z[7] + Thread.currentThread().getName() + z[3]);
            krb5Debug.out(5, z[8] + (this.address[0] & 0xFF) + "." + (this.address[1] & 0xFF) + "." + (this.address[2] & 0xFF) + "." + (this.address[3] & 0xFF));
        }
    }

    public HostAddress(InetAddress inetAddress) {
        this.addrType = this.a(inetAddress);
        byte[] byArray = inetAddress.getAddress();
        this.address = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.address, 0, byArray.length);
    }

    public HostAddress(DerValue derValue) throws Asn1Exception, IOException {
        DerValue derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.addrType = derValue2.getData().getBigInteger().intValue();
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.address = derValue2.getData().getOctetString();
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.addrType);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.address);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public static HostAddress parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new HostAddress(derValue2);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block98: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block97: {
                char[] cArray3;
                Object var0;
                block96: {
                    int n5;
                    int n6;
                    char[] cArray4;
                    block95: {
                        char[] cArray5;
                        block94: {
                            int n7;
                            int n8;
                            char[] cArray6;
                            block93: {
                                char[] cArray7;
                                block92: {
                                    int n9;
                                    int n10;
                                    char[] cArray8;
                                    block91: {
                                        char[] cArray9;
                                        block90: {
                                            int n11;
                                            int n12;
                                            char[] cArray10;
                                            block89: {
                                                char[] cArray11;
                                                block88: {
                                                    int n13;
                                                    int n14;
                                                    char[] cArray12;
                                                    block87: {
                                                        char[] cArray13;
                                                        block86: {
                                                            int n15;
                                                            int n16;
                                                            char[] cArray14;
                                                            block85: {
                                                                char[] cArray15;
                                                                block84: {
                                                                    int n17;
                                                                    int n18;
                                                                    char[] cArray16;
                                                                    block83: {
                                                                        char[] cArray17;
                                                                        block82: {
                                                                            int n19;
                                                                            int n20;
                                                                            char[] cArray18;
                                                                            block81: {
                                                                                stringArray = new String[9];
                                                                                var0 = null;
                                                                                char[] cArray19 = "P\u001a4\u0012OS4\u0003\u0010cv\t5\"t".toCharArray();
                                                                                n4 = 0;
                                                                                int n21 = cArray19.length;
                                                                                cArray18 = cArray19;
                                                                                n20 = n21;
                                                                                if (n21 <= 1) break block81;
                                                                                cArray17 = cArray18;
                                                                                n19 = n20;
                                                                                if (n20 <= n4) break block82;
                                                                            }
                                                                            do {
                                                                                char[] cArray20 = cArray18;
                                                                                char[] cArray21 = cArray18;
                                                                                int n22 = n4;
                                                                                while (true) {
                                                                                    int n23;
                                                                                    char c2 = cArray20[n22];
                                                                                    switch (n4 % 5) {
                                                                                        case 0: {
                                                                                            n23 = 18;
                                                                                            break;
                                                                                        }
                                                                                        case 1: {
                                                                                            n23 = 123;
                                                                                            break;
                                                                                        }
                                                                                        case 2: {
                                                                                            n23 = 80;
                                                                                            break;
                                                                                        }
                                                                                        case 3: {
                                                                                            n23 = 81;
                                                                                            break;
                                                                                        }
                                                                                        default: {
                                                                                            n23 = 7;
                                                                                        }
                                                                                    }
                                                                                    cArray20[n22] = (char)(c2 ^ n23);
                                                                                    ++n4;
                                                                                    cArray18 = cArray21;
                                                                                    n20 = n20;
                                                                                    if (n20 != 0) break;
                                                                                    cArray21 = cArray18;
                                                                                    n19 = n20;
                                                                                    n22 = n20;
                                                                                    cArray20 = cArray18;
                                                                                }
                                                                                cArray17 = cArray18;
                                                                                n19 = n20;
                                                                            } while (n20 > n4);
                                                                        }
                                                                        stringArray[0] = new String(cArray17).intern();
                                                                        var0 = null;
                                                                        char[] cArray22 = "P\u001a4\u0015CB:45uw\b#".toCharArray();
                                                                        n4 = 0;
                                                                        int n24 = cArray22.length;
                                                                        cArray16 = cArray22;
                                                                        n18 = n24;
                                                                        if (n24 <= 1) break block83;
                                                                        cArray15 = cArray16;
                                                                        n17 = n18;
                                                                        if (n18 <= n4) break block84;
                                                                    }
                                                                    do {
                                                                        char[] cArray23 = cArray16;
                                                                        char[] cArray24 = cArray16;
                                                                        int n25 = n4;
                                                                        while (true) {
                                                                            int n26;
                                                                            char c3 = cArray23[n25];
                                                                            switch (n4 % 5) {
                                                                                case 0: {
                                                                                    n26 = 18;
                                                                                    break;
                                                                                }
                                                                                case 1: {
                                                                                    n26 = 123;
                                                                                    break;
                                                                                }
                                                                                case 2: {
                                                                                    n26 = 80;
                                                                                    break;
                                                                                }
                                                                                case 3: {
                                                                                    n26 = 81;
                                                                                    break;
                                                                                }
                                                                                default: {
                                                                                    n26 = 7;
                                                                                }
                                                                            }
                                                                            cArray23[n25] = (char)(c3 ^ n26);
                                                                            ++n4;
                                                                            cArray16 = cArray24;
                                                                            n18 = n18;
                                                                            if (n18 != 0) break;
                                                                            cArray24 = cArray16;
                                                                            n17 = n18;
                                                                            n25 = n18;
                                                                            cArray23 = cArray16;
                                                                        }
                                                                        cArray15 = cArray16;
                                                                        n17 = n18;
                                                                    } while (n18 > n4);
                                                                }
                                                                stringArray[1] = new String(cArray15).intern();
                                                                var0 = null;
                                                                char[] cArray25 = "P\u001a4\u0018WdM\u0019?bf:45uw\b#".toCharArray();
                                                                n4 = 0;
                                                                int n27 = cArray25.length;
                                                                cArray14 = cArray25;
                                                                n16 = n27;
                                                                if (n27 <= 1) break block85;
                                                                cArray13 = cArray14;
                                                                n15 = n16;
                                                                if (n16 <= n4) break block86;
                                                            }
                                                            do {
                                                                char[] cArray26 = cArray14;
                                                                char[] cArray27 = cArray14;
                                                                int n28 = n4;
                                                                while (true) {
                                                                    int n29;
                                                                    char c4 = cArray26[n28];
                                                                    switch (n4 % 5) {
                                                                        case 0: {
                                                                            n29 = 18;
                                                                            break;
                                                                        }
                                                                        case 1: {
                                                                            n29 = 123;
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            n29 = 80;
                                                                            break;
                                                                        }
                                                                        case 3: {
                                                                            n29 = 81;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            n29 = 7;
                                                                        }
                                                                    }
                                                                    cArray26[n28] = (char)(c4 ^ n29);
                                                                    ++n4;
                                                                    cArray14 = cArray27;
                                                                    n16 = n16;
                                                                    if (n16 != 0) break;
                                                                    cArray27 = cArray14;
                                                                    n15 = n16;
                                                                    n28 = n16;
                                                                    cArray26 = cArray14;
                                                                }
                                                                cArray13 = cArray14;
                                                                n15 = n16;
                                                            } while (n16 > n4);
                                                        }
                                                        stringArray[2] = new String(cArray13).intern();
                                                        var0 = null;
                                                        char[] cArray28 = "([".toCharArray();
                                                        n4 = 0;
                                                        int n30 = cArray28.length;
                                                        cArray12 = cArray28;
                                                        n14 = n30;
                                                        if (n30 <= 1) break block87;
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                        if (n14 <= n4) break block88;
                                                    }
                                                    do {
                                                        char[] cArray29 = cArray12;
                                                        char[] cArray30 = cArray12;
                                                        int n31 = n4;
                                                        while (true) {
                                                            int n32;
                                                            char c5 = cArray29[n31];
                                                            switch (n4 % 5) {
                                                                case 0: {
                                                                    n32 = 18;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n32 = 123;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n32 = 80;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n32 = 81;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n32 = 7;
                                                                }
                                                            }
                                                            cArray29[n31] = (char)(c5 ^ n32);
                                                            ++n4;
                                                            cArray12 = cArray30;
                                                            n14 = n14;
                                                            if (n14 != 0) break;
                                                            cArray30 = cArray12;
                                                            n13 = n14;
                                                            n31 = n14;
                                                            cArray29 = cArray12;
                                                        }
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                    } while (n14 > n4);
                                                }
                                                stringArray[3] = new String(cArray11).intern();
                                                var0 = null;
                                                char[] cArray31 = "P\u001a4\u0018iw\u000f\u00115c`\u001e#\"".toCharArray();
                                                n4 = 0;
                                                int n33 = cArray31.length;
                                                cArray10 = cArray31;
                                                n12 = n33;
                                                if (n33 <= 1) break block89;
                                                cArray9 = cArray10;
                                                n11 = n12;
                                                if (n12 <= n4) break block90;
                                            }
                                            do {
                                                char[] cArray32 = cArray10;
                                                char[] cArray33 = cArray10;
                                                int n34 = n4;
                                                while (true) {
                                                    int n35;
                                                    char c6 = cArray32[n34];
                                                    switch (n4 % 5) {
                                                        case 0: {
                                                            n35 = 18;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n35 = 123;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n35 = 80;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n35 = 81;
                                                            break;
                                                        }
                                                        default: {
                                                            n35 = 7;
                                                        }
                                                    }
                                                    cArray32[n34] = (char)(c6 ^ n35);
                                                    ++n4;
                                                    cArray10 = cArray33;
                                                    n12 = n12;
                                                    if (n12 != 0) break;
                                                    cArray33 = cArray10;
                                                    n11 = n12;
                                                    n34 = n12;
                                                    cArray32 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n11 = n12;
                                            } while (n12 > n4);
                                        }
                                        stringArray[4] = new String(cArray9).intern();
                                        var0 = null;
                                        char[] cArray34 = "P\u001a4\tIA:45uw\b#".toCharArray();
                                        n4 = 0;
                                        int n36 = cArray34.length;
                                        cArray8 = cArray34;
                                        n10 = n36;
                                        if (n36 <= 1) break block91;
                                        cArray7 = cArray8;
                                        n9 = n10;
                                        if (n10 <= n4) break block92;
                                    }
                                    do {
                                        char[] cArray35 = cArray8;
                                        char[] cArray36 = cArray8;
                                        int n37 = n4;
                                        while (true) {
                                            int n38;
                                            char c7 = cArray35[n37];
                                            switch (n4 % 5) {
                                                case 0: {
                                                    n38 = 18;
                                                    break;
                                                }
                                                case 1: {
                                                    n38 = 123;
                                                    break;
                                                }
                                                case 2: {
                                                    n38 = 80;
                                                    break;
                                                }
                                                case 3: {
                                                    n38 = 81;
                                                    break;
                                                }
                                                default: {
                                                    n38 = 7;
                                                }
                                            }
                                            cArray35[n37] = (char)(c7 ^ n38);
                                            ++n4;
                                            cArray8 = cArray36;
                                            n10 = n10;
                                            if (n10 != 0) break;
                                            cArray36 = cArray8;
                                            n9 = n10;
                                            n37 = n10;
                                            cArray35 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n9 = n10;
                                    } while (n10 > n4);
                                }
                                stringArray[5] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray37 = "P\u001a4\u0015BQ55%Fv\u001f\"4ta".toCharArray();
                                n4 = 0;
                                int n39 = cArray37.length;
                                cArray6 = cArray37;
                                n8 = n39;
                                if (n39 <= 1) break block93;
                                cArray5 = cArray6;
                                n7 = n8;
                                if (n8 <= n4) break block94;
                            }
                            do {
                                char[] cArray38 = cArray6;
                                char[] cArray39 = cArray6;
                                int n40 = n4;
                                while (true) {
                                    int n41;
                                    char c8 = cArray38[n40];
                                    switch (n4 % 5) {
                                        case 0: {
                                            n41 = 18;
                                            break;
                                        }
                                        case 1: {
                                            n41 = 123;
                                            break;
                                        }
                                        case 2: {
                                            n41 = 80;
                                            break;
                                        }
                                        case 3: {
                                            n41 = 81;
                                            break;
                                        }
                                        default: {
                                            n41 = 7;
                                        }
                                    }
                                    cArray38[n40] = (char)(c8 ^ n41);
                                    ++n4;
                                    cArray6 = cArray39;
                                    n8 = n8;
                                    if (n8 != 0) break;
                                    cArray39 = cArray6;
                                    n7 = n8;
                                    n40 = n8;
                                    cArray38 = cArray6;
                                }
                                cArray5 = cArray6;
                                n7 = n8;
                            } while (n8 > n4);
                        }
                        stringArray[6] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray40 = "Q\u0014>7nuA".toCharArray();
                        n4 = 0;
                        int n42 = cArray40.length;
                        cArray4 = cArray40;
                        n6 = n42;
                        if (n42 <= 1) break block95;
                        cArray3 = cArray4;
                        n5 = n6;
                        if (n6 <= n4) break block96;
                    }
                    do {
                        char[] cArray41 = cArray4;
                        char[] cArray42 = cArray4;
                        int n43 = n4;
                        while (true) {
                            int n44;
                            char c9 = cArray41[n43];
                            switch (n4 % 5) {
                                case 0: {
                                    n44 = 18;
                                    break;
                                }
                                case 1: {
                                    n44 = 123;
                                    break;
                                }
                                case 2: {
                                    n44 = 80;
                                    break;
                                }
                                case 3: {
                                    n44 = 81;
                                    break;
                                }
                                default: {
                                    n44 = 7;
                                }
                            }
                            cArray41[n43] = (char)(c9 ^ n44);
                            ++n4;
                            cArray4 = cArray42;
                            n6 = n6;
                            if (n6 != 0) break;
                            cArray42 = cArray4;
                            n5 = n6;
                            n43 = n6;
                            cArray41 = cArray4;
                        }
                        cArray3 = cArray4;
                        n5 = n6;
                    } while (n6 > n4);
                }
                stringArray[7] = new String(cArray3).intern();
                var0 = null;
                char[] cArray43 = "Z\u0014#%'s\u001f4#ba\bp8t2".toCharArray();
                n4 = 0;
                int n45 = cArray43.length;
                cArray2 = cArray43;
                n3 = n45;
                if (n45 <= 1) break block97;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block98;
            }
            do {
                char[] cArray44 = cArray2;
                char[] cArray45 = cArray2;
                int n46 = n4;
                while (true) {
                    int n47;
                    char c10 = cArray44[n46];
                    switch (n4 % 5) {
                        case 0: {
                            n47 = 18;
                            break;
                        }
                        case 1: {
                            n47 = 123;
                            break;
                        }
                        case 2: {
                            n47 = 80;
                            break;
                        }
                        case 3: {
                            n47 = 81;
                            break;
                        }
                        default: {
                            n47 = 7;
                        }
                    }
                    cArray44[n46] = (char)(c10 ^ n47);
                    ++n4;
                    cArray2 = cArray45;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray45 = cArray2;
                    n2 = n3;
                    n46 = n3;
                    cArray44 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        stringArray[8] = new String(cArray).intern();
        z = stringArray;
    }
}

