/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.cache;

import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.util.VersionID;
import com.sun.javaws.util.VersionString;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class DiskCache {
    private static final int BUF_SIZE = 32768;
    static final char DIRECTORY_TYPE = 'D';
    static final char TEMP_TYPE = 'X';
    static final char VERSION_TYPE = 'V';
    static final char INDIRECT_TYPE = 'I';
    static final char RESOURCE_TYPE = 'R';
    static final char APPLICATION_TYPE = 'A';
    static final char EXTENSION_TYPE = 'E';
    static final char MUFFIN_TYPE = 'P';
    private File _baseDir;
    static final char MAIN_FILE_TAG = 'M';
    static final char NATIVELIB_FILE_TAG = 'N';
    static final char TIMESTAMP_FILE_TAG = 'T';
    static final char HOST_FILE_TAG = 'H';
    static final char CERTIFICATE_FILE_TAG = 'C';
    static final char LAP_FILE_TAG = 'L';
    static final char MAPPED_IMAGE_FILE_TAG = 'B';
    static final char MUFFIN_ATTR_FILE_TAG = 'U';
    static final int MUFFIN_TAG_INDEX = 0;
    static final int MUFFIN_MAXSIZE_INDEX = 1;
    private static final String LAST_ACCESS_FILE = "lastAccessed";
    private static final String ORPHAN_LIST_FILE = "orphans";
    private static final String BEGIN_CERT_MARK = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERT_MARK = "-----END CERTIFICATE-----";

    public DiskCache(File file) {
        this._baseDir = file;
    }

    long getLastUpdate() {
        File file = new File(this._baseDir, LAST_ACCESS_FILE);
        return file.lastModified();
    }

    void recordLastUpdate() {
        File file = new File(this._baseDir, LAST_ACCESS_FILE);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(46);
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    boolean canWrite() {
        boolean bl = this._baseDir.canWrite();
        if (!bl) {
            Trace.println((String)("Cannot write to cache: " + this._baseDir.getAbsolutePath()), (TraceLevel)TraceLevel.BASIC);
        }
        return bl;
    }

    String getBaseDirForHost(URL uRL) {
        try {
            URL uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), "");
            String string = this.keyToFileLocation('R', 'M', uRL2, null);
            int n = string.lastIndexOf(File.separator);
            return string.substring(0, n);
        }
        catch (MalformedURLException malformedURLException) {
            Trace.ignoredException((Exception)malformedURLException);
            return null;
        }
    }

    private void removeEmptyDirs(URL uRL) {
        String string = this.getBaseDirForHost(uRL);
        if (string != null) {
            this.removeEmptyDirs(new File(string));
        }
    }

    private void removeEmptyDirs(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            boolean bl = false;
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    this.removeEmptyDirs(fileArray[i]);
                    if (!fileArray[i].exists()) continue;
                    bl = true;
                }
            }
            if (!bl) {
                try {
                    file.delete();
                }
                catch (Exception exception) {
                    Trace.ignoredException((Exception)exception);
                }
            }
        }
    }

    private File getOrphanFileForHost(URL uRL) {
        try {
            return new File(this.getBaseDirForHost(uRL), ORPHAN_LIST_FILE);
        }
        catch (Exception exception) {
            Trace.ignoredException((Exception)exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOrphans(URL uRL) {
        File file = this.getOrphanFileForHost(uRL);
        if (file != null && file.exists()) {
            BufferedReader bufferedReader = null;
            PrintStream printStream = null;
            boolean bl = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                String string;
                FileInputStream fileInputStream = new FileInputStream(file);
                bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                while ((string = bufferedReader.readLine()) != null) {
                    arrayList.add(string);
                }
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    File file2 = new File((String)arrayList.get(i));
                    file2.delete();
                    if (file2.exists()) continue;
                    bl = true;
                    arrayList.remove(i);
                }
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        Trace.ignoredException((Exception)iOException);
                    }
                }
            }
            if (bl) {
                try {
                    if (arrayList.isEmpty()) {
                        Trace.println((String)"emptying orphans file", (TraceLevel)TraceLevel.CACHE);
                        file.delete();
                    } else {
                        printStream = new PrintStream(new FileOutputStream(file));
                        for (int i = 0; i < arrayList.size(); ++i) {
                            Trace.println((String)("Remaining orphan: " + arrayList.get(i)), (TraceLevel)TraceLevel.CACHE);
                            printStream.println((String)arrayList.get(i));
                        }
                    }
                }
                catch (Exception exception) {
                    Trace.ignoredException((Exception)exception);
                }
                finally {
                    if (printStream != null) {
                        printStream.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrphan(URL uRL, File file) {
        Trace.println((String)("addOrphan: " + file), (TraceLevel)TraceLevel.CACHE);
        File file2 = this.getOrphanFileForHost(uRL);
        PrintStream printStream = null;
        if (file2 != null) {
            try {
                printStream = new PrintStream(new FileOutputStream(file2.getPath(), true));
                printStream.println(file.getCanonicalPath());
            }
            catch (Exception exception) {
                Trace.ignoredException((Exception)exception);
            }
            finally {
                if (printStream != null) {
                    printStream.close();
                }
            }
        }
    }

    File getTempCacheFile(URL uRL, String string) throws IOException {
        String string2 = this.keyToFileLocation('X', 'M', uRL, string);
        File file = new File(string2);
        File file2 = file.getParentFile();
        file2.mkdirs();
        return File.createTempFile("java-" + file.getName(), "tmp", file2);
    }

    File createNativeLibDir(URL uRL, String string) throws IOException {
        File file = this.getFileFromCache('R', 'N', uRL, string, false);
        file.mkdirs();
        return file;
    }

    File getNativeLibDir(URL uRL, String string) throws IOException {
        File file = this.getFileFromCache('R', 'N', uRL, string, false);
        return file;
    }

    void insertMuffinEntry(URL uRL, File file, int n, long l) throws IOException {
        File file2 = this.getFileFromCache('P', 'M', uRL, null, false);
        if (file2.exists()) {
            file.delete();
            throw new IOException("insert failed in cache: target already exixts");
        }
        File file3 = file2.getParentFile();
        if (file3 != null) {
            file3.mkdirs();
        }
        if (!file.renameTo(file2)) {
            throw new IOException("rename failed in cache");
        }
        this.putMuffinAttributes(uRL, n, l);
    }

    long getMuffinSize(URL uRL) throws IOException {
        long l = 0L;
        File file = this.getFileFromCache('P', 'M', uRL, null, true);
        if (file != null && file.exists()) {
            l += file.length();
        }
        return l;
    }

    void insertEntry(char c, URL uRL, String string, File file, long l) throws IOException {
        this.putTimeStamp(c, uRL, string, l);
        this.putFileInCache(c, 'M', uRL, string, file);
        this.recordLastUpdate();
    }

    File putMappedImage(URL uRL, String string, File file) throws IOException {
        Object object;
        if (file.getPath().endsWith(".ico") && !((String)(object = uRL.getFile())).endsWith(".ico")) {
            object = (String)object + ".ico";
            uRL = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), (String)object);
        }
        object = this.putFileInCache('R', 'B', uRL, string, file);
        this.recordLastUpdate();
        return object;
    }

    File getMappedImage(char c, char c2, URL uRL, String string, boolean bl) throws IOException {
        String string2;
        File file = this.getFileFromCache(c, c2, uRL, string, bl);
        if (!(file != null && file.exists() || (string2 = uRL.getFile()).endsWith(".ico"))) {
            string2 = string2 + ".ico";
            uRL = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string2);
            file = this.getFileFromCache(c, c2, uRL, string, bl);
        }
        return file;
    }

    void putLaunchFile(char c, URL uRL, String string, String string2) throws IOException {
        byte[] byArray = string2.getBytes("UTF8");
        this.storeAtomic(c, 'M', uRL, string, byArray);
        this.putTimeStamp(c, uRL, string, new Date().getTime());
    }

    String getLaunchFile(char c, URL uRL, String string, String string2) throws IOException {
        byte[] byArray = this.getEntryContent(c, 'M', uRL, string);
        if (byArray == null) {
            return null;
        }
        return new String(byArray, "UTF8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putMuffinAttributes(URL uRL, int n, long l) throws IOException {
        PrintStream printStream = new PrintStream(this.getOutputStream('P', 'U', uRL, null));
        try {
            printStream.println(n);
            printStream.println(l);
        }
        finally {
            if (printStream != null) {
                printStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putTimeStamp(char c, URL uRL, String string, long l) throws IOException {
        if (l == 0L) {
            l = new Date().getTime();
        }
        PrintStream printStream = new PrintStream(this.getOutputStream(c, 'T', uRL, string));
        try {
            printStream.println(l);
            printStream.println("# " + new Date(l));
        }
        finally {
            printStream.close();
        }
        this.putHostIP(c, uRL, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putHostIP(char c, URL uRL, String string) throws IOException {
        String string2 = URLUtil.getHostIP((String)uRL.getHost());
        if (string2 == null) {
            return;
        }
        PrintStream printStream = new PrintStream(this.getOutputStream(c, 'H', uRL, string));
        try {
            printStream.println(string2);
        }
        finally {
            printStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long[] getMuffinAttributes(URL uRL) throws IOException {
        BufferedReader bufferedReader = null;
        long l = -1L;
        long l2 = -1L;
        try {
            InputStream inputStream = this.getInputStream('P', 'U', uRL, null);
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine();
            try {
                l = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(numberFormatException.getMessage());
            }
            string = bufferedReader.readLine();
            try {
                l2 = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(numberFormatException.getMessage());
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return new long[]{l, l2};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getCodebaseIP(char c, URL uRL, String string) {
        BufferedReader bufferedReader = null;
        String string2 = null;
        try {
            InputStream inputStream = this.getInputStream(c, 'H', uRL, string);
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            string2 = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            String string3 = null;
            return string3;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    long getTimeStamp(char c, URL uRL, String string) {
        BufferedReader bufferedReader = null;
        try {
            InputStream inputStream = this.getInputStream(c, 'T', uRL, string);
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string2 = bufferedReader.readLine();
            try {
                long l = Long.parseLong(string2);
                return l;
            }
            catch (NumberFormatException numberFormatException) {
                long l = 0L;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    Trace.ignoredException((Exception)iOException);
                }
                return l;
                catch (IOException iOException) {
                    long l2 = 0L;
                    return l2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
    }

    DiskCacheEntry getMuffinEntry(char c, URL uRL) throws IOException {
        File file = this.getFileFromCache(c, 'M', uRL, null, true);
        if (file == null) {
            return null;
        }
        File file2 = this.getFileFromCache(c, 'U', uRL, null, true);
        return new DiskCacheEntry(c, uRL, null, file, -1L, null, null, file2);
    }

    DiskCacheEntry getCacheEntry(char c, URL uRL, String string) throws IOException {
        File file = this.getFileFromCache(c, 'M', uRL, string, true);
        if (file == null) {
            return null;
        }
        File file2 = this.getFileFromCache(c, 'N', uRL, string, true);
        File file3 = this.getMappedImage(c, 'B', uRL, string, true);
        long l = this.getTimeStamp(c, uRL, string);
        String string2 = this.getCodebaseIP(c, uRL, string);
        DiskCacheEntry diskCacheEntry = new DiskCacheEntry(c, uRL, string, file, l, file2, file3, null);
        diskCacheEntry.setCodebaseIP(string2);
        return diskCacheEntry;
    }

    DiskCacheEntry[] getCacheEntries(char c, URL uRL, String string, boolean bl) throws IOException {
        DiskCacheEntry[] diskCacheEntryArray;
        if (string == null) {
            DiskCacheEntry diskCacheEntry = this.getCacheEntry(c, uRL, null);
            if (diskCacheEntry == null) {
                return new DiskCacheEntry[0];
            }
            return new DiskCacheEntry[]{diskCacheEntry};
        }
        ArrayList arrayList = this.getCacheEntries(c, uRL);
        VersionString versionString = new VersionString(string);
        DiskCacheEntry[] diskCacheEntryArray2 = null;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            diskCacheEntryArray = (DiskCacheEntry[])iterator.next();
            String string2 = diskCacheEntryArray.getVersionId();
            if (string2 == null) {
                iterator.remove();
                continue;
            }
            if (versionString.contains(string2)) continue;
            if (diskCacheEntryArray2 == null && versionString.containsGreaterThan(string2)) {
                diskCacheEntryArray2 = diskCacheEntryArray;
            }
            iterator.remove();
        }
        if (!bl && arrayList.size() == 0 && diskCacheEntryArray2 != null) {
            arrayList.add(diskCacheEntryArray2);
        }
        diskCacheEntryArray = new DiskCacheEntry[arrayList.size()];
        return arrayList.toArray(diskCacheEntryArray);
    }

    void removeMuffinEntry(DiskCacheEntry diskCacheEntry) {
        char c = diskCacheEntry.getType();
        URL uRL = diskCacheEntry.getLocation();
        String string = diskCacheEntry.getVersionId();
        this.deleteEntry(c, 'M', uRL, string);
        this.deleteEntry(c, 'U', uRL, string);
    }

    void removeEntry(DiskCacheEntry diskCacheEntry) {
        char c = diskCacheEntry.getType();
        URL uRL = diskCacheEntry.getLocation();
        this.removeOrphans(uRL);
        String string = diskCacheEntry.getVersionId();
        this.deleteEntry(c, 'M', uRL, string);
        this.deleteEntry(c, 'T', uRL, string);
        this.deleteEntry(c, 'H', uRL, string);
        this.deleteEntry(c, 'C', uRL, string);
        this.deleteEntry(c, 'N', uRL, string);
        this.deleteEntry(c, 'B', uRL, string);
        this.deleteEntry(c, 'L', uRL, string);
        if (c == 'R') {
            this.deleteEntry('I', 'M', uRL, string);
        }
        this.removeEmptyDirs(uRL);
        this.recordLastUpdate();
    }

    private void deleteEntry(char c, char c2, URL uRL, String string) {
        File file = null;
        try {
            file = c2 == 'B' ? this.getMappedImage(c, c2, uRL, string, false) : this.getFileFromCache(c, c2, uRL, string, false);
            this.deleteFile(file);
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
        }
        if (file != null && file.exists() && c == 'R' && c2 == 'M') {
            this.addOrphan(uRL, file);
        }
    }

    DiskCacheEntry getCacheEntryFromFile(File file) {
        DiskCacheEntry diskCacheEntry = this.fileToEntry(file);
        if (diskCacheEntry != null) {
            try {
                if (diskCacheEntry.getType() == 'P') {
                    return this.getMuffinEntry(diskCacheEntry.getType(), diskCacheEntry.getLocation());
                }
                return this.getCacheEntry(diskCacheEntry.getType(), diskCacheEntry.getLocation(), diskCacheEntry.getVersionId());
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        return diskCacheEntry;
    }

    boolean isMainMuffinFile(File file) throws IOException {
        DiskCacheEntry diskCacheEntry = this.fileToEntry(file);
        return file.equals(this.getFileFromCache('P', 'M', diskCacheEntry.getLocation(), null, false));
    }

    private ArrayList getCacheEntries(char c, URL uRL) throws IOException {
        Object object;
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = this.keyToFileLocation(c, 'M', uRL, "MATCH");
        int n2 = string.indexOf(File.separator + 'V' + "MATCH" + File.separator);
        if (n2 == -1) {
            throw new IllegalStateException("the javaws cache is corrupted");
        }
        String string2 = string.substring(0, n2);
        File file = new File(string2);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return arrayList;
        }
        for (n = 0; n < fileArray.length; ++n) {
            String string3;
            File file2;
            object = fileArray[n].getName();
            if (!fileArray[n].isDirectory() || ((String)object).length() <= 1 || ((String)object).charAt(0) != 'V' || (file2 = this.getFileFromCache(c, 'M', uRL, string3 = ((String)object).substring(1), true)) == null) continue;
            DiskCacheEntry diskCacheEntry = this.getCacheEntry(c, uRL, string3);
            arrayList.add(diskCacheEntry);
        }
        n = arrayList.size();
        if (n > 1) {
            object = new DiskCacheEntry[n];
            object = arrayList.toArray((T[])object);
            Arrays.sort(object, new Comparator(){

                public int compare(Object object, Object object2) {
                    VersionID versionID;
                    DiskCacheEntry diskCacheEntry = (DiskCacheEntry)object;
                    DiskCacheEntry diskCacheEntry2 = (DiskCacheEntry)object2;
                    VersionID versionID2 = new VersionID(diskCacheEntry.getVersionId());
                    return versionID2.isGreaterThan(versionID = new VersionID(diskCacheEntry2.getVersionId())) ? -1 : 1;
                }
            });
            for (int i = 0; i < n; ++i) {
                arrayList.set(i, object[i]);
            }
        }
        if ((object = this.getFileFromCache(c, 'M', uRL, null, true)) != null) {
            DiskCacheEntry diskCacheEntry = this.getCacheEntry(c, uRL, null);
            arrayList.add(diskCacheEntry);
        }
        return arrayList;
    }

    public String[] getCacheVersions(char c, URL uRL) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.keyToFileLocation(c, 'M', uRL, "MATCH");
        int n = string.indexOf(File.separator + 'V' + "MATCH" + File.separator);
        if (n == -1) {
            throw new IllegalStateException("the javaws cache is corrupted");
        }
        String string2 = string.substring(0, n);
        File file = new File(string2);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string3;
                File file2;
                String string4 = fileArray[i].getName();
                if (!fileArray[i].isDirectory() || string4.length() <= 1 || string4.charAt(0) != 'V' || (file2 = this.getFileFromCache(c, 'M', uRL, string3 = string4.substring(1), true)) == null) continue;
                arrayList.add(string3);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    void visitDiskCache(char c, DiskCacheVisitor diskCacheVisitor) throws IOException {
        this.visitDiskCacheHelper(this._baseDir, 0, c, diskCacheVisitor);
    }

    private void visitDiskCacheHelper(File file, int n, char c, DiskCacheVisitor diskCacheVisitor) throws IOException {
        String string = file.getName();
        if (file.isDirectory() && (string.length() <= 2 || file.getName().charAt(1) != 'N')) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.visitDiskCacheHelper(fileArray[i], n + 1, c, diskCacheVisitor);
            }
        } else if (string.length() > 2 && n > 3) {
            char c2 = string.charAt(0);
            char c3 = string.charAt(1);
            if (c2 == c && c3 == 'M') {
                DiskCacheEntry diskCacheEntry = this.getCacheEntryFromFile(file);
                if (diskCacheEntry == null) {
                    throw new IllegalStateException("the javaws cache is corrupted");
                }
                diskCacheVisitor.visitEntry(diskCacheEntry);
            }
        }
    }

    File getMuffinFileForURL(URL uRL) {
        try {
            return this.getFileFromCache('P', 'M', uRL, null, false);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    URL[] getAccessibleMuffins(URL uRL) throws IOException {
        MuffinAccessVisitor muffinAccessVisitor = new MuffinAccessVisitor(this, uRL);
        this.visitDiskCache('P', muffinAccessVisitor);
        return muffinAccessVisitor.getAccessibleMuffins();
    }

    long getCacheSize() throws IOException {
        Trace.println((String)("Computing diskcache size: " + this._baseDir.getAbsoluteFile()), (TraceLevel)TraceLevel.CACHE);
        SizeVisitor sizeVisitor = new SizeVisitor(this);
        this.visitDiskCache('R', sizeVisitor);
        return sizeVisitor.getSize();
    }

    void uninstallCache() {
        this.deleteFile(this._baseDir);
        if (this._baseDir.exists()) {
            this.recordLastUpdate();
        }
    }

    private void deleteFile(File file) {
        File[] fileArray;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                this.deleteFile(fileArray[i]);
            }
        }
        file.delete();
    }

    private OutputStream getOutputStream(char c, char c2, URL uRL, String string) throws IOException {
        File file = this.getFileFromCache(c, c2, uRL, string, false);
        file.getParentFile().mkdirs();
        file.createNewFile();
        this.recordLastUpdate();
        return new FileOutputStream(file);
    }

    private InputStream getInputStream(char c, char c2, URL uRL, String string) throws IOException {
        return new FileInputStream(this.getFileFromCache(c, c2, uRL, string, false));
    }

    byte[] getLapData(char c, URL uRL, String string) throws IOException {
        return this.getEntryContent(c, 'L', uRL, string);
    }

    void putLapData(char c, URL uRL, String string, byte[] byArray) throws IOException {
        this.storeAtomic(c, 'L', uRL, string, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getEntryContent(char c, char c2, URL uRL, String string) throws IOException {
        File file = this.getFileFromCache(c, c2, uRL, string, true);
        if (file == null) {
            return null;
        }
        long l = file.length();
        if (l > 0x40000000L) {
            return null;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)l);
        byte[] byArray = new byte[32768];
        try {
            int n = bufferedInputStream.read(byArray);
            while (n >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = bufferedInputStream.read(byArray);
            }
        }
        finally {
            byteArrayOutputStream.close();
            bufferedInputStream.close();
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeAtomic(char c, char c2, URL uRL, String string, byte[] byArray) throws IOException {
        File file = this.getTempCacheFile(uRL, string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        byte[] byArray2 = new byte[32768];
        try {
            int n = byteArrayInputStream.read(byArray2);
            while (n >= 0) {
                bufferedOutputStream.write(byArray2, 0, n);
                n = byteArrayInputStream.read(byArray2);
            }
        }
        finally {
            bufferedOutputStream.close();
            ((InputStream)byteArrayInputStream).close();
        }
        this.putFileInCache(c, c2, uRL, string, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File putFileInCache(char c, char c2, URL uRL, String string, File file) throws IOException {
        File file2;
        File file3 = new File(this.keyToFileLocation(c, c2, uRL, string));
        this.removeOrphans(uRL);
        file3.delete();
        if (!file.renameTo(file3)) {
            this.deleteEntry(c, c2, uRL, string);
            if (c == 'R' && c2 == 'M') {
                PrintStream printStream = new PrintStream(this.getOutputStream('I', 'M', uRL, string));
                try {
                    printStream.println(file.getCanonicalPath());
                }
                finally {
                    printStream.close();
                }
                return file;
            }
            throw new IOException("rename failed in cache to: " + file3);
        }
        if (c == 'R' && c2 == 'M' && (file2 = this.getFileFromCache('I', c2, uRL, string, false)).exists()) {
            this.deleteEntry(c, c2, uRL, string);
            this.deleteEntry('I', c2, uRL, string);
        }
        return file3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File getFileFromCache(char c, char c2, URL uRL, String string, boolean bl) throws IOException {
        File file;
        BufferedReader bufferedReader = null;
        if (c == 'R' && c2 == 'M' && (file = this.getFileFromCache('I', c2, uRL, string, false)).exists()) {
            try {
                File file2;
                InputStream inputStream = this.getInputStream('I', 'M', uRL, string);
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string2 = bufferedReader.readLine();
                File file3 = file2 = new File(string2);
                return file3;
            }
            catch (IOException iOException) {
                if (bl) {
                    File file4 = null;
                    return file4;
                }
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
        }
        File file5 = new File(this.keyToFileLocation(c, c2, uRL, string));
        if (bl && !file5.exists()) {
            return null;
        }
        return file5;
    }

    private DiskCacheEntry fileToEntry(File file) {
        Object object;
        String string;
        char c = '\u0000';
        URL uRL = null;
        String string2 = null;
        long l = 0L;
        String string3 = file.getAbsolutePath();
        if (!string3.startsWith(string = this._baseDir.getAbsolutePath())) {
            return null;
        }
        string3 = string3.substring(string.length());
        StringTokenizer stringTokenizer = new StringTokenizer(string3, File.separator, false);
        try {
            object = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            if (string4.length() < 1) {
                return null;
            }
            string4 = string4.substring(1);
            String string5 = stringTokenizer.nextToken();
            if (string5.length() < 1) {
                return null;
            }
            int n = 0;
            try {
                n = Integer.parseInt(string5.substring(1));
                if (n == 80) {
                    n = -1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreElements()) {
                String string6 = stringTokenizer.nextToken();
                if ((string6 = DiskCache.removeEscapes(string6)).length() < 1) {
                    return null;
                }
                c = string6.charAt(0);
                if (c == 'V') {
                    string2 = string6.substring(1);
                    continue;
                }
                stringBuffer.append('/');
                stringBuffer.append(string6.substring(2));
            }
            uRL = new URL((String)object, string4, n, stringBuffer.toString());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
        object = new DiskCacheEntry(c, uRL, string2, file, 0L);
        return object;
    }

    private static String removeEscapes(String string) {
        int n;
        if (string == null || string.indexOf(38) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (n = 0; n < string.length() - 1; ++n) {
            char c = string.charAt(n);
            char c2 = string.charAt(n + 1);
            if (c == '&' && c2 == 'p') {
                ++n;
                stringBuffer.append('%');
                continue;
            }
            if (c == '&' && c2 == 'c') {
                ++n;
                stringBuffer.append(':');
                continue;
            }
            if (c == '&' && c2 == '_') {
                ++n;
                stringBuffer.append('\\');
                continue;
            }
            if (c == '&' && c2 == '&') continue;
            stringBuffer.append(c);
        }
        if (n < string.length()) {
            stringBuffer.append(string.charAt(n));
        }
        return stringBuffer.toString();
    }

    private String keyToFileLocation(char c, char c2, URL uRL, String string) {
        StringBuffer stringBuffer = new StringBuffer(uRL.toString().length() + (string == null ? 0 : string.length()) * 2);
        stringBuffer.append(uRL.getProtocol());
        stringBuffer.append(File.separatorChar);
        stringBuffer.append('D');
        stringBuffer.append(uRL.getHost());
        stringBuffer.append(File.separatorChar);
        String string2 = null;
        string2 = uRL.getPort() == -1 && uRL.getProtocol().equals("http") ? "P80" : "P" + new Integer(uRL.getPort()).toString();
        stringBuffer.append(string2);
        stringBuffer.append(File.separatorChar);
        if (string != null) {
            stringBuffer.append('V');
            stringBuffer.append(string);
            stringBuffer.append(File.separatorChar);
        }
        stringBuffer.append(this.convertURLfile(c, c2, uRL.getFile()));
        String string3 = stringBuffer.toString().replace(':', '_');
        return this._baseDir.getAbsolutePath() + File.separator + string3;
    }

    private String convertURLfile(char c, char c2, String string) {
        int n;
        String string2 = null;
        int n2 = string.indexOf(";");
        if (n2 != -1) {
            string2 = string.substring(n2);
            string = string.substring(0, n2);
        }
        if ((n = string.indexOf("?")) != -1) {
            string2 = string.substring(n) + string2;
            string = string.substring(0, n);
        }
        if (string2 != null) {
            Trace.println((String)("     URL: " + string + "\n  PARAMS: " + string2), (TraceLevel)TraceLevel.CACHE);
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        int n3 = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.substring(i).startsWith("..\\")) {
                i += 2;
                continue;
            }
            if (string.charAt(i) == '/') {
                stringBuffer.append(File.separatorChar);
                stringBuffer.append('D');
                stringBuffer.append('M');
                n3 = stringBuffer.length();
                continue;
            }
            if (string.charAt(i) == ':') {
                stringBuffer.append("&c");
                continue;
            }
            if (string.charAt(i) == '&') {
                stringBuffer.append("&&");
                continue;
            }
            if (string.charAt(i) == '%') {
                stringBuffer.append("&p");
                continue;
            }
            if (string.charAt(i) == '\\') {
                stringBuffer.append("&_");
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        if (n3 == -1) {
            stringBuffer.insert(0, c);
            stringBuffer.insert(1, c2);
        } else {
            stringBuffer.setCharAt(n3 - 2, c);
            stringBuffer.setCharAt(n3 - 1, c2);
        }
        return stringBuffer.toString();
    }

    long getOrphanSize() {
        long l = 0L;
        try {
            Iterator iterator = this.getOrphans();
            while (iterator.hasNext()) {
                l += ((DiskCacheEntry)iterator.next()).getSize();
            }
        }
        catch (Exception exception) {
            Trace.ignoredException((Exception)exception);
        }
        return l;
    }

    void cleanResources() {
        try {
            Iterator iterator = this.getOrphans();
            while (iterator.hasNext()) {
                this.removeEntry((DiskCacheEntry)iterator.next());
            }
        }
        catch (Exception exception) {
            Trace.ignoredException((Exception)exception);
        }
    }

    Iterator getOrphans() {
        final ArrayList arrayList = new ArrayList();
        final ArrayList arrayList2 = new ArrayList();
        DiskCacheVisitor diskCacheVisitor = new DiskCacheVisitor(){

            public void visitEntry(DiskCacheEntry diskCacheEntry) {
                LaunchDesc launchDesc = null;
                try {
                    launchDesc = LaunchDescFactory.buildDescriptor(diskCacheEntry.getFile());
                }
                catch (Exception exception) {
                    Trace.ignoredException((Exception)exception);
                }
                if (launchDesc != null) {
                    InformationDesc informationDesc;
                    Object object;
                    ResourcesDesc resourcesDesc = launchDesc.getResources();
                    JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true);
                    if (jARDescArray != null) {
                        for (int i = 0; i < jARDescArray.length; ++i) {
                            try {
                                object = DiskCache.this.getFileFromCache('R', 'M', jARDescArray[i].getLocation(), jARDescArray[i].getVersion(), false);
                                if (object == null) continue;
                                arrayList.add(object);
                                continue;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    if ((informationDesc = launchDesc.getInformation()) != null && (object = informationDesc.getIcons()) != null) {
                        for (int i = 0; i < ((IconDesc[])object).length; ++i) {
                            try {
                                File file = DiskCache.this.getFileFromCache('R', 'M', object[i].getLocation(), object[i].getVersion(), false);
                                if (file == null) continue;
                                arrayList.add(file);
                                continue;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        };
        try {
            this.visitDiskCache('A', diskCacheVisitor);
            this.visitDiskCache('E', diskCacheVisitor);
            diskCacheVisitor = new DiskCacheVisitor(){

                public void visitEntry(DiskCacheEntry diskCacheEntry) {
                    if (!arrayList.contains(diskCacheEntry.getFile())) {
                        arrayList2.add(diskCacheEntry);
                    }
                }
            };
            this.visitDiskCache('R', diskCacheVisitor);
            this.visitDiskCache('I', diskCacheVisitor);
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
        }
        return arrayList2.iterator();
    }

    Iterator getJnlpCacheEntries() {
        final ArrayList arrayList = new ArrayList();
        try {
            DiskCacheVisitor diskCacheVisitor = new DiskCacheVisitor(){

                public void visitEntry(DiskCacheEntry diskCacheEntry) {
                    arrayList.add(diskCacheEntry);
                }
            };
            this.visitDiskCache('A', diskCacheVisitor);
            this.visitDiskCache('E', diskCacheVisitor);
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
        }
        return arrayList.iterator();
    }

    private static class SizeVisitor
    implements DiskCacheVisitor {
        private DiskCache _diskCache;
        long _size = 0L;

        SizeVisitor(DiskCache diskCache) {
            this._diskCache = diskCache;
            this._size = 0L;
        }

        public void visitEntry(DiskCacheEntry diskCacheEntry) {
            if (diskCacheEntry.getDirectory() != null && diskCacheEntry.getDirectory().exists()) {
                File[] fileArray = diskCacheEntry.getDirectory().listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    this._size += fileArray[i].length();
                }
            } else {
                this._size += diskCacheEntry.getFile().length();
            }
        }

        public long getSize() {
            return this._size;
        }
    }

    private static class DeleteVisitor
    implements DiskCacheVisitor {
        private DiskCache _diskCache;

        DeleteVisitor(DiskCache diskCache) {
            this._diskCache = diskCache;
        }

        public void visitEntry(DiskCacheEntry diskCacheEntry) {
            this._diskCache.removeEntry(diskCacheEntry);
        }
    }

    private static class MuffinAccessVisitor
    implements DiskCacheVisitor {
        private DiskCache _diskCache;
        private URL _theURL;
        private URL[] _urls = new URL[255];
        private int _counter = 0;

        MuffinAccessVisitor(DiskCache diskCache, URL uRL) {
            this._diskCache = diskCache;
            this._theURL = uRL;
        }

        public void visitEntry(DiskCacheEntry diskCacheEntry) {
            URL uRL = diskCacheEntry.getLocation();
            if (uRL == null) {
                return;
            }
            if (uRL.getHost().equals(this._theURL.getHost())) {
                this._urls[this._counter++] = uRL;
            }
        }

        public URL[] getAccessibleMuffins() {
            return this._urls;
        }
    }

    public static interface DiskCacheVisitor {
        public void visitEntry(DiskCacheEntry var1);
    }
}

