/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.DeployUIManager;
import com.sun.deploy.util.DialogFactory;
import com.sun.javaws.Main;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;

final class SmartSecurityDialog
extends Thread {
    private boolean _remembered = false;
    private int _lastResult = -1;
    private boolean _cbChecked = false;
    private int _answer;
    private Object _signalObject = new Object();
    private String _message = null;
    private DummyDialog _dummyDialog;
    private EventQueue _sysEventQueue = null;
    private static final ThreadGroup _secureGroup = Main.getSecurityThreadGroup();
    private Object[] _objs = null;

    SmartSecurityDialog() {
        this((String)null);
    }

    SmartSecurityDialog(String string) {
        this._message = string;
    }

    SmartSecurityDialog(String string, boolean bl) {
        this(string);
        this._cbChecked = bl;
    }

    boolean showDialog(Object[] objectArray) {
        this._objs = objectArray;
        return this.showDialog();
    }

    boolean showDialog(String string) {
        this._message = string;
        this._objs = null;
        return this.showDialog();
    }

    boolean showDialog() {
        Integer n = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Integer(SmartSecurityDialog.this.getUserDecision(null, SmartSecurityDialog.this._message));
            }
        });
        return n == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUserDecision(Frame frame, String string) {
        if (this._remembered) {
            this._answer = this._lastResult;
            return this._answer;
        }
        if (!Config.getBooleanProperty((String)"deployment.security.sandbox.jnlp.enhanced")) {
            return 1;
        }
        Object object = this._signalObject;
        synchronized (object) {
            this._sysEventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            final Thread thread = new Thread(_secureGroup, this, "userDialog");
            this._message = string;
            this._dummyDialog = new DummyDialog((Frame)null, true);
            this._dummyDialog.addWindowListener(new WindowAdapter(){

                public void windowOpened(WindowEvent windowEvent) {
                    thread.start();
                }

                public void windowClosing(WindowEvent windowEvent) {
                    SmartSecurityDialog.this._dummyDialog.hide();
                }
            });
            Rectangle rectangle = new Rectangle(new Point(0, 0), Toolkit.getDefaultToolkit().getScreenSize());
            this._dummyDialog.setLocation(rectangle.x + rectangle.width / 2 - 50, rectangle.y + rectangle.height / 2);
            if (Config.getOSName().equals("Windows")) {
                this._dummyDialog.setLocation(-200, -200);
            }
            this._dummyDialog.setResizable(false);
            this._dummyDialog.toBack();
            this._dummyDialog.show();
            try {
                this._signalObject.wait();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this._dummyDialog.hide();
            }
            return this._answer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LookAndFeel lookAndFeel = DeployUIManager.setLookAndFeel();
        try {
            JPanel jPanel = new JPanel();
            final JCheckBox jCheckBox = new JCheckBox(ResourceManager.getString((String)"APIImpl.securityDialog.remember"), this._cbChecked);
            Font font = jCheckBox.getFont();
            Font font2 = null;
            if (font != null && (font2 = font.deriveFont(0)) != null) {
                jCheckBox.setFont(font2);
            }
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class CsiCheckBoxListener
            implements ItemListener {
                CsiCheckBoxListener() {
                }

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ItemSelectable itemSelectable = itemEvent.getItemSelectable();
                    if (itemSelectable == jCheckBox) {
                        if (itemEvent.getStateChange() == 2) {
                            SmartSecurityDialog.this.setCBChecked(false);
                        } else if (itemEvent.getStateChange() == 1) {
                            SmartSecurityDialog.this.setCBChecked(true);
                        }
                    }
                }
            }
            jCheckBox.addItemListener(new CsiCheckBoxListener());
            jPanel.add((Component)jCheckBox, "Center");
            jCheckBox.setOpaque(false);
            jPanel.setOpaque(false);
            Object[] objectArray = this._objs == null ? new Object[]{this._message, jPanel} : this._objs;
            Object[] objectArray2 = new Object[]{ResourceManager.getString((String)"APIImpl.securityDialog.yes"), ResourceManager.getString((String)"APIImpl.securityDialog.no")};
            int n = 1;
            try {
                int n2 = DialogFactory.showOptionDialog((int)4, (Object)objectArray, (String)ResourceManager.getString((String)"APIImpl.securityDialog.title"), (Object[])objectArray2, (Object)objectArray2[0]);
                int n3 = n = n2 == 1 ? 1 : 0;
                if (this._cbChecked) {
                    this._remembered = true;
                    this._lastResult = n;
                }
            }
            finally {
                this._dummyDialog.secureHide();
                Object object = this._signalObject;
                synchronized (object) {
                    this._answer = n;
                    this._signalObject.notify();
                }
            }
        }
        finally {
            DeployUIManager.restoreLookAndFeel((LookAndFeel)lookAndFeel);
        }
    }

    private void setCBChecked(boolean bl) {
        this._cbChecked = bl;
    }

    private class DummyDialog
    extends JDialog {
        private ThreadGroup _unsecureGroup;

        DummyDialog(Frame frame, boolean bl) {
            super(frame, bl);
            this._unsecureGroup = Thread.currentThread().getThreadGroup();
        }

        public void secureHide() {
            new Thread(this._unsecureGroup, new Runnable(){

                public void run() {
                    DummyDialog.this.hide();
                }
            }).start();
        }
    }
}

