/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11.provider;

import com.ibm.crypto.pkcs11.provider.IBMPKCS11;
import com.ibm.crypto.pkcs11.provider.RSAPKCS11PrivateKey;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public final class RSA
extends CipherSpi {
    private PKCS11Session session;
    private PKCS11Object keyObject;
    private byte[] buffer = null;
    private ByteArrayOutputStream bArray;

    public RSA() {
        System.out.println("**************** IBMPKCS11 RSA");
        IBMPKCS11.verifyJceJar();
        if (!IBMPKCS11.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The IBMPKCS11 provider may have been tampered.");
        }
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        if (byArray != null) {
            this.bArray.write(byArray, n, n2);
        }
        this.buffer = this.bArray.toByteArray();
        byte[] byArray2 = new byte[2048];
        int n3 = this.session.decrypt(this.buffer, 0, this.buffer.length, byArray2, 0);
        byte[] byArray3 = byArray2;
        byArray2 = new byte[n3];
        System.arraycopy(byArray3, 0, byArray2, 0, n3);
        this.bArray = new ByteArrayOutputStream();
        return byArray2;
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        if (byArray != null) {
            this.bArray.write(byArray, n, n2);
        }
        this.buffer = this.bArray.toByteArray();
        byte[] byArray3 = new byte[2048];
        int n4 = this.session.decrypt(this.buffer, 0, this.buffer.length, byArray3, 0);
        byte[] byArray4 = byArray3;
        byArray3 = new byte[n4];
        System.arraycopy(byArray4, 0, byArray3, 0, n4);
        if (byArray3 == null) {
            throw new BadPaddingException("Not PKCS#1 block type 2 or Zero padding");
        }
        if (byArray3.length > byArray2.length - n3) {
            throw new ShortBufferException("Output buffer too short: " + (byArray2.length - n3) + " bytes given, " + byArray3.length + " bytes needed");
        }
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        this.buffer = null;
        this.bArray = new ByteArrayOutputStream();
        return byArray3.length;
    }

    protected int engineGetBlockSize() {
        return 0;
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        return 0;
    }

    protected int engineGetOutputSize(int n) {
        return n;
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(n, key, secureRandom);
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (n != 2 && n != 4) {
            throw new InvalidKeyException("RSA encryption not supported");
        }
        if (!(key instanceof RSAPKCS11PrivateKey)) {
            throw new InvalidKeyException("not a RSA private key: " + key);
        }
        RSAPKCS11PrivateKey rSAPKCS11PrivateKey = (RSAPKCS11PrivateKey)key;
        this.session = rSAPKCS11PrivateKey.getSession();
        this.keyObject = rSAPKCS11PrivateKey.getObject();
        int[] nArray = this.session.getSlot().getMechanismList();
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] == 1) {
                bl = true;
                n2 = 1;
                break;
            }
            ++n3;
        }
        if (!bl) {
            throw new UnsupportedOperationException("The token does not support RSA_PKCS");
        }
        this.session.decryptInit(n2, null, this.keyObject);
        this.buffer = null;
        this.bArray = new ByteArrayOutputStream();
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(n, key, secureRandom);
    }

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (string != null && string.equals(" ")) {
            return;
        }
        if (string != null) {
            throw new NoSuchAlgorithmException("Mode: " + string + " not implemented");
        }
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("Key unwrap not supported");
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        if (byArray != null) {
            this.bArray.write(byArray, n, n2);
        }
        return new byte[0];
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        if (byArray != null) {
            this.bArray.write(byArray, n, n2);
        }
        return 0;
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        throw new InvalidKeyException("Key wrap not supported");
    }
}

