/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.swg.svcutil;

import com.ibm.swg.svcutil.SVCUtil;
import com.ibm.swg.util.PropertyManager;
import com.ibm.swg.util.Util;
import com.ibm.swg.util.cim.CIMConnectionConstants;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;

public class SNIAConfigManager
extends PropertyManager
implements CIMConnectionConstants {
    public static final String DEFAULT_CONFIG_FILE_NAME = "cimom.properties";

    public Integer getCIMOMPort() {
        String string = this.getPropertyAndWarn(SNIAProperty.PORT);
        if (string == null) {
            return null;
        }
        try {
            return Integer.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.invalidValueMessage(SNIAProperty.PORT, string);
            return null;
        }
    }

    public CIMConnectionConstants.CimomInformation.Protocol getCIMProtocol() {
        String string = this.getPropertyAndWarn(SNIAProperty.PROTOCOL);
        if (string == null) {
            return null;
        }
        if (string.toLowerCase().indexOf("https") >= 0) {
            return SECURE_PROTOCOL;
        }
        if (string.toLowerCase().indexOf("http") >= 0) {
            return UNSECURE_PROTOCOL;
        }
        this.invalidValueMessage(SNIAProperty.PROTOCOL, string);
        return null;
    }

    public SNIAConfigManager(File file) {
        this(SVCUtil.getTheUtil(), file);
    }

    public SNIAConfigManager(SVCUtil sVCUtil, File file) {
        super((Util)sVCUtil, SNIAConfigManager.getConfigFile(file), null);
    }

    public SNIAConfigManager(SVCUtil sVCUtil, File file, String string) {
        this(sVCUtil, new File(file, string));
    }

    public SNIAConfigManager(File file, String string) {
        this(SVCUtil.getTheUtil(), new File(file, string));
    }

    public static File getConfigFile(File file) {
        if (file.isDirectory()) {
            return new File(file, DEFAULT_CONFIG_FILE_NAME);
        }
        return file;
    }

    private String getPropertyAndWarn(SNIAProperty sNIAProperty) {
        String string = this.getProperty(sNIAProperty);
        if (string == null) {
            this.getTheUtil().warnMsgLn("Could not find property <" + sNIAProperty.getPropertyFileName() + "> in property file <" + this.getPropertyFileName() + ">");
        }
        return string;
    }

    private void invalidValueMessage(PropertyManager.Property property, String string) {
        this.getTheUtil().warnMsgLn("The property <" + property.getPropertyFileName() + "> in property file <" + this.getPropertyFileName() + "> had invalid value <" + string + ">");
    }

    public static class SNIAProperty
    extends PropertyManager.PropertyImpl {
        public static final SNIAProperty PORT = new SNIAProperty("SNIA CIMOM IP Port", "Port");
        public static final SNIAProperty PROTOCOL = new SNIAProperty("SNIA CIMOM Communication Protocol", "ServerCommunication");
        private static Vector list;

        private SNIAProperty(String string, String string2) {
            super(string, null, string2, (String)null, (String)null);
            list.add(this);
        }

        public static Iterator iterator() {
            return list.iterator();
        }
    }
}

