/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.swg.svcutil;

import com.ibm.swg.svcutil.SVCCIMConstants;
import com.ibm.swg.svcutil.SVCUtilConstants;
import com.ibm.swg.svcutil.SVCUtilProperties;
import com.ibm.swg.svcutil.executers.AbstractActionExecuter;
import com.ibm.swg.svcutil.executers.AddCIMUser;
import com.ibm.swg.svcutil.executers.AddDevice;
import com.ibm.swg.svcutil.executers.AddEncryptedCIMUser;
import com.ibm.swg.svcutil.executers.ApplyTracingConfiguration;
import com.ibm.swg.svcutil.executers.CollectLogs;
import com.ibm.swg.svcutil.executers.DeleteCIMUser;
import com.ibm.swg.svcutil.executers.DumpFiles;
import com.ibm.swg.svcutil.executers.ListCIMUsers;
import com.ibm.swg.svcutil.executers.ListInstances;
import com.ibm.swg.svcutil.executers.ListLogLevel;
import com.ibm.swg.svcutil.executers.ListTraceCategories;
import com.ibm.swg.svcutil.executers.ListTraceComponents;
import com.ibm.swg.svcutil.executers.ListUtilProperties;
import com.ibm.swg.svcutil.executers.ListVersion;
import com.ibm.swg.svcutil.executers.MigrateCIMUsers;
import com.ibm.swg.svcutil.executers.MigrateEncryptedCIMUsers;
import com.ibm.swg.svcutil.executers.RemoveDevice;
import com.ibm.swg.svcutil.executers.SetLogLevel;
import com.ibm.swg.svcutil.executers.SetSLPRegistrationIPs;
import com.ibm.swg.svcutil.executers.SetTraceCategories;
import com.ibm.swg.svcutil.executers.SetTraceComponents;
import com.ibm.swg.svcutil.executers.StartAgent;
import com.ibm.swg.svcutil.executers.StateTracking;
import com.ibm.swg.svcutil.executers.StopAgent;
import com.ibm.swg.util.PropertyManager;
import com.ibm.swg.util.Util;
import com.ibm.swg.util.cim.CIMUtilImpl;
import java.io.File;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class SVCUtil
extends CIMUtilImpl
implements SVCUtilConstants,
SVCCIMConstants {
    static List m_actionMap = new Vector();
    private PropertyManager propertyManager;

    public static SVCUtil getTheUtil() {
        return (SVCUtil)Util.GlobalUtil.getTheUtil();
    }

    public PropertyManager getPropertyManager() {
        return this.propertyManager;
    }

    public void usage(String string) {
        this.usage(string, SVCUtilConstants.ErrorAction.Continue);
    }

    public void usage(String string, SVCUtilConstants.ErrorAction errorAction) {
        this.errorMsgLn(string);
        this.putMsgLn("Usage: svcutil <action>");
        this.putMsgLn("Where <action> is: ");
        Iterator iterator = m_actionMap.iterator();
        while (iterator.hasNext()) {
            ExecuterInfo executerInfo = (ExecuterInfo)iterator.next();
            this.putMsgLn("    " + executerInfo.theName + " " + executerInfo.theDescription);
        }
        if (errorAction == SVCUtilConstants.ErrorAction.Exit_Process) {
            System.exit(-1);
        }
    }

    private void run(String[] stringArray) {
        Object object;
        StringWriter stringWriter = new StringWriter();
        this.setMsgOutputCopy(stringWriter);
        this.putMsgLn("SVC Command Line Utility Version IBM-SVC-SMIS-Agent-5.1.0.654 10/28/09 02:07:03 PM");
        if (stringArray.length < 1) {
            this.usage("No action specified", SVCUtilConstants.ErrorAction.Exit_Process);
            return;
        }
        this.propertyManager = new PropertyManager((String)null, stringArray);
        File file = new File(this.propertyManager.getProperty(SVCUtilProperties.SVCProperty.AGENT_DIR));
        File file2 = new File(file, "svcutil.properties");
        if (file2.exists()) {
            this.propertyManager = new PropertyManager(file2, stringArray);
        } else {
            this.statusMsgLn("Customization property file <" + file2.getAbsolutePath() + "> is not present.");
        }
        Vector<String> vector = new Vector<String>(Arrays.asList(stringArray));
        Object object2 = vector.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (((String)object).indexOf(PropertyManager.PROPERTY_VALUE_SEPARATOR) <= 0) continue;
            object2.remove();
        }
        if (vector.size() < 1) {
            this.usage("No action specified", SVCUtilConstants.ErrorAction.Exit_Process);
            return;
        }
        object2 = this.getExecuters(vector.get(0));
        if (object2 == null || ((Vector)object2).size() < 1) {
            this.usage("Invalid action <" + vector.get(0) + ">", SVCUtilConstants.ErrorAction.Exit_Process);
        }
        if (object2 == null || ((Vector)object2).size() > 1) {
            this.usage("Ambiguous action <" + vector.get(0) + ">", SVCUtilConstants.ErrorAction.Exit_Process);
            return;
        }
        vector.remove(0);
        object = (AbstractActionExecuter)((Vector)object2).get(0);
        ((AbstractActionExecuter)object).run(this, vector);
    }

    private Vector getExecuters(String string) {
        Vector<AbstractActionExecuter> vector = new Vector<AbstractActionExecuter>();
        Iterator iterator = m_actionMap.iterator();
        while (iterator.hasNext()) {
            ExecuterInfo executerInfo = (ExecuterInfo)iterator.next();
            if (executerInfo.theName.indexOf(string) != 0) continue;
            vector.add(executerInfo.theExecutor);
        }
        return vector;
    }

    public static void main(String[] stringArray) {
        SVCUtil sVCUtil = new SVCUtil();
        sVCUtil.run(stringArray);
    }

    static {
        m_actionMap.add(new ExecuterInfo("collectlogs", new CollectLogs(), " [" + SVCUtilProperties.SVCProperty.TIME_OUT.getArgumentName() + "=<timeout>]" + " [" + SVCUtilProperties.SVCProperty.NETSTATS_TYPE.getArgumentName() + "=<detail/concise>]" + " - Collect the SVC CIM Agent logs"));
        m_actionMap.add(new ExecuterInfo("lsloglevel", new ListLogLevel(), "- [-allValid] - List the current/valid logging level"));
        m_actionMap.add(new ExecuterInfo("setloglevel", new SetLogLevel(), "<level> - Set the current logging level"));
        m_actionMap.add(new ExecuterInfo("lstracecomponents", new ListTraceComponents(), "[-allValid] - List the current/valid trace components"));
        m_actionMap.add(new ExecuterInfo("lstracecategories", new ListTraceCategories(), "- [-allValid] - List the current/valid trace categories"));
        m_actionMap.add(new ExecuterInfo("settracecategories", new SetTraceCategories(), "<category> [<category>] - Set the current trace categories"));
        m_actionMap.add(new ExecuterInfo("settracecomponents", new SetTraceComponents(), "<component> [<component>] - Set the current trace components"));
        m_actionMap.add(new ExecuterInfo("version", new ListVersion(), "- List the utility version and exit"));
        m_actionMap.add(new ExecuterInfo("lsutilproperties", new ListUtilProperties(), "[ShowDefaults] - List the configurable properties for this utility"));
        m_actionMap.add(new ExecuterInfo("dumpfiles", new DumpFiles(), "[-save] [-noclean] - get iostat dump files"));
        m_actionMap.add(new ExecuterInfo("migratecimusers", new MigrateCIMUsers(), "<cimom backup file> - migrate users from a previously backed up CIMOM"));
        m_actionMap.add(new ExecuterInfo("lscimusers", new ListCIMUsers(), "[" + SVCUtilProperties.SVCProperty.OUTPUT_FILE.getArgumentName() + "=<output file>]" + " - List the CIMOM users on release 4.2.0 and earlier for migration purpose"));
        m_actionMap.add(new ExecuterInfo("rmcimuser", new DeleteCIMUser(), SVCUtilProperties.SVCProperty.DELETE_USER_NAME.getArgumentName() + "=<username>" + " - Delete a CIMOM user"));
        m_actionMap.add(new ExecuterInfo("lsinstances", new ListInstances(), "<class name> - List all CIM objects of the given CIM class"));
        m_actionMap.add(new ExecuterInfo("adddevice", new AddDevice(), "<device address> - Add the device at the given address"));
        m_actionMap.add(new ExecuterInfo("rmdevice", new RemoveDevice(), "<device address> - Remove the device at the given address"));
        m_actionMap.add(new ExecuterInfo("startagent", new StartAgent(), "- Start the SVC CIM Agent"));
        m_actionMap.add(new ExecuterInfo("stopagent", new StopAgent(), "- Stop the SVC CIM Agent"));
        m_actionMap.add(new ExecuterInfo("setslpregip ", new SetSLPRegistrationIPs(), "<ip addresses> - Set the IP addresses registered by SLP"));
        m_actionMap.add(new ExecuterInfo("statetrack ", new StateTracking(), "on | off | [-verbose] dump - Manage provider state tracking"));
        m_actionMap.add(new ExecuterInfo("applytraceconfig ", new ApplyTracingConfiguration(), "-allValid - Apply a tracing configuration"));
        m_actionMap.add(new ExecuterInfo("addcimuser", new AddCIMUser(), SVCUtilProperties.SVCProperty.ADD_USER_NAME.getArgumentName() + "=<username>" + " [" + SVCUtilProperties.SVCProperty.ADD_USER_PASSWORD.getArgumentName() + "=<password>]" + " [" + SVCUtilProperties.SVCProperty.ADD_USER_ROLE.getArgumentName() + "=<role>]" + " - Add a new CIMOM user"));
        m_actionMap.add(new ExecuterInfo("addencryptedcimuser", new AddEncryptedCIMUser(), SVCUtilProperties.SVCProperty.ADD_USER_NAME.getArgumentName() + "=<username>" + " [" + SVCUtilProperties.SVCProperty.ADD_USER_PASSWORD.getArgumentName() + "=<password>]" + " [" + SVCUtilProperties.SVCProperty.ADD_USER_ROLE.getArgumentName() + "=<role>]" + " - Add a new CIMOM user with a pre-encrypted password"));
        m_actionMap.add(new ExecuterInfo("migrateproxyusers", new MigrateEncryptedCIMUsers(), SVCUtilProperties.SVCProperty.PASSWORD_FILE.getArgumentName() + "=<user password file>" + " [" + SVCUtilProperties.SVCProperty.ROLE_FILE.getArgumentName() + "=<user role file>]" + " [" + SVCUtilProperties.SVCProperty.ADD_USER_ROLE.getArgumentName() + "=<role>]" + " - Migrate a set of proxy CIMOM users to an embedded CIMOM"));
    }

    private static class ExecuterInfo {
        public final String theName;
        public final AbstractActionExecuter theExecutor;
        public final String theDescription;

        public ExecuterInfo(String string, AbstractActionExecuter abstractActionExecuter, String string2) {
            this.theName = string;
            this.theExecutor = abstractActionExecuter;
            this.theDescription = string2;
        }
    }
}

