/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.swg.svcutil;

import com.ibm.swg.svcutil.SVCCIMConstants;
import com.ibm.swg.svcutil.SVCUtilProperties;
import com.ibm.swg.util.cim.CIMClassConstants;
import org.sblim.wbem.cim.CIMArgument;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.cim.UnsignedInt16;
import org.sblim.wbem.cim.UnsignedInt32;

public interface SVCUtilConstants
extends SVCCIMConstants,
SVCUtilProperties {
    public static final String PROPERTIES_FILE_NAME = "svcutil.properties";
    public static final String LIST_ALL_VALID_OPTION = "-allValid";
    public static final String VERBOSE_STATE_DUMP_OPTION = "-verbose";
    public static final String DUMP_STATE = "dump";
    public static final String ENABLE_STATE_TRACKING = "on";
    public static final String DISABLE_STATE_TRACKING = "off";
    public static final String VALID_STATE_TRACKING_ACTIONS = "on | off | [-verbose] dump";
    public static final String SAVE_DUMP_FILES_LOCALLY = "-save";
    public static final String DONT_CLEAN_DUMP_FILES = "-noclean";
    public static final String VALID_DUMP_FILE_OPTIONS = "[-save] [-noclean]";
    public static final String WINDOWS_SERVICE_NAME = "SVCCIMAgent";
    public static final String WINDOWS_START_SERVICE_COMMAND = "net start SVCCIMAgent";
    public static final String WINDOWS_STOP_SERVICE_COMMAND = "net stop SVCCIMAgent";
    public static final CIMClassConstants.CIMBasicClass CLUSTERING_SERVICE_CLASS = SVCCLASS_CLUSTERING_SERVICE;
    public static final CIMClassConstants.CIMBasicClass PROVIDER_CONFIG_CLASS = SVCCLASS_PROVIDER_CONFIGURATION;
    public static final CIMClassConstants.CIMBasicProperty TRACE_CATEGORIES_PROPERTY = new CIMClassConstants.CIMStringArrayProperty("TraceCategories");
    public static final CIMClassConstants.CIMBasicProperty VALID_TRACE_CATEGORIES_PROPERTY = new CIMClassConstants.CIMStringArrayProperty("ValidTraceCategories");
    public static final CIMClassConstants.CIMSimpleMethod SET_TRACE_CATEGORIES_METHOD = new CIMClassConstants.CIMSimpleMethod("SetTraceCategories", CIM_DATATYPE_UINT32);
    public static final CIMClassConstants.CIMBasicProperty TRACE_COMPONENTS_PROPERTY = new CIMClassConstants.CIMStringArrayProperty("TraceComponents");
    public static final CIMClassConstants.CIMBasicProperty VALID_TRACE_COMPONENTS_PROPERTY = new CIMClassConstants.CIMStringArrayProperty("ValidTraceComponents");
    public static final CIMClassConstants.CIMSimpleMethod SET_LOG_COMPONENTS_METHOD = new CIMClassConstants.CIMSimpleMethod("SetTraceComponents", CIM_DATATYPE_UINT32);
    public static final CIMClassConstants.CIMBasicProperty LOG_LEVEL_PROPERTY = new CIMClassConstants.CIMStringProperty("LogLevel");
    public static final CIMClassConstants.CIMBasicProperty VALID_LOG_LEVELS_PROPERTY = new CIMClassConstants.CIMStringArrayProperty("ValidLogLevels");
    public static final CIMClassConstants.CIMSimpleMethod SET_LOG_LEVEL_METHOD = new CIMClassConstants.CIMSimpleMethod("SetLogLevel", CIM_DATATYPE_UINT32);
    public static final CIMClassConstants.CIMSimpleMethod SET_CONFIG_VALUE_METHOD = new CIMClassConstants.CIMSimpleMethod("SetProviderConfigValue", CIM_DATATYPE_UINT32);
    public static final CIMClassConstants.CIMNamedClass POST_V421_USER_CLASS = SVCCLASS_USER;
    public static final CIMClassConstants.CIMNamedClass PRE_V421_USER_CLASS = SVCCLASS_ACCOUNT;
    public static final CIMClassConstants.CIMSimpleMethod ADD_USER_METHOD = new CIMClassConstants.CIMSimpleMethod("make", CIM_DATATYPE_UINT16);
    public static final CIMClassConstants.CIMSimpleMethod DELETE_USER_METHOD = new CIMClassConstants.CIMSimpleMethod("delete", CIM_DATATYPE_UINT16);
    public static final CIMClassConstants.CIMSimpleMethod ADD_DEVICE_METHOD = new CIMClassConstants.CIMSimpleMethod("AddDevice", CIM_DATATYPE_UINT32);
    public static final CIMClassConstants.CIMSimpleMethod REMOVE_DEVICE_METHOD = new CIMClassConstants.CIMSimpleMethod("RemoveDevice", CIM_DATATYPE_UINT32);
    public static final CIMClassConstants.CIMSimpleMethod SHUTDOWN_METHOD = new CIMClassConstants.CIMCompleteMethod("BeginShutdown", CIM_DATATYPE_UINT32);
    public static final CIMClassConstants.CIMBasicProperty VALID_TRACING_CONFIGURATIONS_PROPERTY = new CIMClassConstants.CIMStringArrayProperty("ValidTracingConfigurations");
    public static final CIMClassConstants.CIMBasicProperty POST_V421_AGENT_VERSION_PROPERTY = new CIMClassConstants.CIMStringProperty("Version");
    public static final CIMClassConstants.CIMBasicProperty CLUSTER_NAME_PROPERTY = new CIMClassConstants.CIMStringProperty("ElementName");

    public static class Shutdown
    extends CIMClassConstants.CIMCompleteMethod {
        public final CIMClassConstants.CIMCompleteMethod.InParameter TIMEOUT = new CIMClassConstants.CIMCompleteMethod.InParameter(this, "shutdownTimeoutSecs", CIMClassConstants.CIM_DATATYPE_UINT16);
        public static final CIMValue SUCCESS = new CIMValue((Object)new UnsignedInt32(0), CIMClassConstants.CIM_DATATYPE_UINT32);

        public Shutdown() {
            super("BeginShutdown", CIMClassConstants.CIM_DATATYPE_UINT32);
        }
    }

    public static class AddEncryptedUser
    extends CIMClassConstants.CIMCompletStaticMethod {
        public final CIMClassConstants.CIMCompleteMethod.InParameter NAME = new CIMClassConstants.CIMCompleteMethod.InParameter(this, "name", CIMClassConstants.CIM_DATATYPE_STRING);
        public final CIMClassConstants.CIMCompleteMethod.InParameter ENCRYPTED_PASSWORD = new CIMClassConstants.CIMCompleteMethod.InParameter(this, "encryptedPassword", CIMClassConstants.CIM_DATATYPE_STRING);
        public final CIMClassConstants.CIMCompleteMethod.InParameter ROLE = new CIMClassConstants.CIMCompleteMethod.InParameter(this, "role", CIMClassConstants.CIM_DATATYPE_UINT16);
        public static final CIMValue SUCCESS = new CIMValue((Object)new UnsignedInt16(0), CIMClassConstants.CIM_DATATYPE_UINT16);

        public AddEncryptedUser() {
            super("makeEncrypted", CIMClassConstants.CIM_DATATYPE_UINT16, SVCCIMConstants.SVCCLASS_USER);
        }
    }

    public static class CleanDumpMethod
    extends CIMClassConstants.CIMCompleteMethod {
        public final CIMClassConstants.CIMCompleteMethod.InParameter NODE = new CIMClassConstants.CIMCompleteMethod.InParameter(this, "Node", CIMClassConstants.CIM_DATATYPE_REFERENCE);
        public final CIMClassConstants.CIMCompleteMethod.InParameter IN_FILE_PATH = new CIMClassConstants.CIMCompleteMethod.InParameter(this, "FilePath", CIMClassConstants.CIM_DATATYPE_STRING);
        public static final CIMValue SUCCESS = new CIMValue((Object)new UnsignedInt32(0), CIMClassConstants.CIM_DATATYPE_UINT32);

        public CleanDumpMethod() {
            super("Clean", CIMClassConstants.CIM_DATATYPE_STRING);
        }
    }

    public static class GetDumpMethod
    extends CIMClassConstants.CIMCompleteMethod {
        public final CIMClassConstants.CIMCompleteMethod.InParameter WAIT_SECS = new CIMClassConstants.CIMCompleteMethod.InParameter(this, "RetrievalWaitSecs", CIMClassConstants.CIM_DATATYPE_UINT16);
        public final CIMClassConstants.CIMCompleteMethod.InParameter NODE = new CIMClassConstants.CIMCompleteMethod.InParameter(this, "Node", CIMClassConstants.CIM_DATATYPE_REFERENCE);
        public final CIMClassConstants.CIMCompleteMethod.InParameter IN_FILE_PATH = new CIMClassConstants.CIMCompleteMethod.InParameter(this, "FilePath", CIMClassConstants.CIM_DATATYPE_STRING);
        public final CIMClassConstants.CIMCompleteMethod.OutParameter FILE = new CIMClassConstants.CIMCompleteMethod.OutParameter(this, "File", CIMClassConstants.CIM_DATATYPE_STRING_ARRAY);
        public static final CIMValue SUCCESS = new CIMValue((Object)new UnsignedInt32(0), CIMClassConstants.CIM_DATATYPE_UINT32);

        public GetDumpMethod() {
            super("GetDump", CIMClassConstants.CIM_DATATYPE_STRING);
        }
    }

    public static class ApplyTracingConfigurationMethod
    extends CIMClassConstants.CIMCompleteMethod {
        public final CIMClassConstants.CIMCompleteMethod.InParameter IN_LOG_LEVEL = new CIMClassConstants.CIMCompleteMethod.InParameter(this, "LogLevel", CIMClassConstants.CIM_DATATYPE_STRING);
        public static final UnsignedInt32 INVALID_ARGUMENT = new UnsignedInt32(5);

        public ApplyTracingConfigurationMethod() {
            super("ApplyTracingConfiguration", CIMClassConstants.CIM_DATATYPE_UINT32);
        }
    }

    public static class DisableStateTrackingMethod
    extends CIMClassConstants.CIMCompleteMethod {
        public DisableStateTrackingMethod() {
            super("DisableStateTracking", CIMClassConstants.CIM_DATATYPE_UINT32);
        }
    }

    public static class EnableStateTrackingMethod
    extends CIMClassConstants.CIMCompleteMethod {
        public EnableStateTrackingMethod() {
            super("EnableStateTracking", CIMClassConstants.CIM_DATATYPE_UINT32);
        }
    }

    public static class GetStateDumpMethod
    extends CIMClassConstants.CIMCompleteMethod {
        public final CIMClassConstants.CIMCompleteMethod.InParameter IN_DUMP_FLAGS = new CIMClassConstants.CIMCompleteMethod.InParameter(this, "DumpFlags", CIMClassConstants.CIM_DATATYPE_UINT32);
        public final CIMClassConstants.CIMCompleteMethod.OutParameter OUT_RESULT = new CIMClassConstants.CIMCompleteMethod.OutParameter(this, "Result", CIMClassConstants.CIM_DATATYPE_STRING);

        public GetStateDumpMethod() {
            super("GetStateDump", CIMClassConstants.CIM_DATATYPE_UINT32);
        }
    }

    public static class SetSLPAddressesMethod
    extends CIMClassConstants.CIMCompleteMethod {
        public final CIMClassConstants.CIMCompleteMethod.InParameter IN_IP_ADDRESSES = new CIMClassConstants.CIMCompleteMethod.InParameter(this, "IPs", CIMClassConstants.CIM_DATATYPE_STRING_ARRAY);
        public final CIMClassConstants.CIMCompleteMethod.OutParameter OUT_IP_ADDRESSES = new CIMClassConstants.CIMCompleteMethod.OutParameter(this, "IPs", CIMClassConstants.CIM_DATATYPE_STRING_ARRAY);

        public SetSLPAddressesMethod() {
            super("SetPreferredSLPRegIPs", CIMClassConstants.CIM_DATATYPE_UINT32);
        }
    }

    public static class MakeDeviceConfigArgument
    extends CIMArgument {
        public MakeDeviceConfigArgument(CIMInstance cIMInstance) {
            super("DeviceConfig", new CIMValue((Object)cIMInstance.getObjectPath(), CIMClassConstants.CIM_DATATYPE_REFERENCE));
        }
    }

    public static class MakeIPAddressArgument
    extends CIMArgument {
        public MakeIPAddressArgument(String string) {
            super("IPAddress", new CIMValue((Object)string, CIMClassConstants.CIM_DATATYPE_STRING));
        }
    }

    public static class MakeUserRoleArgument
    extends CIMArgument {
        public static final Short ADMINISTRATOR_ROLE = new Short(0);
        public static final Short SERVICE_ROLE = new Short(1);
        public static final Short COPY_OPERATOR_ROLE = new Short(2);
        public static final Short MONITOR_ROLE = new Short(3);
        public static final String ADMINISTRATOR_ROLE_STRING = "Administrator";
        public static final String SERVICE_ROLE_STRING = "Service";
        public static final String COPY_OPERATOR_ROLE_STRING = "CopyOperator";
        public static final String MONITOR_ROLE_STRING = "Monitor";

        public MakeUserRoleArgument(short s) {
            super("role", new CIMValue((Object)new Short(s), CIMClassConstants.CIM_DATATYPE_UINT16));
        }

        public MakeUserRoleArgument(Short s) {
            this((short)s);
        }

        public static Short getUserRole(String string) {
            if (string.equalsIgnoreCase(ADMINISTRATOR_ROLE_STRING)) {
                return ADMINISTRATOR_ROLE;
            }
            if (string.equalsIgnoreCase(SERVICE_ROLE_STRING)) {
                return SERVICE_ROLE;
            }
            if (string.equalsIgnoreCase(COPY_OPERATOR_ROLE_STRING)) {
                return COPY_OPERATOR_ROLE;
            }
            if (string.equalsIgnoreCase(MONITOR_ROLE_STRING)) {
                return MONITOR_ROLE;
            }
            return null;
        }

        public static String getRoleName(Short s) {
            if (s.equals(ADMINISTRATOR_ROLE)) {
                return ADMINISTRATOR_ROLE_STRING;
            }
            if (s.equals(SERVICE_ROLE)) {
                return SERVICE_ROLE_STRING;
            }
            if (s.equals(COPY_OPERATOR_ROLE)) {
                return COPY_OPERATOR_ROLE_STRING;
            }
            if (s.equals(MONITOR_ROLE)) {
                return MONITOR_ROLE_STRING;
            }
            return null;
        }

        public MakeUserRoleArgument(String string) {
            this(MakeUserRoleArgument.getUserRole(string) == null ? MONITOR_ROLE : MakeUserRoleArgument.getUserRole(string));
        }

        public static boolean isValidRole(String string) {
            return MakeUserRoleArgument.getUserRole(string) != null;
        }
    }

    public static class MakeUserPasswordArgument
    extends CIMArgument {
        public MakeUserPasswordArgument(String string) {
            super("password", new CIMValue((Object)string, CIMClassConstants.CIM_DATATYPE_STRING));
        }
    }

    public static class MakeUserNameArgument
    extends CIMArgument {
        public MakeUserNameArgument(String string) {
            super("name", new CIMValue((Object)string, CIMClassConstants.CIM_DATATYPE_STRING));
        }
    }

    public static class SetConfigValueArgument
    extends CIMArgument {
        public SetConfigValueArgument(int n) {
            super("Value", new CIMValue((Object)new Integer(n), CIMClassConstants.CIM_DATATYPE_UINT32));
        }
    }

    public static class SetConfigLogComponentsArgument
    extends CIMArgument {
        public SetConfigLogComponentsArgument() {
            super("ConfigParameter", new CIMValue((Object)new Integer(3), CIMClassConstants.CIM_DATATYPE_UINT32));
        }
    }

    public static class SetConfigTraceCategoriesArgument
    extends CIMArgument {
        public SetConfigTraceCategoriesArgument() {
            super("ConfigParameter", new CIMValue((Object)new Integer(2), CIMClassConstants.CIM_DATATYPE_UINT32));
        }
    }

    public static class SetConfigLogLevelArgument
    extends CIMArgument {
        public SetConfigLogLevelArgument() {
            super("ConfigParameter", new CIMValue((Object)new Integer(1), CIMClassConstants.CIM_DATATYPE_UINT32));
        }
    }

    public static class SetLogLevelArgument
    extends CIMArgument {
        public SetLogLevelArgument(String string) {
            super("LogLevel", new CIMValue((Object)string, CIMClassConstants.CIM_DATATYPE_STRING));
        }
    }

    public static class SetTraceComponentsArgument
    extends CIMArgument {
        public SetTraceComponentsArgument(String[] stringArray) {
            super("TraceComponents", new CIMValue((Object)stringArray, CIMClassConstants.CIM_DATATYPE_STRING_ARRAY));
        }
    }

    public static class SetTraceCategoriesArgument
    extends CIMArgument {
        public SetTraceCategoriesArgument(String[] stringArray) {
            super("TraceCategories", new CIMValue((Object)stringArray, CIMClassConstants.CIM_DATATYPE_STRING_ARRAY));
        }
    }

    public static class ErrorAction {
        public static final ErrorAction Exit_Process = new ErrorAction();
        public static final ErrorAction Continue = new ErrorAction();

        private ErrorAction() {
        }
    }
}

