/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.swg.svcutil.executers;

import com.ibm.swg.svcutil.SVCUtilConstants;
import com.ibm.swg.svcutil.SVCUtilProperties;
import com.ibm.swg.svcutil.executers.AbstractActionExecuter;
import com.ibm.swg.util.FileUtilities;
import com.ibm.swg.util.PropertyManager;
import com.ibm.swg.util.UtilImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class CollectLogs
extends AbstractActionExecuter {
    private int m_zippedFiles = 0;
    private int timeout = 10000;
    private String nettype = "";

    public void run(List list) {
        Writer writer = this.getMsgOutputCopy();
        if (writer == null) {
            writer = new StringWriter();
            this.setMsgOutputCopy(writer);
        }
        ZipOutputStream zipOutputStream = this.collectLogs(list);
        this.collectSysEnv();
        this.setMsgOutputCopy(null);
        try {
            writer.close();
            this.statusMsg("Adding collect.log to archive file");
            int n = this.writeZipEntry(zipOutputStream, new ZipEntry("collect.log"), new StringBufferInputStream(writer.toString()));
            this.statusMsgLn(" " + n + " bytes");
        }
        catch (IOException iOException) {
            this.errorMsgLn("Writing collect.log to zip archive file");
            iOException.printStackTrace();
        }
        try {
            if (this.m_zippedFiles > 0) {
                zipOutputStream.close();
            }
        }
        catch (IOException iOException) {
            this.errorMsgLn("Closing zip archive file");
            iOException.printStackTrace();
        }
    }

    public void collectSysEnv() {
        String[] stringArray = new String[]{"set", "netstat", "tasklist /v", "tasklist /SVC"};
        if (this.nettype.equals("detail")) {
            stringArray[1] = "netstat -a -b -v -o";
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.statusMsgLn("*************start command \"" + stringArray[i] + "\"*************");
            this.runCmd(stringArray[i]);
            this.statusMsgLn("**************end command \"" + stringArray[i] + "\"**************");
        }
    }

    public void runCmd(String string) {
        Runtime runtime = Runtime.getRuntime();
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        Process process = null;
        int n = -1;
        try {
            process = runtime.exec("cmd /c " + string);
            if (this.timeout != 0) {
                try {
                    Thread.sleep(this.timeout);
                    n = process.exitValue();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    // empty catch block
                }
                if (n != 0) {
                    process.destroy();
                }
            }
            inputStream = process.getInputStream();
            inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                this.statusMsgLn(string2);
            }
            inputStream.close();
            inputStreamReader.close();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            this.errorMsgLn("Writing " + string + " result to collect.log");
        }
    }

    public ZipOutputStream collectLogs(List list) {
        FileOutputStream fileOutputStream;
        String string;
        PropertyManager propertyManager = this.getPropertyManager();
        String string2 = propertyManager.getProperty(SVCUtilProperties.SVCProperty.AGENT_DIR);
        this.statusMsgLn("SVC CIM Agent Home Directory is: " + string2);
        File file = new File(string2);
        if (!file.exists()) {
            this.errorMsgLn("Directory <" + string2 + "> does not exist!!");
            return null;
        }
        if (!file.isDirectory()) {
            this.errorMsgLn("<" + file.getAbsolutePath() + "> is not a directory!!");
            return null;
        }
        String string3 = propertyManager.getProperty(SVCUtilProperties.SVCProperty.TIME_OUT);
        if (string3 != null) {
            try {
                this.timeout = Integer.valueOf(string3);
            }
            catch (NumberFormatException numberFormatException) {
                this.usage("Wrong timeout number specified", SVCUtilConstants.ErrorAction.Exit_Process);
            }
        }
        if ((string = propertyManager.getProperty(SVCUtilProperties.SVCProperty.NETSTATS_TYPE)) != null) {
            if (string.equals("detail") || string.equals("concise")) {
                this.nettype = string;
            } else {
                this.usage("Wrong netstats command display type specified", SVCUtilConstants.ErrorAction.Exit_Process);
            }
        }
        String string4 = propertyManager.getProperty(SVCUtilProperties.SVCProperty.ZIP_FILE_NAME);
        File file2 = new File(string4);
        try {
            fileOutputStream = new FileOutputStream(file2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errorMsgLn("Could not create zip archive file <" + file2.getAbsolutePath() + ">. Aborting..");
            fileNotFoundException.printStackTrace();
            return null;
        }
        this.statusMsgLn("Zip archive file is: " + file2.getAbsolutePath());
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        zipOutputStream.setMethod(8);
        zipOutputStream.setComment("SVC CIM Agent Logs Compressed on:" + UtilImpl.getTimeStamp());
        String string5 = propertyManager.getProperty(SVCUtilProperties.SVCProperty.LOG_FILES);
        String[] stringArray = string5.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            this.addZipFiles(zipOutputStream, file, stringArray[i]);
        }
        return zipOutputStream;
    }

    private void addZipFiles(ZipOutputStream zipOutputStream, File file, String string) {
        File[] fileArray = FileUtilities.findMatchingFiles(file, string);
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            this.addZipFile(zipOutputStream, file2);
        }
    }

    private void addZipFile(ZipOutputStream zipOutputStream, File file) {
        this.statusMsg("Adding log file: " + file.getPath() + "...");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            String string = file.getCanonicalPath();
            string = string.replaceAll("\\\\", "/");
            string = string.replaceAll("\\:", "");
            int n = this.writeZipEntry(zipOutputStream, new ZipEntry(string), fileInputStream);
            this.statusMsgLn(" " + n + " bytes");
        }
        catch (Exception exception) {
            this.errorMsgLn("Error adding file <" + file.getPath() + "> to output file");
            exception.printStackTrace();
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private int writeZipEntry(ZipOutputStream zipOutputStream, ZipEntry zipEntry, InputStream inputStream) throws IOException {
        int n;
        zipOutputStream.putNextEntry(zipEntry);
        byte[] byArray = new byte[2048];
        int n2 = 0;
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            n2 += n;
            zipOutputStream.write(byArray, 0, n);
        }
        ++this.m_zippedFiles;
        return n2;
    }
}

