/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.swg.svcutil.executers;

import com.ibm.swg.svcutil.SVCUtilConstants;
import com.ibm.swg.svcutil.SVCUtilProperties;
import com.ibm.swg.svcutil.executers.AbstractCIMUserExecuter;
import com.ibm.swg.util.PropertyManager;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.List;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;

public class ListCIMUsers
extends AbstractCIMUserExecuter {
    public void run(List list) {
        Enumeration enumeration;
        PropertyManager propertyManager = this.getPropertyManager();
        String string = propertyManager.getProperty(SVCUtilProperties.SVCProperty.OUTPUT_FILE);
        FileWriter fileWriter = null;
        PrintWriter printWriter = null;
        if (string == null) {
            printWriter = new PrintWriter(System.out, true);
        } else {
            try {
                fileWriter = new FileWriter(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.usage("Cannot open output file <" + string + "> for writing", SVCUtilConstants.ErrorAction.Continue);
                this.errorMsgLn("FAILED to get users");
                System.exit(-1);
            }
            printWriter = new PrintWriter((Writer)fileWriter, true);
        }
        try {
            enumeration = this.enumerateInstances(PRE_V421_USER_CLASS);
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("CIM_ERR_INVALID_CLASS")) {
                this.errorMsgLn("This function is not supported on release 4.2.1 or later");
                System.exit(-1);
            }
            throw cIMException;
        }
        if (!enumeration.hasMoreElements()) {
            this.errorMsgLn("No users found for current CIMOM");
            this.errorMsgLn("FAILED to get users");
            System.exit(-1);
        }
        String string2 = this.setMsgPrefix(null);
        int n = 0;
        while (enumeration.hasMoreElements()) {
            CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
            String string3 = this.getStringProperty(cIMInstance, "UserID");
            this.statusMsgLn("Saving user #" + ++n + ", id = <" + string3 + ">");
            printWriter.println(cIMInstance.toMOF());
        }
        printWriter.close();
        this.setMsgPrefix(string2);
        if (fileWriter != null) {
            try {
                fileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.statusMsg("SUCCESSFULLY extracted and saved " + n + " CIMOM users");
    }
}

