/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.swg.svcutil.executers;

import com.ibm.swg.svcutil.SVCUtilConstants;
import com.ibm.swg.svcutil.executers.AbstractCIMUserExecuter;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MigrateCIMUsers
extends AbstractCIMUserExecuter {
    public void run(List list) {
        if (list.size() < 1) {
            this.usage("No CIMOM backup file supplied", SVCUtilConstants.ErrorAction.Exit_Process);
        }
        FileReader fileReader = null;
        String string = (String)list.get(0);
        try {
            fileReader = new FileReader(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.usage("Could not find CIMOM backup file <" + string + ">", SVCUtilConstants.ErrorAction.Exit_Process);
        }
        Pattern pattern = Pattern.compile(".*UserID.*=[\" ]*([^\" ]*)[\" ]*.*;");
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                Matcher matcher = pattern.matcher(string2);
                if (!matcher.matches()) continue;
                String string3 = matcher.group(1);
                if (string3.equals("superuser")) {
                    this.statusMsgLn("Skipping superuser...");
                    continue;
                }
                this.statusMsgLn("Adding user name <" + string3 + ">");
                this.addCIMUser(string3, "password", "Monitor");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.usage("Error reading from CIMOM backup file <" + string + ">", SVCUtilConstants.ErrorAction.Exit_Process);
        }
    }
}

