/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.swg.svcutil.executers;

import com.ibm.swg.svcutil.SVCUtilConstants;
import com.ibm.swg.svcutil.SVCUtilProperties;
import com.ibm.swg.svcutil.executers.AbstractCIMUserExecuter;
import com.ibm.swg.util.PropertyManager;
import com.ibm.swg.util.cim.CIMUtilConstants;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.sblim.wbem.cim.CIMInstance;

public class MigrateEncryptedCIMUsers
extends AbstractCIMUserExecuter {
    final int SUCCESS = 0;
    final int DUPLICATE_USER = 1;
    final int IO_ERROR = -1;
    final int CIM_ERROR = -2;
    final int USER_LIMIT = -3;
    final int MAX_USER = 128;

    public void run(List list) {
        Object object;
        Object object2;
        HashMap hashMap;
        String string;
        int n = 0;
        PropertyManager propertyManager = this.getPropertyManager();
        String string2 = propertyManager.getProperty(SVCUtilProperties.SVCProperty.PASSWORD_FILE);
        if (string2 == null) {
            this.usage("No user password file specified", SVCUtilConstants.ErrorAction.Exit_Process);
        }
        if ((string = propertyManager.getProperty(SVCUtilProperties.SVCProperty.ROLE_FILE)) == null) {
            this.usage("No user role specified", SVCUtilConstants.ErrorAction.Exit_Process);
        }
        if ((n = this.readFile(string2, ":", hashMap = new HashMap(), true)) == -3) {
            System.exit(n);
        }
        HashMap hashMap2 = new HashMap();
        n = this.readFile(string, " ", hashMap2, false);
        CIMInstance cIMInstance = this.getFirstInstance(SVCCLASS_POST_V421_CIMOM, CIMUtilConstants.CacheUsage.Refresh_Cache);
        String string3 = this.getStringProperty(cIMInstance, MigrateEncryptedCIMUsers.POST_V421_AGENT_VERSION_PROPERTY.propertyName);
        CIMInstance cIMInstance2 = this.getFirstInstance(SVCCLASS_CLUSTER, CIMUtilConstants.CacheUsage.Refresh_Cache);
        String string4 = this.getStringProperty(cIMInstance2, MigrateEncryptedCIMUsers.CLUSTER_NAME_PROPERTY.propertyName);
        this.statusMsgLn("CIM_AGENT_INFORMATION: Connected to CIM Agent running on cluster <" + string4 + "> at software version <" + string3 + ">");
        Enumeration enumeration = this.enumerateInstances(POST_V421_USER_CLASS);
        HashSet<Object> hashSet = new HashSet<Object>();
        while (enumeration.hasMoreElements()) {
            object2 = (CIMInstance)enumeration.nextElement();
            object = (String)this.getCIMValueValue((CIMInstance)object2, MigrateEncryptedCIMUsers.POST_V421_USER_CLASS.nameProperty);
            hashSet.add(object);
        }
        object2 = hashMap.entrySet().iterator();
        while (object2.hasNext()) {
            object = (Map.Entry)object2.next();
            String string5 = (String)object.getKey();
            String string6 = (String)object.getValue();
            if (string5.equals("superuser")) {
                this.statusMsgLn("Skipping superuser...");
                continue;
            }
            if (hashSet.contains(string5)) {
                this.errorMsgLn("ADD_USER_ERROR: User <" + string5 + "> already exists in target CIMOM.  User will NOT be migrated.");
                n = 1;
                continue;
            }
            String string7 = (String)hashMap2.get(string5);
            Short s = SVCUtilConstants.MakeUserRoleArgument.MONITOR_ROLE;
            if (string7 == null) {
                this.errorMsgLn("Cannot find role for user <" + string5 + ">. User will be migrated with role " + SVCUtilConstants.MakeUserRoleArgument.getRoleName(s) + ".");
            } else {
                try {
                    s = Short.decode(string7);
                }
                catch (NumberFormatException numberFormatException) {
                    this.errorMsgLn("Invalid role <" + string7 + "> for user <" + string5 + ">. User will be migrated with role " + SVCUtilConstants.MakeUserRoleArgument.getRoleName(s) + ".");
                }
            }
            if (this.addEncryptedCIMUser(string5, string6, s)) continue;
            n = -2;
        }
        this.statusMsgLn("Restarting CIM Agent....");
        if (!this.initateAgentShutdown()) {
            System.exit(-2);
        }
        if (n != 0) {
            System.exit(n);
        }
    }

    int readFile(String string, String string2, Map map, boolean bl) {
        int n = 0;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.usage("Could not find the file <" + string + ">", SVCUtilConstants.ErrorAction.Exit_Process);
        }
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        try {
            String string3;
            int n2 = 0;
            int n3 = 0;
            while ((string3 = bufferedReader.readLine()) != null) {
                ++n2;
                if (string3.startsWith("superuser:")) continue;
                ++n3;
                int n4 = string3.indexOf(string2);
                if (n4 <= 0) {
                    this.errorMsgLn("Invalid line #" + n2 + " in " + string + ": <" + string3 + ">.  Ignoring line...");
                    n = -1;
                    continue;
                }
                String string4 = string3.substring(0, n4);
                String string5 = string3.substring(n4 + 1, string3.length());
                map.put(string4, string5);
            }
            if (n3 > 128 && bl) {
                this.errorMsgLn("You have asked to migrate " + n3 + " user accounts except superuser, which exceeds " + 128 + " limit. Please delete some user accounts first.");
                n = -3;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.usage("Error reading from file <" + string + ">", SVCUtilConstants.ErrorAction.Exit_Process);
        }
        return n;
    }
}

