/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.swg.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class FileUtilities {
    public static final int FIND_RECURSIVELY = 0;
    public static final FindOptions OPTIONS_RECURSIVE = FindOptions.OPTIONS_RECURSIVE;
    public static final FindOptions OPTIONS_DEFAULT = FindOptions.OPTIONS_DEFAULT;
    private static final String WILDCARD_CHARS = "*?";

    public static boolean isWildcardPattern(String string) {
        for (int i = 0; i < WILDCARD_CHARS.length(); ++i) {
            if (string.indexOf(WILDCARD_CHARS.charAt(i)) < 0) continue;
            return true;
        }
        return false;
    }

    public static File[] findMatchingFiles(File file, String string) {
        return FileUtilities.findMatchingFiles(file, string, FindOptions.OPTIONS_DEFAULT);
    }

    public static File[] findMatchingFiles(File file, String string, FindOptions findOptions) {
        return FileUtilities.findMatchingFilesAsList(file, string, findOptions).toArray(new File[0]);
    }

    public static List findMatchingFilesAsList(File file, String string, FindOptions findOptions) {
        Object object;
        if (string == null || string.length() == 0) {
            return new LinkedList();
        }
        File file2 = new File(string);
        File file3 = file2.isAbsolute() ? file2.getParentFile() : ((object = file2.getParentFile()) == null ? file : new File(file, ((File)object).getPath()));
        object = FileUtilities.getFiles(file3, null);
        LinkedList<File> linkedList = new LinkedList<File>();
        String string2 = file2.getName();
        boolean bl = findOptions.get(0);
        UtilFilenameFilter utilFilenameFilter = null;
        if (string2 != null) {
            utilFilenameFilter = new UtilFilenameFilter(string2);
        }
        for (int i = 0; i < object.size(); ++i) {
            File file4 = (File)object.get(i);
            if (utilFilenameFilter != null && utilFilenameFilter.accept(null, file4.getName())) {
                linkedList.add(file4);
            }
            if (!bl || !file4.isDirectory()) continue;
            linkedList.addAll(FileUtilities.findMatchingFilesAsList(file4, string, findOptions));
        }
        return linkedList;
    }

    static List getFiles(File file, String string) {
        ArrayList arrayList = new ArrayList();
        if (file == null) {
            return arrayList;
        }
        File[] fileArray = string == null ? file.listFiles() : file.listFiles(new UtilFilenameFilter(string));
        if (fileArray == null || fileArray.length == 0) {
            return arrayList;
        }
        return Arrays.asList(fileArray);
    }

    private FileUtilities() {
    }

    public static void main(String[] stringArray) {
        String string = "*.*";
        File[] fileArray = FileUtilities.findMatchingFiles(new File("c:\\temp\\solution1\\"), string);
        System.out.println("Found files <" + string + "> : ");
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            System.out.println("\t" + file.getAbsolutePath());
        }
    }

    public static final class FindOptions
    extends BitSet {
        public static final int FIND_RECURSIVELY = 0;
        public static final FindOptions OPTIONS_RECURSIVE = new FindOptions().setFlag(0);
        public static final FindOptions OPTIONS_DEFAULT = new FindOptions();

        public FindOptions setFlag(int n) {
            this.set(n);
            return this;
        }
    }

    public static class WildcardFilenameFilter
    implements FilenameFilter {
        private Pattern pattern;

        public WildcardFilenameFilter(String string) {
            string = string.replaceAll("[.]", "\\\\.");
            string = string.replaceAll("[?]", ".");
            string = string.replaceAll("[*]", ".*");
            this.pattern = Pattern.compile(string);
        }

        public boolean accept(File file, String string) {
            return this.pattern.matcher(string).matches();
        }
    }

    public static class ExactFilenameFilter
    implements FilenameFilter {
        private final String m_exactFilename;

        public ExactFilenameFilter(String string) {
            this.m_exactFilename = string;
        }

        public boolean accept(File file, String string) {
            return string.equals(this.m_exactFilename);
        }
    }

    public static class UtilFilenameFilter
    implements FilenameFilter {
        private final FilenameFilter m_filter;

        public UtilFilenameFilter(String string) {
            this.m_filter = FileUtilities.isWildcardPattern(string) ? new WildcardFilenameFilter(string) : new ExactFilenameFilter(string);
        }

        public boolean accept(File file, String string) {
            return this.m_filter.accept(file, string);
        }
    }
}

