/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.swg.util;

import com.ibm.swg.util.Util;
import com.ibm.swg.util.UtilImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.Properties;

public class PropertyManager {
    public static String PROPERTY_VALUE_SEPARATOR = "=";
    private boolean ignoreArgumentCase = true;
    private final Properties properties;
    private final String propertyFileName;
    private final String[] arguments;
    private final Util theUtil;

    public Util getTheUtil() {
        return this.theUtil;
    }

    public PropertyManager(File file, String[] stringArray) {
        this(Util.GlobalUtil.getTheUtil(), file, stringArray);
    }

    public PropertyManager(String string, String[] stringArray) {
        this(Util.GlobalUtil.getTheUtil(), string == null ? null : new File(string), stringArray);
    }

    public PropertyManager(Util util, String string, String[] stringArray) {
        this(util, string == null ? null : new File(string), stringArray);
    }

    public PropertyManager(Util util, File file, String[] stringArray) {
        Properties properties;
        this.theUtil = util == null ? new UtilImpl() : util;
        String[] stringArray2 = this.arguments = stringArray != null ? (String[])stringArray.clone() : null;
        if (file != null) {
            this.propertyFileName = file.getAbsolutePath();
            try {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    properties = new Properties();
                    properties.load(fileInputStream);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    util.errorMsgLn("Could not find properties file <" + this.propertyFileName + ">");
                    properties = null;
                }
                catch (IOException iOException) {
                    util.errorMsgLn("Could not read properties file <" + this.propertyFileName + ">");
                    properties = null;
                }
            }
            catch (MissingResourceException missingResourceException) {
                util.errorMsgLn("Cannot open properties file <" + this.propertyFileName + ">");
                properties = null;
            }
        } else {
            properties = null;
            this.propertyFileName = null;
        }
        this.properties = properties;
    }

    public String getProperty(Property property) {
        return this.getProperty(property, this.arguments);
    }

    public String getProperty(Property property, String[] stringArray) {
        String string = PropertyManager.getPropertyFromArguments(this.theUtil, property, stringArray, this.ignoreArgumentCase);
        if (string != null) {
            return string;
        }
        string = PropertyManager.getPropertyFromList(this.theUtil, property, this.properties);
        if (string != null) {
            return string;
        }
        string = PropertyManager.getPropertyFromEnvironment(this.theUtil, property);
        if (string != null) {
            return string;
        }
        string = property.getDefaultValue();
        if (string != null) {
            this.theUtil.statusMsgLn("Returning default value " + property.getArgumentName() + "=<" + property.getPrintableValue(string) + ">");
            return string;
        }
        return null;
    }

    public static String getPropertyFromArguments(Util util, Property property, String[] stringArray, boolean bl) {
        String string;
        String string2 = property.getArgumentName();
        if (stringArray != null && string2 != null && (string = PropertyManager.findInArguments(stringArray, string2, bl)) != null) {
            util.statusMsgLn("Found " + string2 + "=<" + property.getPrintableValue(string) + "> on command line");
            return string;
        }
        return null;
    }

    public static String getPropertyFromList(Util util, Property property, Properties properties) {
        String string;
        String string2 = property.getPropertyFileName();
        if (properties != null && string2 != null && (string = properties.getProperty(string2)) != null) {
            util.statusMsgLn("Found " + string2 + "=<" + property.getPrintableValue(string) + "> in property file");
            return string;
        }
        return null;
    }

    public static String getPropertyFromEnvironment(Util util, Property property) {
        String string;
        String string2 = property.getEnviromentName();
        if (string2 != null && (string = System.getProperty(string2)) != null) {
            util.statusMsgLn("Found " + string2 + "=<" + property.getPrintableValue(string) + "> in environment");
            return string;
        }
        return null;
    }

    public String getPropertyFileName() {
        return this.propertyFileName;
    }

    private static String findInArguments(String[] stringArray, String string, boolean bl) {
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl2;
            String string2 = stringArray[i];
            String[] stringArray2 = string2.split(PROPERTY_VALUE_SEPARATOR);
            if (stringArray2.length != 2) continue;
            if (bl) {
                bl2 = stringArray2[0].compareToIgnoreCase(string) == 0;
            } else {
                boolean bl3 = bl2 = stringArray2[0].compareTo(string) == 0;
            }
            if (!bl2) continue;
            return stringArray2[1];
        }
        return null;
    }

    public boolean isIgnoreArgumentCase() {
        return this.ignoreArgumentCase;
    }

    public void setIgnoreArgumentCase(boolean bl) {
        this.ignoreArgumentCase = bl;
    }

    public static class PropertyImpl
    implements Property {
        private final String propertyFileName;
        private final String environmentName;
        private final String argumentName;
        private final DefaultValueProvider defaultValueProvider;
        private final String description;
        private boolean isHidden;

        public PropertyImpl(String string, String string2, String string3, String string4, DefaultValueProvider defaultValueProvider, boolean bl) {
            this.argumentName = string2;
            this.propertyFileName = string3;
            this.environmentName = string4;
            this.defaultValueProvider = defaultValueProvider;
            this.isHidden = bl;
            this.description = string;
        }

        public PropertyImpl(String string, String string2, String string3, String string4, String string5, boolean bl) {
            this(string, string2, string3, string4, new ConstantValue(string5), bl);
        }

        public PropertyImpl(String string, String string2, String string3, String string4, DefaultValueProvider defaultValueProvider) {
            this(string, string2, string3, string4, defaultValueProvider, false);
        }

        public PropertyImpl(String string, String string2, String string3, String string4, String string5) {
            this(string, string2, string3, string4, new ConstantValue(string5), false);
        }

        public String getPrintableValue(String string) {
            if (!this.isHidden) {
                return string;
            }
            char[] cArray = new char[string.length()];
            Arrays.fill(cArray, '*');
            return new String(cArray);
        }

        public String getPropertyFileName() {
            return this.propertyFileName;
        }

        public String getArgumentName() {
            return this.argumentName;
        }

        public String getEnviromentName() {
            return this.environmentName;
        }

        public String getDefaultValue() {
            return this.defaultValueProvider.getDefaultValue();
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static interface Property {
        public String getPrintableValue(String var1);

        public String getPropertyFileName();

        public String getArgumentName();

        public String getEnviromentName();

        public String getDescription();

        public String getDefaultValue();
    }

    public static class PromptValue
    implements DefaultValueProvider {
        private final String message;

        public PromptValue(String string) {
            this.message = string;
        }

        public String getDefaultValue() {
            System.out.print(this.message);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            try {
                return bufferedReader.readLine();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(-1);
                return null;
            }
        }
    }

    public static class ConstantValue
    implements DefaultValueProvider {
        private final String defaultValue;

        public ConstantValue(String string) {
            this.defaultValue = string;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }

    public static interface DefaultValueProvider {
        public String getDefaultValue();
    }
}

