/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.swg.util;

import com.ibm.swg.util.Util;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;

public class UtilImpl
implements Util {
    private boolean m_printStatus = true;
    private Writer m_copyStream = null;
    private boolean m_printTimestamp = true;
    private boolean m_newLine = true;
    private String m_prefixString = null;

    public UtilImpl() {
        Util.GlobalUtil.setTheUtil(this);
    }

    public boolean isStatusPrinting() {
        return this.m_printStatus;
    }

    public void setStatusPrinting(boolean bl) {
        this.m_printStatus = bl;
    }

    public Writer setMsgOutputCopy(Writer writer) {
        Writer writer2 = writer;
        this.m_copyStream = writer;
        return writer2;
    }

    public Writer getMsgOutputCopy() {
        return this.m_copyStream;
    }

    public void warnMsg(String string) {
        this.putMsg("WARNING: " + string);
    }

    public void warnMsgLn(String string) {
        this.putMsgLn("WARNING: " + string);
    }

    public void errorMsg(String string) {
        this.putMsg("ERROR: " + string);
    }

    public void errorMsgLn(String string) {
        this.putMsgLn("ERROR: " + string);
    }

    public void statusMsg(String string) {
        if (this.m_printStatus) {
            this.putMsg(string);
        }
    }

    public void statusMsgLn(String string) {
        if (this.m_printStatus) {
            this.putMsgLn(string);
        }
    }

    public static String getTimeStamp() {
        Date date = new Date();
        return DateFormat.getDateTimeInstance(3, 2).format(date);
    }

    public boolean isPrintTimestamp() {
        return this.m_printTimestamp;
    }

    public void setPrintTimestamp(boolean bl) {
        this.m_printTimestamp = bl;
    }

    public void putMsg(String string) {
        if (this.m_newLine) {
            string = this.getPrepend() + string;
        }
        System.out.print(string);
        this.m_newLine = false;
        if (this.m_copyStream != null) {
            try {
                this.m_copyStream.write(string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void putMsgLn(String string) {
        if (this.m_newLine) {
            string = this.getPrepend() + string;
        }
        System.out.println(string);
        this.m_newLine = true;
        if (this.m_copyStream != null) {
            try {
                this.m_copyStream.write(string + System.getProperty("line.separator"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getMsgPrefix() {
        return this.m_prefixString;
    }

    public String setMsgPrefix(String string) {
        String string2 = this.getMsgPrefix();
        this.m_prefixString = string;
        return string2;
    }

    private String getPrepend() {
        String string;
        String string2 = string = this.m_prefixString == null ? "" : this.m_prefixString;
        if (this.m_printTimestamp) {
            string = string + UtilImpl.getTimeStamp() + " : ";
        }
        return string;
    }
}

