/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.swg.util.cim;

import com.ibm.swg.util.cim.CIMUtil;
import java.util.Arrays;
import java.util.Vector;
import org.sblim.wbem.cim.CIMArgument;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.cim.UnsignedInt32;
import org.sblim.wbem.cim.UnsignedInt64;

public interface CIMClassConstants {
    public static final CIMDataType CIM_DATATYPE_BOOLEAN = CIMDataType.getPredefinedType((int)9);
    public static final CIMDataType CIM_DATATYPE_REFERENCE = CIMDataType.getPredefinedType((int)14);
    public static final CIMDataType CIM_DATATYPE_STRING = CIMDataType.getPredefinedType((int)8);
    public static final CIMDataType CIM_DATATYPE_STRING_ARRAY = CIMDataType.getPredefinedType((int)24);
    public static final CIMDataType CIM_DATATYPE_UINT16 = CIMDataType.getPredefinedType((int)2);
    public static final CIMDataType CIM_DATATYPE_UINT32 = CIMDataType.getPredefinedType((int)4);
    public static final CIMDataType CIM_DATATYPE_UINT64 = CIMDataType.getPredefinedType((int)6);

    public static class CIMCompletStaticMethod
    extends CIMCompleteMethod {
        private final CIMBasicClass theClass;

        public CIMCompletStaticMethod(String string, CIMDataType cIMDataType, CIMBasicClass cIMBasicClass) {
            super(string, cIMDataType);
            this.theClass = cIMBasicClass;
        }

        public CIMBasicClass getStaticClass() {
            return this.theClass;
        }
    }

    public static class CIMCompleteMethod
    extends CIMSimpleMethod {
        private Vector inParams = new Vector();
        private Vector outParams = new Vector();

        public String getMethodName() {
            return this.methodName;
        }

        public CIMDataType getReturnType() {
            return this.returnType;
        }

        public Vector getInParams() {
            return this.inParams;
        }

        public Vector getOutParams() {
            return this.outParams;
        }

        public CIMCompleteMethod(String string, CIMDataType cIMDataType) {
            super(string, cIMDataType);
        }

        public class OutParameter
        extends Parameter {
            public OutParameter(String string, CIMDataType cIMDataType) {
                super(string, cIMDataType);
            }

            public CIMValue getValue(CIMUtil cIMUtil) {
                return cIMUtil.findArgument(CIMCompleteMethod.this.getOutParams(), this.getName());
            }
        }

        public class InParameter
        extends Parameter {
            public InParameter(String string, CIMDataType cIMDataType) {
                super(string, cIMDataType);
            }

            public void createParameter(Object object) {
                CIMCompleteMethod.this.inParams.add(new CIMArgument(this.getName(), new CIMValue(object, this.getType())));
            }
        }

        private class Parameter {
            private final String name;
            private final CIMDataType type;

            public String getName() {
                return this.name;
            }

            public CIMDataType getType() {
                return this.type;
            }

            public Parameter(String string, CIMDataType cIMDataType) {
                this.type = cIMDataType;
                this.name = string;
            }
        }
    }

    public static class CIMSimpleMethod {
        public final String methodName;
        public final CIMDataType returnType;

        public String getMethodName() {
            return this.methodName;
        }

        public CIMDataType getReturnType() {
            return this.returnType;
        }

        public CIMSimpleMethod(String string, CIMDataType cIMDataType) {
            this.methodName = string;
            this.returnType = cIMDataType;
        }
    }

    public static class CIMUint32ArrayProperty
    extends CIMBasicProperty {
        public CIMUint32ArrayProperty(String string) {
            super(string, CIM_DATATYPE_UINT32);
        }

        public CIMProperty createProperty(int n) {
            return this.createProperty(new UnsignedInt32(n));
        }
    }

    public static class CIMUint64ArrayProperty
    extends CIMBasicProperty {
        public CIMUint64ArrayProperty(String string) {
            super(string, CIM_DATATYPE_UINT64);
        }

        public CIMProperty createProperty(long l) {
            return this.createProperty(new UnsignedInt64(l));
        }
    }

    public static class CIMStringArrayProperty
    extends CIMBasicProperty {
        public CIMStringArrayProperty(String string) {
            super(string, CIM_DATATYPE_STRING_ARRAY);
        }

        public CIMProperty createProperty(String[] stringArray) {
            return this.createProperty(new Vector<String>(Arrays.asList(stringArray)));
        }

        public CIMProperty createProperty(Vector vector) {
            return this.createProperty(vector);
        }
    }

    public static class CIMStringProperty
    extends CIMBasicProperty {
        public CIMStringProperty(String string) {
            super(string, CIM_DATATYPE_STRING);
        }

        public CIMProperty createProperty(String string) {
            return this.createProperty(string);
        }
    }

    public static abstract class CIMBasicProperty {
        public final String propertyName;
        public final CIMDataType dataType;

        public String getName() {
            return this.propertyName;
        }

        public CIMDataType getType() {
            return this.dataType;
        }

        public CIMBasicProperty(String string, CIMDataType cIMDataType) {
            this.propertyName = string;
            this.dataType = cIMDataType;
        }

        protected CIMProperty createProperty(Object object) {
            return new CIMProperty(this.getName(), new CIMValue(object, this.getType()));
        }
    }

    public static class CIMNameNamedCIMClass
    extends CIMNamedClass {
        public CIMNameNamedCIMClass(String string) {
            super(string, "Name");
        }
    }

    public static class CIMNamedClass
    extends CIMBasicClass {
        public final String nameProperty;

        public CIMNamedClass(String string, String string2) {
            super(string);
            this.nameProperty = string2;
        }
    }

    public static class CIMElementNameNamedClass
    extends CIMNamedClass {
        public CIMElementNameNamedClass(String string) {
            super(string, "ElementName");
        }
    }

    public static class CIMCaptionNamedClass
    extends CIMNamedClass {
        public CIMCaptionNamedClass(String string) {
            super(string, "Caption");
        }
    }

    public static class CIMBasicClass {
        public final String className;

        public CIMBasicClass(String string) {
            this.className = string;
        }

        public CIMObjectPath getCOP() {
            return new CIMObjectPath(this.className);
        }
    }
}

