/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.swg.util.cim;

import com.ibm.swg.util.cim.CIMClassConstants;
import java.util.Vector;
import org.sblim.wbem.cim.CIMObjectPath;

public interface CIMQueryConstants
extends CIMClassConstants {

    public static class Query {
        public static final FilterRelationship FILTER_LIKE = new FilterRelationship("LIKE");
        private final String className;
        private Vector properties = new Vector();
        private Vector filters = new Vector();
        private String queryLanguage = "WQL";

        public Query(String string) throws NullPointerException {
            if (string == null) {
                throw new NullPointerException();
            }
            this.className = string;
        }

        public Query(CIMClassConstants.CIMBasicClass cIMBasicClass) throws NullPointerException {
            if (cIMBasicClass == null) {
                throw new NullPointerException();
            }
            this.className = cIMBasicClass.className;
        }

        public Query(CIMClassConstants.CIMNamedClass cIMNamedClass, String string) {
            this.className = cIMNamedClass.className;
            this.addFilter(this.className, FILTER_LIKE, string);
        }

        public void addProperty(String string) {
            this.properties.add(string);
        }

        public void addProperties(String[] stringArray) {
            if (stringArray == null) {
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                this.properties.add(stringArray[i]);
            }
        }

        public void addFilters(Filter[] filterArray) {
            if (filterArray == null) {
                return;
            }
            for (int i = 0; i < filterArray.length; ++i) {
                if (filterArray[i] == null) continue;
                this.filters.add(filterArray[i]);
            }
        }

        public void addFilter(Filter filter) {
            this.filters.add(filter);
        }

        public void addFilter(String string, FilterRelationship filterRelationship, String string2) {
            this.filters.add(new Filter(string, filterRelationship, string2));
        }

        public String getQueryString() {
            int n;
            StringBuffer stringBuffer = new StringBuffer("SELECT ");
            if (this.properties.size() == 0) {
                stringBuffer.append("* ");
            } else {
                stringBuffer.append(this.properties.get(0));
                for (n = 1; n < this.properties.size(); ++n) {
                    stringBuffer.append(", " + this.properties.get(n));
                }
                stringBuffer.append(" ");
            }
            stringBuffer.append("FROM " + this.className);
            if (this.filters.size() > 0) {
                stringBuffer.append(" WHERE");
                for (n = 0; n < this.filters.size(); ++n) {
                    Filter filter = (Filter)this.filters.get(n);
                    stringBuffer.append(" " + filter.getFilterString());
                }
            }
            return stringBuffer.toString();
        }

        public CIMObjectPath getCOP() {
            return new CIMObjectPath(this.className);
        }

        public String getQueryLanguage() {
            return this.queryLanguage;
        }

        public static final class Filter {
            private final String propertyName;
            private final String pattern;
            private final FilterRelationship relationship;

            public Filter(String string, FilterRelationship filterRelationship, String string2) {
                this.propertyName = string;
                this.relationship = filterRelationship;
                this.pattern = string2;
            }

            public String getPropertyName() {
                return this.propertyName;
            }

            public String getPattern() {
                return this.pattern;
            }

            public FilterRelationship getRelationship() {
                return this.relationship;
            }

            public String getFilterString() {
                return this.propertyName + " " + this.relationship.getKeyword() + " \"" + this.pattern + "\"";
            }
        }

        public static final class FilterRelationship {
            private final String keyword;

            private FilterRelationship(String string) {
                this.keyword = string;
            }

            public String getKeyword() {
                return this.keyword;
            }
        }
    }
}

