/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.swg.util.cim;

import com.ibm.swg.util.Util;
import com.ibm.swg.util.UtilConstants;
import com.ibm.swg.util.UtilImpl;
import com.ibm.swg.util.cim.CIMClassConstants;
import com.ibm.swg.util.cim.CIMConnectionConstants;
import com.ibm.swg.util.cim.CIMQueryConstants;
import com.ibm.swg.util.cim.CIMUtil;
import com.ibm.swg.util.cim.CIMUtilConstants;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.sblim.wbem.cim.CIMArgument;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMNameSpace;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.client.CIMClient;
import org.sblim.wbem.client.PasswordCredential;
import org.sblim.wbem.client.UserPrincipal;

public class CIMUtilImpl
implements CIMUtilConstants,
CIMUtil {
    private Hashtable classQueries = new Hashtable();
    private CIMClient client;
    private CIMNameSpace nameSpace;
    private boolean timingLogged = false;
    private Util theUtil = null;

    public CIMUtilImpl(Util util) {
        this.theUtil = util;
    }

    public CIMUtilImpl() {
        this.theUtil = new UtilImpl();
    }

    public synchronized Enumeration associators(CIMObjectPath cIMObjectPath, String string, String string2, String string3, String string4, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        this.statusMsgLn("Finding instances associated with:" + cIMObjectPath);
        UtilConstants.Timer timer = null;
        if (this.timingLogged) {
            timer = UtilConstants.Timer.startTimer();
        }
        Enumeration enumeration = this.client.associators(cIMObjectPath, string, string2, string3, string4, bl, bl2, stringArray);
        if (this.timingLogged) {
            long l = timer.stopTimer();
            this.statusMsgLn("Associators of <" + cIMObjectPath + "> took <" + l + "> msec.");
        }
        return enumeration;
    }

    public boolean checkPropertyType(CIMInstance cIMInstance, String string, CIMDataType cIMDataType) {
        if (cIMInstance == null) {
            this.warnMsg("CIMUtilImpl.checkPropertyType: inst is null, returning false");
            return false;
        }
        return this.checkPropertyType(cIMInstance.getProperty(string), cIMDataType);
    }

    public boolean checkPropertyType(CIMProperty cIMProperty, CIMDataType cIMDataType) {
        if (cIMProperty == null) {
            return false;
        }
        return cIMProperty.getType().equals((Object)cIMDataType);
    }

    public void connect(CIMConnectionConstants.CimomInformation cimomInformation) {
        String string = "";
        if (cimomInformation.PROTOCOL == SECURE_PROTOCOL) {
            string = cimomInformation.ADDRESS.getValue();
            this.setNameSpace(new CIMNameSpace(string, cimomInformation.NAME_SPACE.getValue()));
            this.getNameSpace().setPort(cimomInformation.PORT.getValue());
            URL uRL = this.getNameSpace().getHostURL();
            URL uRL2 = null;
            try {
                uRL2 = new URL("https", uRL.getHost(), uRL.getPort(), uRL.getFile());
            }
            catch (MalformedURLException malformedURLException) {
                this.errorMsgLn("Error connecting to CIMOM: " + string + ":" + cimomInformation.PORT.getValue() + " -- URL format is not correct");
                malformedURLException.printStackTrace();
                return;
            }
            this.setNameSpace(new CIMNameSpace(uRL2.toExternalForm(), cimomInformation.NAME_SPACE.getValue()));
        } else {
            string = cimomInformation.PROTOCOL.getValue() + cimomInformation.ADDRESS.getValue();
            this.setNameSpace(new CIMNameSpace(string, cimomInformation.NAME_SPACE.getValue()));
            this.getNameSpace().setPort(cimomInformation.PORT.getValue());
        }
        try {
            this.setClient(new CIMClient(this.getNameSpace(), (Principal)new UserPrincipal(cimomInformation.USER_NAME.getValue()), (Object)new PasswordCredential(cimomInformation.PASSWORD.getValue().toCharArray())));
        }
        catch (CIMException cIMException) {
            this.errorMsgLn("Error connecting to CIMOM: " + string + ":" + cimomInformation.PORT.getValue());
            cIMException.printStackTrace();
        }
        this.statusMsgLn("Connected to: " + string + ":" + cimomInformation.PORT.getValue());
    }

    public boolean isConnected() {
        return this.getClient() != null;
    }

    public Enumeration enumerateInstanceNames(CIMObjectPath cIMObjectPath) throws CIMException {
        this.statusMsgLn("Enumerating instances of:" + cIMObjectPath);
        UtilConstants.Timer timer = null;
        if (this.timingLogged) {
            timer = UtilConstants.Timer.startTimer();
        }
        Enumeration enumeration = this.client.enumerateInstanceNames(cIMObjectPath);
        if (this.timingLogged) {
            long l = timer.stopTimer();
            this.statusMsgLn("Enumeration of names for <" + cIMObjectPath + "> took <" + l + "> msec.");
        }
        return enumeration;
    }

    public Enumeration enumerateInstanceNames(String string) {
        return this.client.enumerateInstanceNames(new CIMObjectPath(string));
    }

    public Enumeration enumerateInstances(CIMClassConstants.CIMBasicClass cIMBasicClass) throws CIMException {
        CIMObjectPath cIMObjectPath = cIMBasicClass.getCOP();
        this.statusMsgLn("Enumerating instances of:" + cIMObjectPath);
        UtilConstants.Timer timer = null;
        if (this.timingLogged) {
            timer = UtilConstants.Timer.startTimer();
        }
        Enumeration enumeration = this.client.enumInstances(cIMObjectPath, true);
        if (this.timingLogged) {
            long l = timer.stopTimer();
            this.statusMsgLn("Enumeration of <" + cIMObjectPath + "> took <" + l + "> msec.");
        }
        return enumeration;
    }

    public Enumeration enumerateInstances(CIMObjectPath cIMObjectPath) throws CIMException {
        this.statusMsgLn("Enumerating instances of:" + cIMObjectPath);
        UtilConstants.Timer timer = null;
        if (this.timingLogged) {
            timer = UtilConstants.Timer.startTimer();
        }
        Enumeration enumeration = this.client.enumInstances(cIMObjectPath, true);
        if (this.timingLogged) {
            long l = timer.stopTimer();
            this.statusMsgLn("Enumeration of <" + cIMObjectPath + "> took <" + l + "> msec.");
        }
        return enumeration;
    }

    public Enumeration enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, boolean bl4, String[] stringArray) throws CIMException {
        return this.client.enumerateInstances(cIMObjectPath, bl, bl2, bl3, bl4, stringArray);
    }

    public synchronized Enumeration execQuery(CIMObjectPath cIMObjectPath, String string, String string2) throws CIMException {
        this.statusMsgLn("Executing query <" + string + "> on CIM class: " + cIMObjectPath);
        UtilConstants.Timer timer = null;
        if (this.timingLogged) {
            timer = UtilConstants.Timer.startTimer();
        }
        Enumeration enumeration = this.client.execQuery(cIMObjectPath, string, string2);
        if (this.timingLogged) {
            long l = timer.stopTimer();
            this.statusMsgLn("Executing query <" + string + "> on CIM class <" + cIMObjectPath + "took <" + l + "> msec.");
        }
        return enumeration;
    }

    public Enumeration execQuery(CIMQueryConstants.Query query) {
        return this.execQuery(query.getCOP(), query.getQueryString(), query.getQueryLanguage());
    }

    public CIMValue findArgument(Vector vector, String string) {
        for (int i = 0; i < vector.size(); ++i) {
            CIMArgument cIMArgument = (CIMArgument)vector.elementAt(i);
            if (!cIMArgument.getName().equalsIgnoreCase(string)) continue;
            this.statusMsgLn("Found argument: " + cIMArgument);
            return cIMArgument.getValue();
        }
        return null;
    }

    public Enumeration getAssociatedObjects(CIMObjectPath cIMObjectPath, CIMClassConstants.CIMBasicClass cIMBasicClass, CIMClassConstants.CIMBasicClass cIMBasicClass2) {
        return this.getAssociatedObjects(cIMObjectPath, cIMBasicClass.className, cIMBasicClass2.className);
    }

    public Enumeration getAssociatedObjects(CIMObjectPath cIMObjectPath, String string, String string2) {
        return this.associators(cIMObjectPath, string, string2, null, null, false, true, null);
    }

    public boolean getBoolProperty(CIMInstance cIMInstance, String string) {
        if (!this.checkPropertyType(cIMInstance, string, CIM_DATATYPE_BOOLEAN)) {
            return false;
        }
        return this.getCIMValueValue(cIMInstance, string).equals(Boolean.TRUE);
    }

    public CIMValue getCIMValue(CIMInstance cIMInstance, String string) {
        return cIMInstance.getProperty(string).getValue();
    }

    public Object getCIMValueValue(CIMInstance cIMInstance, String string) {
        CIMValue cIMValue = this.getCIMValue(cIMInstance, string);
        return cIMValue == null ? null : cIMValue.getValue();
    }

    public CIMClient getClient() {
        return this.client;
    }

    public CIMInstance getFirstInstance(CIMClassConstants.CIMBasicClass cIMBasicClass, CIMUtilConstants.CacheUsage cacheUsage) {
        return (CIMInstance)this.enumerateInstances(new CIMObjectPath(cIMBasicClass.className)).nextElement();
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath) {
        return this.client.getInstance(cIMObjectPath);
    }

    public int getIntProperty(CIMInstance cIMInstance, String string) {
        return ((Number)this.getCIMValueValue(cIMInstance, string)).intValue();
    }

    public CIMInstance getNamedInstance(CIMClassConstants.CIMBasicClass cIMBasicClass, String string, String string2, CIMUtilConstants.CacheUsage cacheUsage) {
        return this.getNamedInstance(cIMBasicClass.className, string, string2, cacheUsage);
    }

    public CIMInstance getNamedInstance(CIMClassConstants.CIMNamedClass cIMNamedClass, String string, CIMUtilConstants.CacheUsage cacheUsage) {
        return this.getNamedInstance(cIMNamedClass.className, string, cIMNamedClass.nameProperty, cacheUsage);
    }

    public CIMNameSpace getNameSpace() {
        return this.nameSpace;
    }

    public CIMObjectPath getObjectPath(CIMInstance cIMInstance) {
        return cIMInstance.getObjectPath();
    }

    public CIMProperty[] getProperty(String string, String string2) {
        Enumeration enumeration = this.enumerateInstances(new CIMObjectPath(string));
        if (enumeration == null) {
            return null;
        }
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        while (enumeration.hasMoreElements()) {
            CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
            CIMProperty cIMProperty = cIMInstance.getProperty(string2);
            if (cIMProperty == null) continue;
            vector.addElement(cIMProperty);
        }
        if (vector.size() == 0) {
            return null;
        }
        return (CIMProperty[])vector.toArray();
    }

    public String[] getStringArrayProperty(CIMInstance cIMInstance, String string) {
        if (!this.checkPropertyType(cIMInstance, string, CIM_DATATYPE_STRING_ARRAY)) {
            return null;
        }
        Vector vector = (Vector)this.getCIMValueValue(cIMInstance, string);
        if (vector == null) {
            return null;
        }
        return vector.toArray(new String[1]);
    }

    public String getStringProperty(CIMInstance cIMInstance, String string) {
        if (!this.checkPropertyType(cIMInstance, string, CIM_DATATYPE_STRING)) {
            return null;
        }
        return (String)this.getCIMValueValue(cIMInstance, string);
    }

    public CIMValue invokeMethod(CIMInstance cIMInstance, String string, CIMArgument[] cIMArgumentArray) {
        return this.invokeMethod(cIMInstance, string, new Vector<CIMArgument>(Arrays.asList(cIMArgumentArray)));
    }

    public CIMValue invokeMethod(CIMInstance cIMInstance, String string, CIMArgument[] cIMArgumentArray, Vector vector) {
        return this.invokeMethod(cIMInstance.getObjectPath(), string, new Vector<CIMArgument>(Arrays.asList(cIMArgumentArray)), vector);
    }

    public CIMValue invokeMethod(CIMInstance cIMInstance, String string, Vector vector) {
        return this.invokeMethod(cIMInstance.getObjectPath(), string, vector);
    }

    public CIMValue invokeMethod(CIMInstance cIMInstance, String string, Vector vector, Vector vector2) {
        return this.invokeMethod(cIMInstance.getObjectPath(), string, vector, vector2);
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, CIMArgument[] cIMArgumentArray) {
        return this.invokeMethod(cIMObjectPath, string, new Vector<CIMArgument>(Arrays.asList(cIMArgumentArray)));
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, CIMArgument[] cIMArgumentArray, Vector vector) {
        return this.invokeMethod(cIMObjectPath, string, new Vector<CIMArgument>(Arrays.asList(cIMArgumentArray)), vector);
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector) {
        return this.invokeMethod(cIMObjectPath, string, vector, null);
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, CIMClassConstants.CIMSimpleMethod cIMSimpleMethod) {
        return this.invokeMethod(cIMObjectPath, cIMSimpleMethod.getMethodName(), (Vector)null);
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, CIMClassConstants.CIMCompleteMethod cIMCompleteMethod) {
        return this.invokeMethod(cIMObjectPath, cIMCompleteMethod.getMethodName(), cIMCompleteMethod.getInParams(), cIMCompleteMethod.getOutParams());
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) {
        this.statusMsgLn(">>> Invoking method: " + string);
        if (vector != null && vector.size() > 0) {
            this.statusMsgLn("    with input parameters:");
            for (int i = 0; i < vector.size(); ++i) {
                this.statusMsgLn("        [" + i + "] : " + (vector.get(i) == null ? "<null>" : vector.get(i)));
            }
        }
        if (vector2 == null) {
            vector2 = new Vector();
        }
        if (vector != null && vector.size() == 0) {
            vector = null;
        }
        CIMValue cIMValue = this.getClient().invokeMethod(cIMObjectPath, string, vector, vector2);
        this.statusMsgLn("<<< Method <" + string + "> returned value: " + cIMValue);
        if (vector2.size() > 0) {
            this.statusMsgLn("<<< Output parameters from method: " + string);
            for (int i = 0; i < vector2.size(); ++i) {
                this.statusMsgLn("        [" + i + "] : " + (vector2.get(i) == null ? "<null>" : vector2.get(i)));
            }
        }
        return cIMValue;
    }

    public boolean isTimingLogged() {
        return this.timingLogged;
    }

    public void listObjects(CIMClassConstants.CIMBasicClass cIMBasicClass) {
        Enumeration enumeration = this.enumerateInstances(cIMBasicClass.getCOP());
        this.printInstances(enumeration);
    }

    public void printInstance(CIMInstance cIMInstance) {
        this.printInstance(cIMInstance, -1);
    }

    public void printInstance(CIMInstance cIMInstance, int n) {
        if (n >= 0) {
            this.statusMsg("** Element #");
        }
        this.statusMsgLn(cIMInstance.toString());
    }

    public void printInstances(Enumeration enumeration) {
        if (enumeration == null || !enumeration.hasMoreElements()) {
            this.statusMsgLn("** No instances present **");
            return;
        }
        int n = 0;
        while (enumeration.hasMoreElements()) {
            CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
            this.statusMsgLn("** Element #" + ++n + " **: " + cIMInstance);
        }
    }

    public void setClient(CIMClient cIMClient) {
        this.client = cIMClient;
    }

    public void setNameSpace(CIMNameSpace cIMNameSpace) {
        this.nameSpace = cIMNameSpace;
    }

    public void setProperty(CIMInstance cIMInstance, String string, CIMValue cIMValue) {
        this.getClient().setProperty(cIMInstance.getObjectPath(), string, cIMValue);
    }

    public void setProperty(CIMClassConstants.CIMBasicClass cIMBasicClass, String string, String string2, String string3, CIMValue cIMValue) {
        CIMInstance cIMInstance = this.getNamedInstance(cIMBasicClass, string, string2, CIMUtilConstants.CacheUsage.Get_From_Cache);
        this.getClient().setProperty(cIMInstance.getObjectPath(), string3, cIMValue);
    }

    public void setProperty(CIMClassConstants.CIMNamedClass cIMNamedClass, String string, String string2, CIMValue cIMValue) {
        CIMInstance cIMInstance = this.getNamedInstance(cIMNamedClass, string, CIMUtilConstants.CacheUsage.Get_From_Cache);
        this.getClient().setProperty(cIMInstance.getObjectPath(), string2, cIMValue);
    }

    public void setProperty(String string, String string2, CIMValue cIMValue) {
        Enumeration enumeration = this.enumerateInstances(new CIMObjectPath(string));
        CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
        this.getClient().setProperty(cIMInstance.getObjectPath(), string2, cIMValue);
    }

    public void setTimingLogged(boolean bl) {
        this.timingLogged = bl;
    }

    protected CIMInstance getNamedInstance(String string, String string2, String string3, CIMUtilConstants.CacheUsage cacheUsage) throws CIMException {
        Enumeration enumeration;
        CIMObjectPath cIMObjectPath;
        Vector<CIMInstance> vector = null;
        if (cacheUsage == CIMUtilConstants.CacheUsage.Get_From_Cache) {
            vector = (Vector)this.classQueries.get(string);
        }
        if (vector == null) {
            cIMObjectPath = new CIMObjectPath(string);
            enumeration = this.enumerateInstances(cIMObjectPath);
            vector = new Vector<CIMInstance>();
            while (enumeration.hasMoreElements()) {
                vector.add((CIMInstance)enumeration.nextElement());
            }
            this.classQueries.put(string, vector);
        }
        cIMObjectPath = vector.elements();
        while (cIMObjectPath.hasMoreElements()) {
            enumeration = (CIMInstance)cIMObjectPath.nextElement();
            String string4 = (String)enumeration.getProperty(string3).getValue().getValue();
            if (!string2.equals(string4)) continue;
            this.statusMsgLn("Found " + string + " : " + string2);
            return enumeration;
        }
        throw new CIMException("CIM_ERR_NOT_FOUND");
    }

    public Writer setMsgOutputCopy(Writer writer) {
        return this.theUtil.setMsgOutputCopy(writer);
    }

    public void errorMsg(String string) {
        this.theUtil.errorMsg(string);
    }

    public void errorMsgLn(String string) {
        this.theUtil.errorMsgLn(string);
    }

    public boolean isPrintTimestamp() {
        return this.theUtil.isPrintTimestamp();
    }

    public boolean isStatusPrinting() {
        return this.theUtil.isStatusPrinting();
    }

    public void setPrintTimestamp(boolean bl) {
        this.theUtil.setPrintTimestamp(bl);
    }

    public void setStatusPrinting(boolean bl) {
        this.theUtil.setStatusPrinting(bl);
    }

    public void statusMsg(String string) {
        this.theUtil.statusMsg(string);
    }

    public void statusMsgLn(String string) {
        this.theUtil.statusMsgLn(string);
    }

    public void warnMsg(String string) {
        this.theUtil.warnMsg(string);
    }

    public void warnMsgLn(String string) {
        this.theUtil.warnMsgLn(string);
    }

    public void putMsg(String string) {
        this.theUtil.putMsg(string);
    }

    public void putMsgLn(String string) {
        this.theUtil.putMsgLn(string);
    }

    public String getMsgPrefix() {
        return this.theUtil.getMsgPrefix();
    }

    public String setMsgPrefix(String string) {
        return this.theUtil.setMsgPrefix(string);
    }

    public Writer getMsgOutputCopy() {
        return this.theUtil.getMsgOutputCopy();
    }

    public CIMValue invokeMethod(CIMClassConstants.CIMCompletStaticMethod cIMCompletStaticMethod) {
        return this.invokeMethod(cIMCompletStaticMethod.getStaticClass().getCOP(), cIMCompletStaticMethod);
    }
}

