/*
 * Decompiled with CFR 0.152.
 */
package javax.security.cert;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.CPSuri;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.UserNotice;
import java.io.IOException;

public final class PolicyQualifierInfo {
    private byte[] encodedInfo;
    private ObjectIdentifier qualifierId;
    private byte[] qualifier;

    public PolicyQualifierInfo(byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue derValue = derInputStream.getDerValue();
        this.decode(derValue);
        this.encodedInfo = (byte[])byArray.clone();
    }

    public byte[] getEncoded() {
        return (byte[])this.encodedInfo.clone();
    }

    public String getPolicyQualifierId() {
        return this.qualifierId.toString();
    }

    public byte[] getPolicyQualifier() {
        if (this.qualifier == null) {
            return null;
        }
        return (byte[])this.qualifier.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PolicyQualifierInfo: \nObjectIdentifier\t" + this.getPolicyQualifierId() + "\n");
        try {
            if (this.qualifierId.equals(PKIXExtensions.CPSuri_Id)) {
                if (this.qualifier != null) {
                    stringBuffer.append(new CPSuri(this.qualifier).toString());
                }
            } else if (this.qualifierId.equals(PKIXExtensions.UserNotice_Id) && this.qualifier != null) {
                stringBuffer.append(new UserNotice(this.qualifier).toString());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    private void decode(DerValue derValue) throws IOException {
        if (derValue.getTag() != 48) {
            throw new IOException("PolicyQualifierInfo parsing error, not a SEQUENCE");
        }
        this.qualifierId = derValue.getData().getOID();
        DerValue derValue2 = derValue.getData().getDerValue();
        byte[] byArray = derValue2.toByteArray();
        this.qualifier = (byte[])(this.qualifierId.equals(PKIXExtensions.CPSuri_Id) || this.qualifierId.equals(PKIXExtensions.UserNotice_Id) ? byArray : null);
        if (derValue.getData().available() != 0) {
            throw new IOException("PolicyQualifierInfo parsing error - data overrun, bytes = " + derValue.getData().available());
        }
    }
}

