/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.base;

import com.ibm.security.certclient.base.PkEventFormatter;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkRepEvent;
import com.ibm.security.certclient.base.PkReqEvent;
import com.ibm.security.certclient.util.PkString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PkHttpRepEvent
extends PkRepEvent {
    private final String contentType;
    private final transient InputStream inputStream;

    public PkHttpRepEvent(Object source, Object msg, PkReqEvent req, String contentType, InputStream inputStream) {
        super(source, msg, req);
        this.contentType = contentType;
        this.inputStream = inputStream;
    }

    public PkHttpRepEvent(Object source, Object msg, PkReqEvent req, String contentType, byte[] reply) {
        this(source, msg, req, contentType, new ByteArrayInputStream(reply));
    }

    public PkHttpRepEvent(Object source, Object msg, PkReqEvent req, String contentType, String reply) {
        this(source, msg, req, contentType, PkString.toUtf(reply));
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void write(PkEventFormatter formatter, OutputStream outputStream) throws IOException, PkException {
        formatter.writeHttpRep(this, outputStream);
    }

    public String toString() {
        return super.toString() + "Content Type: " + this.contentType + "\n";
    }
}

