/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.util;

import com.ibm.misc.Debug;
import com.ibm.security.certclient.util.PkBase64Constants;
import java.io.IOException;
import java.io.OutputStream;

public class PkBase64OutputStream
extends OutputStream
implements PkBase64Constants {
    private static Debug debug = Debug.getInstance((String)"keycertmanage");
    private final Object className = this;
    private final OutputStream out;
    private int state;
    private int carry;

    public PkBase64OutputStream(OutputStream out) throws IOException {
        this.out = out;
    }

    public void write(int b) throws IOException {
        switch (this.state % 3) {
            case 0: {
                this.out.write(PkBase64Constants.base64Values[b >>> 2 & 0x3F]);
                this.carry = b & 3;
                break;
            }
            case 1: {
                this.out.write(PkBase64Constants.base64Values[this.carry << 4 | b >>> 4 & 0xF]);
                this.carry = b & 0xF;
                break;
            }
            case 2: {
                this.out.write(PkBase64Constants.base64Values[this.carry << 2 | b >>> 6 & 3]);
                this.out.write(PkBase64Constants.base64Values[b & 0x3F]);
            }
        }
        ++this.state;
        if (this.state == 57) {
            this.state = 0;
            this.out.write(13);
            this.out.write(10);
        }
    }

    public void end() throws IOException {
        switch (this.state % 3) {
            case 0: {
                break;
            }
            case 1: {
                this.out.write(PkBase64Constants.base64Values[this.carry << 4]);
                this.out.write(61);
                this.out.write(61);
                this.state += 2;
                break;
            }
            case 2: {
                this.out.write(PkBase64Constants.base64Values[this.carry << 2]);
                this.out.write(61);
                ++this.state;
            }
        }
        if (this.state != 57) {
            this.out.write(13);
            this.out.write(10);
        }
        this.state = -1;
    }
}

