/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.keystoreski;

import com.ibm.misc.BASE64Decoder;
import com.ibm.misc.BASE64Encoder;
import com.ibm.misc.Debug;
import com.ibm.security.keystoreski.SKIDefinition;
import com.ibm.security.keystoreski.SKIDefinitionException;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;

public final class SKIDefinitionFactory {
    private static final String SUBJECT_KEY_IDENTIFIER_OID = "2.5.29.14";

    private SKIDefinitionFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static SKIDefinition newSHA1PublicKeySKIDefinition() {
        return new SHA1PublicKeySKIDefinition();
    }

    public static SKIDefinition newSHA1PublicKeyTruncatedSKIDefinition() {
        return new SHA1PublicKeyTruncatedSKIDefinition();
    }

    public static SKIDefinition newX509ExtensionSKIDefinition() {
        return new X509ExtensionSKIDefinition();
    }

    public static SKIDefinition newCompositeSKIDefinition(SKIDefinition[] definitions) {
        return new CompositeSKIDefinition(definitions);
    }

    private static final class CompositeSKIDefinition
    implements SKIDefinition {
        private static Debug debug = Debug.getInstance((String)"keycertmanage");
        private final Object className = this.toString();
        private final SKIDefinition[] definitions;

        CompositeSKIDefinition(SKIDefinition[] definitions) {
            this.definitions = definitions;
        }

        public String getSubjectKeyIdentifier(X509Certificate cert) throws NullPointerException {
            if (debug != null) {
                debug.text(1L, this.className, "getSubjectKeyIdentifier", "entering method");
            }
            if (cert == null) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getSubjectKeyIdentifier", (Throwable)new NullPointerException());
                }
                throw new NullPointerException();
            }
            for (int i = 0; i < this.definitions.length; ++i) {
                String ski;
                SKIDefinition definition = null;
                definition = this.definitions[i];
                if (definition == null || (ski = definition.getSubjectKeyIdentifier(cert)) == null) continue;
                if (debug != null) {
                    debug.text(1L, this.className, "getSubjectKeyIdentifier", "exiting method");
                }
                return ski;
            }
            if (debug != null) {
                debug.text(1L, this.className, "getSubjectKeyIdentifier", "returning null");
            }
            return null;
        }
    }

    private static final class SHA1PublicKeyTruncatedSKIDefinition
    implements SKIDefinition {
        private static Debug debug = Debug.getInstance((String)"keycertmanage");
        private final Object className = this.toString();

        SHA1PublicKeyTruncatedSKIDefinition() {
        }

        public String getSubjectKeyIdentifier(X509Certificate cert) throws NullPointerException {
            if (debug != null) {
                debug.text(1L, this.className, "getSubjectKeyIdentifier", "entering method");
            }
            if (cert == null) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getSubjectKeyIdentifier", (Throwable)new NullPointerException());
                }
                throw new NullPointerException();
            }
            String ski = new SHA1PublicKeySKIDefinition().getSubjectKeyIdentifier(cert);
            if (ski == null) {
                if (debug != null) {
                    debug.text(1L, this.className, "getSubjectKeyIdentifier", "returning null");
                }
                return null;
            }
            try {
                byte[] skiBytes = new BASE64Decoder().decodeBuffer(ski);
                byte[] shortSKI = new byte[8];
                System.arraycopy(skiBytes, skiBytes.length - 8, shortSKI, 0, 8);
                shortSKI[0] = (byte)(shortSKI[0] & 0xF | 0x40);
                if (debug != null) {
                    debug.text(1L, this.className, "getSubjectKeyIdentifier", "exiting method");
                }
                return new BASE64Encoder().encode(shortSKI);
            }
            catch (Exception e) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getSubjectKeyIdentifier", (Throwable)e);
                }
                throw new SKIDefinitionException(e.getMessage(), e);
            }
        }
    }

    private static final class SHA1PublicKeySKIDefinition
    implements SKIDefinition {
        private static Debug debug = Debug.getInstance((String)"keycertmanage");
        private final Object className = this.toString();

        SHA1PublicKeySKIDefinition() {
        }

        public String getSubjectKeyIdentifier(X509Certificate cert) throws NullPointerException {
            if (debug != null) {
                debug.text(1L, this.className, "getSubjectKeyIdentifier", "entering method");
            }
            if (cert == null) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getSubjectKeyIdentifier", (Throwable)new NullPointerException());
                }
                throw new NullPointerException();
            }
            byte[] encoded = cert.getPublicKey().getEncoded();
            try {
                DerInputStream derStream = new DerInputStream(encoded);
                DerValue[] values = derStream.getSequence(2);
                if (values == null || values.length != 2) {
                    if (debug != null) {
                        debug.exception(4L, this.className, "getSubjectKeyIdentifier", (Throwable)new InvalidKeyException("Public Key is not in X509 format."));
                    }
                    throw new InvalidKeyException("Public Key is not in X509 format.");
                }
                byte[] bitString = values[1].getBitString();
                MessageDigest md = MessageDigest.getInstance("SHA1");
                byte[] digest = md.digest(bitString);
                if (debug != null) {
                    debug.text(1L, this.className, "getSubjectKeyIdentifier", "exiting method");
                }
                return new BASE64Encoder().encode(digest);
            }
            catch (Exception e) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getSubjectKeyIdentifier", (Throwable)e);
                }
                throw new SKIDefinitionException(e.getMessage(), e);
            }
        }
    }

    private static final class X509ExtensionSKIDefinition
    implements SKIDefinition {
        private static Debug debug = Debug.getInstance((String)"keycertmanage");
        private final Object className = this.toString();

        X509ExtensionSKIDefinition() {
        }

        public String getSubjectKeyIdentifier(X509Certificate cert) throws NullPointerException {
            if (debug != null) {
                debug.text(1L, this.className, "getSubjectKeyIdentifier", "entering method");
            }
            if (cert == null) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getSubjectKeyIdentifier", (Throwable)new NullPointerException());
                }
                throw new NullPointerException();
            }
            byte[] extDERVal = cert.getExtensionValue(SKIDefinitionFactory.SUBJECT_KEY_IDENTIFIER_OID);
            String skiVal = null;
            if (extDERVal != null) {
                try {
                    DerValue derKeyIdVal = new DerValue(extDERVal);
                    byte[] keyIdContent = derKeyIdVal.getOctetString();
                    DerValue derSKI = new DerValue(keyIdContent);
                    skiVal = new BASE64Encoder().encode(derSKI.getOctetString());
                }
                catch (IOException ex) {
                    if (debug != null) {
                        debug.exception(4L, this.className, "getSubjectKeyIdentifier", (Throwable)ex);
                    }
                    throw new RuntimeException(ex);
                }
            }
            if (debug != null) {
                debug.text(1L, this.className, "getSubjectKeyIdentifier", "exiting method");
            }
            return skiVal;
        }
    }
}

