/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.keystoreutil;

import com.ibm.misc.BASE64Encoder;
import com.ibm.misc.Debug;
import com.ibm.security.keystoreutil.KeyStoreTranslator;
import com.ibm.security.keystoreutil.KeyStoreTranslatorParameters;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;

public final class KeyStoreUtil {
    private static Debug debug = Debug.getInstance((String)"keycertmanage");
    private static final Object className = "com.ibm.security.keystoreutil.KeyStoreUtil";

    private KeyStoreUtil() {
        throw new UnsupportedOperationException();
    }

    public static KeyStoreTranslator newTranslator(String outType) throws KeyStoreException {
        return new KeyStoreTranslatorImpl(outType);
    }

    public static KeyStoreTranslator newTranslator(String outType, Provider provider) throws KeyStoreException {
        return new KeyStoreTranslatorImpl(outType, provider);
    }

    public static KeyStoreTranslator newTranslator(String outType, String provider) throws KeyStoreException, NoSuchProviderException {
        return new KeyStoreTranslatorImpl(outType, provider);
    }

    public static KeyStoreTranslatorParameters newTranslatorParameters(KeyStore source, char[] accessPassword, Map KeyPasswords) {
        return new TranslatorParametersImpl(source, accessPassword, KeyPasswords);
    }

    public static void importCertificate(InputStream input, KeyStore store, String alias) throws CertificateException, IOException, KeyStoreException {
        if (debug != null) {
            debug.text(1L, className, "importCertificate", "entering method");
        }
        if (input == null) {
            if (debug != null) {
                debug.exception(4L, className, "importCertificate", (Throwable)new NullPointerException("input stream cannot be null."));
            }
            throw new NullPointerException("input stream cannot be null.");
        }
        if (store == null) {
            if (debug != null) {
                debug.exception(4L, className, "importCertificate", (Throwable)new NullPointerException("KeyStore cannot be null."));
            }
            throw new NullPointerException("KeyStore cannot be null.");
        }
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        X509Certificate certificate = (X509Certificate)factory.generateCertificate(input);
        String subjectCN = alias;
        if (subjectCN == null) {
            X500Name subjectDN = (X500Name)certificate.getSubjectDN();
            subjectCN = subjectDN.getCommonName();
        }
        store.setCertificateEntry(subjectCN, certificate);
        if (debug != null) {
            debug.text(1L, className, "importCertificate", "exiting method");
        }
    }

    public static void importCertificates(InputStream input, KeyStore store) throws CertificateException, IOException, KeyStoreException {
        if (debug != null) {
            debug.text(1L, className, "importCertificates", "entering method");
        }
        if (input == null) {
            if (debug != null) {
                debug.exception(4L, className, "importCertificates", (Throwable)new NullPointerException("input stream cannot be null."));
            }
            throw new NullPointerException("input stream cannot be null.");
        }
        if (store == null) {
            if (debug != null) {
                debug.exception(4L, className, "importCertificates", (Throwable)new NullPointerException("KeyStore cannot be null."));
            }
            throw new NullPointerException("KeyStore cannot be null.");
        }
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> certificates = factory.generateCertificates(input);
        Iterator<? extends Certificate> it = certificates.iterator();
        while (it.hasNext()) {
            X509Certificate certificate = (X509Certificate)it.next();
            X500Name subjectDN = (X500Name)certificate.getSubjectDN();
            store.setCertificateEntry(subjectDN.getCommonName(), certificate);
        }
        if (debug != null) {
            debug.text(1L, className, "importCertificates", "exiting method");
        }
    }

    public static void exportCertificate(OutputStream output, KeyStore store, String alias, boolean useBase64Encoding) throws KeyStoreException, CertificateEncodingException, IOException {
        if (debug != null) {
            debug.text(1L, className, "exportCertificate", "entering method");
        }
        String BEGIN_CERT = "-----BEGIN CERTIFICATE-----\r\n";
        String END_CERT = "\r\n-----END CERTIFICATE-----";
        if (output == null) {
            if (debug != null) {
                debug.exception(4L, className, "exportCertificate", (Throwable)new NullPointerException("output stream cannot be null."));
            }
            throw new NullPointerException("output stream cannot be null.");
        }
        if (store == null) {
            if (debug != null) {
                debug.exception(4L, className, "exportCertificate", (Throwable)new NullPointerException("KeyStore cannot be null."));
            }
            throw new NullPointerException("KeyStore cannot be null.");
        }
        if (alias == null || alias.length() == 0) {
            if (debug != null) {
                debug.exception(4L, className, "exportCertificate", (Throwable)new NullPointerException("alias cannot be null."));
            }
            throw new NullPointerException("alias cannot be null.");
        }
        Certificate certificate = store.getCertificate(alias);
        if (certificate == null) {
            if (debug != null) {
                debug.exception(4L, className, "exportCertificate", (Throwable)new KeyStoreException("Certificate cannot be found in KeyStore."));
            }
            throw new KeyStoreException("Certificate cannot be found in KeyStore.");
        }
        byte[] derCert = certificate.getEncoded();
        if (useBase64Encoding) {
            output.write("-----BEGIN CERTIFICATE-----\r\n".getBytes("8859_1"));
            new BASE64Encoder().encode(derCert, output);
            output.write("\r\n-----END CERTIFICATE-----".getBytes("8859_1"));
        } else {
            output.write(derCert);
        }
        if (debug != null) {
            debug.text(1L, className, "exportCertificate", "exiting method");
        }
    }

    private static final class TranslatorParametersImpl
    implements KeyStoreTranslatorParameters {
        private KeyStore source = null;
        private char[] accessPassword = null;
        private Map keyPasswords = null;

        private static void wipeArray(char[] array) {
            for (int i = 0; i < array.length; ++i) {
                array[i] = '\u0000';
            }
        }

        TranslatorParametersImpl(KeyStore source, char[] accessPassword, Map keyPasswords) {
            if (source == null) {
                throw new NullPointerException("The source KeyStore cannot be null.");
            }
            if (accessPassword == null) {
                throw new NullPointerException("The source KeyStore access password should be provided.");
            }
            this.source = source;
            this.accessPassword = accessPassword;
            this.keyPasswords = keyPasswords;
        }

        public KeyStore getSourceKeyStore() {
            return this.source;
        }

        public char[] getKeyStoreAccessPassword() {
            return this.accessPassword;
        }

        public char[] getKeyProtectionPassword(String alias) {
            if (this.keyPasswords == null || this.keyPasswords.isEmpty()) {
                return this.accessPassword;
            }
            if (this.keyPasswords.containsKey(alias)) {
                return (char[])this.keyPasswords.get(alias);
            }
            return this.accessPassword;
        }

        public void destroyParameters() {
            this.source = null;
            TranslatorParametersImpl.wipeArray(this.accessPassword);
            this.accessPassword = null;
            if (this.keyPasswords != null && !this.keyPasswords.isEmpty()) {
                Iterator it = this.keyPasswords.values().iterator();
                while (it.hasNext()) {
                    TranslatorParametersImpl.wipeArray((char[])it.next());
                }
                this.keyPasswords.clear();
                this.keyPasswords = null;
            }
        }
    }

    private static final class KeyStoreTranslatorImpl
    implements KeyStoreTranslator {
        private KeyStore targetStore = null;

        KeyStoreTranslatorImpl(String outType) throws KeyStoreException {
            this.targetStore = KeyStore.getInstance(outType);
        }

        KeyStoreTranslatorImpl(String outType, Provider provider) throws KeyStoreException {
            this.targetStore = KeyStore.getInstance(outType, provider);
        }

        KeyStoreTranslatorImpl(String outType, String provider) throws KeyStoreException, NoSuchProviderException {
            this.targetStore = KeyStore.getInstance(outType, provider);
        }

        public KeyStore translateStore(KeyStoreTranslatorParameters parameters) {
            try {
                KeyStore sourceStore = parameters.getSourceKeyStore();
                Enumeration<String> aliases = sourceStore.aliases();
                this.targetStore.load(null, parameters.getKeyStoreAccessPassword());
                this.deleteAllEntries(this.targetStore);
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    if (sourceStore.isKeyEntry(alias)) {
                        Key key = sourceStore.getKey(alias, parameters.getKeyProtectionPassword(alias));
                        Certificate[] chain = sourceStore.getCertificateChain(alias);
                        this.targetStore.setKeyEntry(alias, key, parameters.getKeyProtectionPassword(alias), chain);
                        continue;
                    }
                    if (!sourceStore.isCertificateEntry(alias)) continue;
                    Certificate cert = sourceStore.getCertificate(alias);
                    this.targetStore.setCertificateEntry(alias, cert);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return this.targetStore;
        }

        private void deleteAllEntries(KeyStore store) throws KeyStoreException {
            ArrayList<String> list = Collections.list(store.aliases());
            Iterator<String> itr = list.iterator();
            while (itr.hasNext()) {
                String alias = itr.next();
                store.deleteEntry(alias);
            }
        }
    }
}

