/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.correlation;

public class Stack {
    protected Object[] stack;
    protected int top;
    protected int increment;
    public Object privateStorage;

    public Stack(int size, int increment) {
        this.stack = new Object[size];
        this.top = -1;
        this.increment = increment;
    }

    public synchronized Object peek() {
        try {
            return this.stack[this.top];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public synchronized Object peek(int offset) {
        return offset < 0 || this.top < offset ? null : this.stack[this.top - offset];
    }

    public synchronized void push(Object item) {
        try {
            this.stack[++this.top] = item;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Object[] newStack = new Object[this.top + this.increment];
            System.arraycopy(this.stack, 0, newStack, 0, this.top);
            this.stack = newStack;
            this.stack[this.top] = item;
        }
    }

    public synchronized Object pop() {
        try {
            return this.stack[this.top--];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            ++this.top;
            return null;
        }
    }
}

