/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.core.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.ExecutionComponentStateException;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutionEnvironment;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.core.IOrderedProperty;
import org.eclipse.hyades.execution.core.IProcessConsole;
import org.eclipse.hyades.execution.core.impl.ExecutionComponentImpl;
import org.eclipse.hyades.execution.core.impl.ProcessExecutableObjectImpl;
import org.eclipse.hyades.execution.core.util.Noop;

public class ProcessExecutorImpl
extends ExecutionComponentImpl
implements IProcessConsole,
IExecutor {
    private String name;
    private IExecutableObject exeObj;
    private OutputStream stdin;
    private InputStream stdout;
    private InputStream stderr;
    private ConsoleInputThread cin;
    private ConsoleOutputThread cout;
    private ConsoleErrorThread cerr;
    private IOrderedProperty[] processEnvironment = null;
    private int pid = 0;

    static {
        try {
            System.loadLibrary("hcclco");
            System.loadLibrary("hclaunch");
        }
        catch (Throwable throwable) {}
    }

    public ProcessExecutorImpl() {
        this.name = null;
    }

    public ProcessExecutorImpl(String _name) {
        this.name = _name;
    }

    public void init() {
        super.init();
        this.cin = new ConsoleInputThread("Process console in");
        this.cout = new ConsoleOutputThread("Process console out");
        this.cerr = new ConsoleErrorThread("Process console error");
        this.cin.setDaemon(true);
        this.cout.setDaemon(true);
        this.cerr.setDaemon(true);
        Noop.sink((Object)this.name, this.processEnvironment);
    }

    public void setExecutableObject(IExecutableObject obj) {
        this.exeObj = obj;
    }

    public IExecutableObject getExecutableObject() {
        return this.exeObj;
    }

    public void launch() {
        IExecutionComponent parent;
        do {
            if (!((parent = this.getParent()) instanceof IExecutionEnvironment)) continue;
            this.processEnvironment = ((IExecutionEnvironment)parent).getEnv();
            break;
        } while (parent != null);
        this.cin.start();
        this.cout.start();
        this.cerr.start();
        this.pid = this.startProcess0();
        if (this.pid < 0) {
            System.out.println("Launch error, return code from startProcess0() = " + this.pid);
            return;
        }
        if (System.getProperty("os.name").startsWith("Windows")) {
            ProcessStatusThread procThread = new ProcessStatusThread(this, this.pid);
            procThread.start();
        }
    }

    public void kill() {
        this.killProcess0();
    }

    public OutputStream getStandardInputStream() throws ExecutionComponentStateException {
        if (this.stdin == null) {
            throw new ExecutionComponentStateException(1, "No standard input stream has been set");
        }
        return this.stdin;
    }

    public InputStream getStandardOutputStream() throws ExecutionComponentStateException {
        if (this.stdout == null) {
            throw new ExecutionComponentStateException(1, "No standard output stream has been set");
        }
        return this.stdout;
    }

    public InputStream getStandardErrorStream() throws ExecutionComponentStateException {
        if (this.stderr == null) {
            throw new ExecutionComponentStateException(1, "No standard error stream has been set");
        }
        return this.stderr;
    }

    private void processExited() {
        if (this.state == 2) {
            ExecutionComponentStateChangeEvent event = new ExecutionComponentStateChangeEvent(this, 4);
            this.fireStateChangeEvent(event);
        }
    }

    public String getPid() {
        return new Integer(this.pid).toString();
    }

    public int getProcessStatus(int pid) {
        return this.getProcessStatus0(pid);
    }

    public IProcessConsole getProcessConsole() {
        return this;
    }

    public IExecutableObject getCompatibleExecutableObject(String classname) throws ClassNotFoundException {
        IExecutableObject result = null;
        Class<?> clazz = Class.forName(classname);
        try {
            result = (IExecutableObject)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        if (result != null && result instanceof ProcessExecutableObjectImpl) {
            return result;
        }
        return null;
    }

    private native int startProcess0();

    private native void killProcess0();

    private native void writeToProcess0(char var1);

    private native int readFromProcessOutput0();

    private native int readFromProcessError0();

    private native int getProcessStatus0(int var1);

    public boolean supportsControlEvent(String controlEvent) {
        return false;
    }

    public String performControlEvent(String controlEvent, String[] params) {
        return "";
    }

    class ConsoleErrorThread
    extends Thread {
        private PipedOutputStream writer;

        public ConsoleErrorThread(String name) {
            this.setName(name);
            this.setDaemon(true);
            ProcessExecutorImpl.this.stderr = new PipedInputStream();
            try {
                this.writer = new PipedOutputStream((PipedInputStream)ProcessExecutorImpl.this.stderr);
            }
            catch (IOException e0) {
                e0.printStackTrace();
            }
        }

        public void run() {
            int b = 0;
            while (!this.isInterrupted()) {
                try {
                    b = ProcessExecutorImpl.this.readFromProcessError0();
                    if (b == -1) break;
                    this.writer.write(b);
                    this.writer.flush();
                }
                catch (Exception exception) {
                    System.out.println("Console error closed by process");
                    break;
                }
            }
        }
    }

    class ConsoleInputThread
    extends Thread {
        private PipedInputStream reader;
        private char c;

        public ConsoleInputThread(String name) {
            this.setName(name);
            this.setDaemon(true);
            ProcessExecutorImpl.this.stdin = new PipedOutputStream();
            try {
                this.reader = new PipedInputStream((PipedOutputStream)ProcessExecutorImpl.this.stdin);
            }
            catch (IOException e0) {
                e0.printStackTrace();
            }
        }

        public void run() {
            while (!this.isInterrupted()) {
                try {
                    this.c = (char)this.reader.read();
                    ProcessExecutorImpl.this.writeToProcess0(this.c);
                }
                catch (IOException iOException) {
                    System.out.println("Console input closed by process");
                    break;
                }
            }
        }
    }

    class ConsoleOutputThread
    extends Thread {
        private PipedOutputStream writer;

        public ConsoleOutputThread(String name) {
            this.setName(name);
            this.setDaemon(true);
            ProcessExecutorImpl.this.stdout = new PipedInputStream();
            try {
                this.writer = new PipedOutputStream((PipedInputStream)ProcessExecutorImpl.this.stdout);
            }
            catch (IOException e0) {
                e0.printStackTrace();
            }
        }

        public void run() {
            while (!this.isInterrupted()) {
                try {
                    int b = ProcessExecutorImpl.this.readFromProcessOutput0();
                    if (b == -1) break;
                    this.writer.write(b);
                    this.writer.flush();
                }
                catch (IOException iOException) {
                    System.out.println("Console output closed by process");
                    break;
                }
            }
        }
    }

    class ProcessStatusThread
    extends Thread {
        int pid;
        int cur_state = 2;
        IExecutor executor;

        public ProcessStatusThread(IExecutor _executor, int _pid) {
            this.setName("Process status monitor");
            this.executor = _executor;
            this.setDaemon(true);
            this.pid = _pid;
        }

        public void run() {
            while (this.cur_state != 4) {
                this.cur_state = ProcessExecutorImpl.this.getProcessStatus(this.pid);
                try {
                    ProcessStatusThread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            ProcessExecutorImpl.this.processExited();
        }
    }
}

