/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.core.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.HashMap;
import java.util.Observable;
import java.util.regex.Pattern;
import org.eclipse.hyades.internal.execution.core.file.communicator.ChannelCommunicatorFactory;
import org.eclipse.hyades.internal.execution.core.file.communicator.IChannelCommunicator;

public class ScopedChannelClassLoader
extends Observable {

    private static abstract class AbstractControlDirective {
        abstract boolean accept(ControlDirectiveVisitor var1) throws IOException;

        public static class BeginControlDirective
        extends AbstractControlDirective {
            public boolean accept(ControlDirectiveVisitor visitor) throws IOException {
                return visitor.visit(this);
            }
        }

        private static abstract class ControlDirectiveVisitor {
            private ControlDirectiveVisitor() {
            }

            abstract boolean visit(BeginControlDirective var1) throws IOException;

            abstract boolean visit(EndControlDirective var1) throws IOException;

            abstract boolean visit(IdentifyControlDirective var1) throws IOException;

            abstract boolean visit(LoadControlDirective var1) throws IOException;
        }

        public static class EndControlDirective
        extends AbstractControlDirective {
            boolean accept(ControlDirectiveVisitor visitor) throws IOException {
                return visitor.visit(this);
            }
        }

        public static class IdentifyControlDirective
        extends AbstractControlDirective {
            public boolean accept(ControlDirectiveVisitor visitor) throws IOException {
                return visitor.visit(this);
            }
        }

        private static class LoadControlDirective
        extends AbstractControlDirective {
            LoadControlDirective() {
            }

            boolean accept(ControlDirectiveVisitor visitor) throws IOException {
                return visitor.visit(this);
            }
        }
    }

    public static class Consumer
    extends Observable {
        private static final HashMap classLoaders = new HashMap();
        private final IChannelCommunicator communicator;
        private final String context;
        private final ContextClassLoader contextClassLoader;
        private final String host;
        private boolean isEnabled = false;
        private String scopingExpression;
        private Pattern scopingPattern;
        private final String user;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        static /* synthetic */ Class class$2;
        static /* synthetic */ Class class$3;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Consumer(String scopingExpression, ReadableByteChannel readableChannel, WritableByteChannel writableChannel) throws IOException {
            this.scopingExpression = scopingExpression;
            this.communicator = ChannelCommunicatorFactory.getInstance().create(readableChannel, writableChannel);
            this.scopingPattern = Pattern.compile(this.scopingExpression);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.hyades.execution.core.loader.ScopedChannelClassLoader$AbstractControlDirective$IdentifyControlDirective");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.communicator.send(clazz.getName());
            this.context = this.communicator.receiveString();
            this.host = this.communicator.receiveString();
            this.user = this.communicator.receiveString();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.hyades.execution.core.loader.ScopedChannelClassLoader$Provider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz3 = clazz2;
            synchronized (clazz2) {
                ContextClassLoader classLoader = (ContextClassLoader)classLoaders.get(this.context);
                if (classLoader == null) {
                    classLoader = new ContextClassLoader();
                    classLoaders.put(this.context, classLoader);
                }
                this.contextClassLoader = classLoader;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        }

        public ClassLoader getContextClassLoader() {
            return this.contextClassLoader;
        }

        public void setEnabled(boolean isEnabled) throws IOException {
            this.isEnabled = isEnabled;
            if (this.isEnabled) {
                this.contextClassLoader.setState(this, this.communicator, this.scopingPattern, this.isEnabled);
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.hyades.execution.core.loader.ScopedChannelClassLoader$AbstractControlDirective$BeginControlDirective");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.communicator.send(clazz.getName());
            } else {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("org.eclipse.hyades.execution.core.loader.ScopedChannelClassLoader$AbstractControlDirective$EndControlDirective");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.communicator.send(clazz.getName());
                this.contextClassLoader.unsetState();
            }
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + "[context=" + this.context + ", host=" + this.host + ", user=" + this.user + ", contextClassLoader=" + this.contextClassLoader + "]";
        }

        private static class ContextClassLoader
        extends ClassLoader {
            private final InheritableThreadLocal communicator = new InheritableThreadLocal();
            private final InheritableThreadLocal consumer = new InheritableThreadLocal();
            private final InheritableThreadLocal isEnabled = new InheritableThreadLocal();
            private final InheritableThreadLocal scopingPattern = new InheritableThreadLocal();
            static /* synthetic */ Class class$0;

            private ContextClassLoader() {
            }

            private byte[] consume(String name) {
                try {
                    IChannelCommunicator iChannelCommunicator = this.getCommunicator();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.hyades.execution.core.loader.ScopedChannelClassLoader$AbstractControlDirective$LoadControlDirective");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    iChannelCommunicator.send(clazz.getName());
                    this.getCommunicator().send(name);
                    int classDataLength = this.getCommunicator().receiveInt();
                    byte[] data = this.getCommunicator().receiveBytes(classDataLength);
                    this.getConsumer().setChanged();
                    this.getConsumer().notifyObservers(name);
                    return data;
                }
                catch (Throwable throwable) {
                    return null;
                }
            }

            private IChannelCommunicator getCommunicator() {
                return (IChannelCommunicator)this.communicator.get();
            }

            private Consumer getConsumer() {
                return (Consumer)this.consumer.get();
            }

            private Pattern getScopingPattern() {
                return (Pattern)this.scopingPattern.get();
            }

            private boolean isEnabled() {
                Boolean isEnabled = (Boolean)this.isEnabled.get();
                return isEnabled == null ? false : isEnabled;
            }

            public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
                if (this.responsibleFor(name)) {
                    Class<?> loadedClass = this.findLoadedClass(name);
                    if (loadedClass == null) {
                        byte[] bytes = this.loadClassData(name);
                        loadedClass = this.defineClass(name, bytes, 0, bytes.length);
                    }
                    if (resolve) {
                        this.resolveClass(loadedClass);
                    }
                    return loadedClass;
                }
                return super.loadClass(name, resolve);
            }

            private byte[] loadClassData(String name) {
                return this.consume(name);
            }

            private boolean responsibleFor(String element) {
                return this.isEnabled() ? this.getScopingPattern().matcher(element).lookingAt() : false;
            }

            void setState(Consumer consumer, IChannelCommunicator communicator, Pattern scopingPattern, boolean isEnabled) {
                this.consumer.set(consumer);
                this.communicator.set(communicator);
                this.scopingPattern.set(scopingPattern);
                this.isEnabled.set(new Boolean(isEnabled));
            }

            void unsetState() {
                this.consumer.set(null);
                this.communicator.set(null);
                this.scopingPattern.set(null);
                this.isEnabled.set(null);
            }
        }
    }

    public static class Provider
    extends Observable {
        private final IChannelCommunicator communicator;
        private final String context;
        private String host;
        private final int maximumClassSize;
        private ClassLoader sourceClassLoader;
        private final String user;
        static /* synthetic */ Class class$0;

        public Provider(String context, ClassLoader sourceClassLoader, ReadableByteChannel readableChannel, WritableByteChannel writableChannel, int maximumClassSize) {
            this.context = context;
            this.sourceClassLoader = sourceClassLoader;
            this.communicator = ChannelCommunicatorFactory.getInstance().create(readableChannel, writableChannel);
            try {
                this.host = InetAddress.getLocalHost().toString();
            }
            catch (UnknownHostException unknownHostException) {}
            this.user = System.getProperty("user.name");
            this.maximumClassSize = maximumClassSize * 1024;
        }

        public void provide() throws IOException {
            boolean provide = true;
            do {
                String directiveName = this.communicator.receiveString();
                try {
                    Class<?> directiveClass = Class.forName(directiveName);
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.hyades.execution.core.loader.ScopedChannelClassLoader$AbstractControlDirective");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (!clazz.isAssignableFrom(directiveClass)) continue;
                    Object directiveObject = directiveClass.newInstance();
                    AbstractControlDirective directive = (AbstractControlDirective)directiveObject;
                    provide = directive.accept(new AbstractControlDirective.ControlDirectiveVisitor(this){
                        final /* synthetic */ Provider this$1;
                        {
                            this.this$1 = provider;
                        }

                        public boolean visit(AbstractControlDirective.BeginControlDirective directive) {
                            return true;
                        }

                        public boolean visit(AbstractControlDirective.EndControlDirective directive) {
                            return false;
                        }

                        public boolean visit(AbstractControlDirective.IdentifyControlDirective directive) throws IOException {
                            Provider.access$0(this.this$1).send(Provider.access$1(this.this$1));
                            Provider.access$0(this.this$1).send(Provider.access$2(this.this$1));
                            Provider.access$0(this.this$1).send(Provider.access$3(this.this$1));
                            return true;
                        }

                        public boolean visit(AbstractControlDirective.LoadControlDirective directive) throws IOException {
                            String className = Provider.access$0(this.this$1).receiveString();
                            className = String.valueOf(className.replace('.', '/')) + ".class";
                            InputStream classInputStream = Provider.access$4(this.this$1).getResourceAsStream(className);
                            ReadableByteChannel classReadableChannel = Channels.newChannel(classInputStream);
                            ByteBuffer classData = ByteBuffer.allocate(Provider.access$5(this.this$1));
                            int classDataLength = classReadableChannel.read(classData);
                            classData.flip();
                            Provider.access$0(this.this$1).send(classDataLength);
                            byte[] classDataBytes = new byte[classDataLength];
                            classData.get(classDataBytes);
                            Provider.access$0(this.this$1).send(classDataBytes);
                            Provider.access$6(this.this$1);
                            this.this$1.notifyObservers(className);
                            return true;
                        }
                    });
                }
                catch (Throwable throwable) {}
            } while (provide);
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + "[context=" + this.context + ", host=" + this.host + ", user=" + this.user + "]";
        }

        static /* synthetic */ IChannelCommunicator access$0(Provider provider) {
            return provider.communicator;
        }

        static /* synthetic */ String access$1(Provider provider) {
            return provider.context;
        }

        static /* synthetic */ String access$2(Provider provider) {
            return provider.host;
        }

        static /* synthetic */ String access$3(Provider provider) {
            return provider.user;
        }

        static /* synthetic */ ClassLoader access$4(Provider provider) {
            return provider.sourceClassLoader;
        }

        static /* synthetic */ int access$5(Provider provider) {
            return provider.maximumClassSize;
        }

        static /* synthetic */ void access$6(Provider provider) {
            provider.setChanged();
        }
    }
}

