/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.core.task;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.execution.core.task.ReusableThread;
import org.eclipse.hyades.execution.core.task.ReusableThreadPool;

public class ProgressiveTask
implements Runnable {
    private static final int DEFAULT_CANCEL_POLL_INTERVAL = 3000;
    private static final int DEFAULT_WORK_UNITS_PER_POLL = 10;
    private static final ReusableThreadPool threadPool = new ReusableThreadPool();
    private final int cancelPollInterval;
    private final String name;
    private final IProgressMonitor progressMonitor;
    private final Runnable runnable;
    private ReusableThread taskThread;
    private ReusableThread workerThread;

    public ProgressiveTask(String name, Runnable runnable, IProgressMonitor monitor) {
        this(name, runnable, monitor, 3000);
    }

    public ProgressiveTask(String name, Runnable runnable, IProgressMonitor monitor, int cancelPollInterval) {
        this.name = name;
        this.runnable = runnable;
        this.progressMonitor = monitor;
        this.cancelPollInterval = cancelPollInterval;
    }

    public void execute(Synchronicity synchronicity) {
        if (synchronicity == Synchronicity.ASYNCHRONOUS) {
            this.taskThread = threadPool.acquireThread();
            this.taskThread.attach(this);
            this.taskThread.start();
        } else {
            this.run();
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isCanceled() {
        return this.progressMonitor.isCanceled();
    }

    public boolean isComplete() {
        return this.workerThread.isComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.workerThread = threadPool.acquireThread();
        this.workerThread.attach(this.runnable);
        this.workerThread.start();
        while (!this.isCanceled() && !this.workerThread.isComplete()) {
            try {
                ReusableThread reusableThread = this.workerThread;
                synchronized (reusableThread) {
                    this.workerThread.wait(this.cancelPollInterval);
                }
                this.progressMonitor.worked(10);
            }
            catch (InterruptedException interruptedException) {}
        }
        threadPool.releaseThread(this.workerThread);
        if (this.taskThread != null) {
            threadPool.releaseThread(this.taskThread);
        }
    }

    public static final class Synchronicity {
        public static final Synchronicity ASYNCHRONOUS = new Synchronicity();
        public static final Synchronicity SYNCHRONOUS = new Synchronicity();

        private Synchronicity() {
        }
    }
}

