/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.core.util;

import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;

public final class ConnectionSpecifier {
    private static final Pattern AUTHORITY_REGULAR_EXPRESSION_PATTERN = Pattern.compile("(?<=//|^)([A-Za-z0-9.]+)(?:\\:([1-9][0-9]*))?(?=/|$)");
    private static final String AUTHORITY_REGULAR_EXPRESSION_STRING = "(?<=//|^)([A-Za-z0-9.]+)(?:\\:([1-9][0-9]*))?(?=/|$)";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 10002;
    private static final String DEFAULT_SERVER_CLASS = "rac";
    private static final String DEFAULT_SERVER_INSTANCE = "/default";
    private static final String DEFAULT_SPECIFICATION = "tptp";
    private static final Pattern PATH_REGULAR_EXPRESSION_PATTERN = Pattern.compile("(?<!/)(?:/[A-Za-z0-9]+)+");
    private static final String PATH_REGULAR_EXPRESSION_STRING = "(?<!/)(?:/[A-Za-z0-9]+)+";
    private static final Pattern QUERY_REGULAR_EXPRESSION_PATTERN = Pattern.compile("(?:\\?|&)([A-Za-z]+)=([^&]+)");
    private static final String QUERY_REGULAR_EXPRESSION_STRING = "(?:\\?|&)([A-Za-z]+)=([^&]+)";
    private static final Pattern SCHEME_REGULAR_EXPRESSION_PATTERN = Pattern.compile("(^[A-Za-z0-9]+)\\:(?:([A-Za-z]+)|(?:\\:|/))");
    private static final String SCHEME_REGULAR_EXPRESSION_STRING = "(^[A-Za-z0-9]+)\\:(?:([A-Za-z]+)|(?:\\:|/))";
    private final Properties attributes = new Properties();
    private String connectionString;
    private String host;
    private String password;
    private int port;
    private String serverClass;
    private String serverInstance;
    private String specification;
    private String user;

    public static void main(String[] args) {
        ConnectionSpecifier.test(new ConnectionSpecifier(""));
        ConnectionSpecifier.test(new ConnectionSpecifier("tptp2:dce"));
        ConnectionSpecifier.test(new ConnectionSpecifier("tptp:rac://myriad:10002/default"));
        ConnectionSpecifier.test(new ConnectionSpecifier("iac://fiend:10003/default"));
        ConnectionSpecifier.test(new ConnectionSpecifier("neutron"));
        ConnectionSpecifier.test(new ConnectionSpecifier("pulsar:10004"));
        ConnectionSpecifier.test(new ConnectionSpecifier("//dragon/default"));
        ConnectionSpecifier.test(new ConnectionSpecifier("//chain:5150/default"));
        ConnectionSpecifier.test(new ConnectionSpecifier("//fenix/"));
        ConnectionSpecifier.test(new ConnectionSpecifier("//atari/default?user=scotts"));
        ConnectionSpecifier.test(new ConnectionSpecifier("//bigbox.rtp.raleigh.ibm.com/default?user=scotts"));
        ConnectionSpecifier.test(new ConnectionSpecifier("sextet:9999/auxiliary?user=babel&password=fish"));
        ConnectionSpecifier.test(new ConnectionSpecifier("illnote/default?user=babel&password=fish&other=42"));
    }

    private static void test(ConnectionSpecifier specifier) {
        String canonicalString = specifier.getCanonicalString();
        System.out.println("\r\n" + specifier + "\r\n\t\t  " + canonicalString);
        Assert.assertEquals((Object)specifier, (Object)new ConnectionSpecifier(canonicalString));
        System.out.println();
    }

    public ConnectionSpecifier(String connectionString) {
        this.connectionString = connectionString.trim().length() > 0 ? connectionString : null;
        this.parse();
    }

    public ConnectionSpecifier(String host, int port) {
        this(DEFAULT_SERVER_CLASS, host, port);
    }

    public ConnectionSpecifier(String serverClass, String host, int port) {
        this(DEFAULT_SPECIFICATION, serverClass, host, port, DEFAULT_SERVER_INSTANCE, null, null);
    }

    public ConnectionSpecifier(String specification, String serverClass, String host, int port, String serverInstance, String user, String password) {
        this.specification = specification != null ? specification : DEFAULT_SPECIFICATION;
        this.serverClass = serverClass != null ? serverClass : DEFAULT_SERVER_CLASS;
        this.host = host != null ? host : DEFAULT_HOST;
        this.port = port;
        this.serverInstance = serverInstance != null ? serverInstance : DEFAULT_SERVER_INSTANCE;
        this.user = user;
        this.password = password;
        this.generate();
    }

    public boolean equals(Object object) {
        return this == object ? true : (object instanceof ConnectionSpecifier ? this.getCanonicalString().equals(((ConnectionSpecifier)object).getCanonicalString()) : false);
    }

    private void generate() {
        this.connectionString = this.getCanonicalString();
    }

    public String getAuthority() {
        return String.valueOf(this.host) + ":" + this.port;
    }

    public String getCanonicalString() {
        String query = this.getQuery();
        return String.valueOf(this.getScheme()) + "://" + this.getAuthority() + this.getPath() + (query.length() > 0 ? "?" + query : "");
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public String getHost() {
        return this.host;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPath() {
        return this.serverInstance != null ? this.serverInstance : "";
    }

    public int getPort() {
        return this.port;
    }

    public String getQuery() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.user != null) {
            stringBuffer.append("user=");
            stringBuffer.append(this.user);
            stringBuffer.append("&");
        }
        if (this.password != null) {
            stringBuffer.append("password=");
            stringBuffer.append(this.password);
            stringBuffer.append("&");
        }
        Iterator<Object> pairs = this.attributes.keySet().iterator();
        while (pairs.hasNext()) {
            String name = (String)pairs.next();
            stringBuffer.append(name);
            stringBuffer.append("=");
            stringBuffer.append(this.attributes.get(name));
            stringBuffer.append("&");
        }
        int length = stringBuffer.length();
        if (length > 0 && stringBuffer.charAt(length - 1) == '&') {
            stringBuffer.deleteCharAt(length - 1);
        }
        return stringBuffer.toString();
    }

    public String getScheme() {
        return String.valueOf(this.specification) + ":" + this.serverClass;
    }

    public String getServerClass() {
        return this.serverClass;
    }

    public String getServerInstance() {
        return this.serverInstance;
    }

    public String getSpecification() {
        return this.specification;
    }

    public String getUser() {
        return this.user;
    }

    public int hashCode() {
        return this.getCanonicalString().hashCode();
    }

    private void parse() {
        if (this.connectionString != null) {
            this.parseScheme();
            this.parseAuthority();
            this.parsePath();
            this.parseQuery();
        } else {
            this.useDefaults();
        }
    }

    private void parseAuthority() {
        Matcher matcher = AUTHORITY_REGULAR_EXPRESSION_PATTERN.matcher(this.connectionString);
        if (matcher.find()) {
            this.host = matcher.group(1);
            String port = matcher.group(2);
            this.port = port != null ? Integer.parseInt(port) : 10002;
        } else {
            this.host = DEFAULT_HOST;
            this.port = 10002;
        }
    }

    private void parsePath() {
        Matcher matcher = PATH_REGULAR_EXPRESSION_PATTERN.matcher(this.connectionString);
        this.serverInstance = matcher.find() ? matcher.group() : DEFAULT_SERVER_INSTANCE;
    }

    private void parseQuery() {
        Matcher matcher = QUERY_REGULAR_EXPRESSION_PATTERN.matcher(this.connectionString);
        this.user = null;
        this.password = null;
        this.attributes.clear();
        while (matcher.find()) {
            String name = matcher.group(1);
            String value = matcher.group(2);
            if ("user".equalsIgnoreCase(name)) {
                this.user = value;
                continue;
            }
            if ("password".equalsIgnoreCase(name)) {
                this.password = value;
                continue;
            }
            this.attributes.put(name, value);
        }
    }

    private void parseScheme() {
        Matcher matcher = SCHEME_REGULAR_EXPRESSION_PATTERN.matcher(this.connectionString);
        if (matcher.find()) {
            String group1 = matcher.group(1);
            String group2 = matcher.group(2);
            if (group2 == null) {
                this.specification = DEFAULT_SPECIFICATION;
                this.serverClass = group1;
            } else {
                this.specification = group1;
                this.serverClass = group2;
            }
        } else {
            this.specification = DEFAULT_SPECIFICATION;
            this.serverClass = DEFAULT_SERVER_CLASS;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{connectionString=" + this.connectionString + ", specification=" + this.specification + ", serverClass=" + this.serverClass + ", host=" + this.host + ", port=" + this.port + ", serverInstance=" + this.serverInstance + ", user=" + this.user + ", password=" + this.password);
        Iterator<Object> pairs = this.attributes.keySet().iterator();
        while (pairs.hasNext()) {
            String name = (String)pairs.next();
            stringBuffer.append(", ");
            stringBuffer.append(name);
            stringBuffer.append("=");
            stringBuffer.append(this.attributes.get(name));
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private void useDefaults() {
        this.specification = DEFAULT_SPECIFICATION;
        this.serverClass = DEFAULT_SERVER_CLASS;
        this.host = DEFAULT_HOST;
        this.port = 10002;
        this.serverInstance = DEFAULT_SERVER_INSTANCE;
        this.user = null;
        this.password = null;
        this.attributes.clear();
    }
}

