/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.local;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CommunicationDebug {
    public boolean debug = false;
    public boolean debugMessageValue = false;
    public boolean debugUseOldDataServer = false;
    public boolean debugSocketInputStream = false;
    public boolean debugUseEventMode = false;
    protected String plugin_name;
    protected String value;
    public static CommunicationDebug INSTANCE = new CommunicationDebug("org.eclipse.hyades.execution");
    private Map binaryLogs = new HashMap();
    static /* synthetic */ Class class$0;

    public CommunicationDebug(String plugin_name) {
        this.plugin_name = plugin_name;
        this.init();
    }

    protected void init() {
        try {
            this.value = this.getPlatformDebugOption(String.valueOf(this.plugin_name) + "/debug");
            if (this.value != null) {
                this.debug = this.value.equalsIgnoreCase("true");
            } else if (System.getProperty("CommunicationDebug.debug") != null) {
                this.debug = Boolean.valueOf(System.getProperty("CommunicationDebug.debug"));
            }
            this.value = this.getPlatformDebugOption(String.valueOf(this.plugin_name) + "/debug/messageValue");
            if (this.value != null) {
                this.debugMessageValue = this.value.equalsIgnoreCase("true");
            } else if (System.getProperty("CommunicationDebug.debugMessageValue") != null) {
                this.debugMessageValue = Boolean.valueOf(System.getProperty("CommunicationDebug.debugMessageValue"));
            }
            this.value = this.getPlatformDebugOption(String.valueOf(this.plugin_name) + "/debug/useOldDataServer");
            if (this.value != null) {
                this.debugUseOldDataServer = this.value.equalsIgnoreCase("true");
            } else if (System.getProperty("CommunicationDebug.debugUseOldDataServer") != null) {
                this.debugUseOldDataServer = Boolean.valueOf(System.getProperty("CommunicationDebug.debugUseOldDataServer"));
            }
            this.value = this.getPlatformDebugOption(String.valueOf(this.plugin_name) + "/debug/socketInputStream");
            if (this.value != null) {
                this.debugSocketInputStream = this.value.equalsIgnoreCase("true");
            } else if (System.getProperty("CommunicationDebug.debugSocketInputStream") != null) {
                this.debugSocketInputStream = Boolean.valueOf(System.getProperty("CommunicationDebug.debugSocketInputStream"));
            }
            this.value = this.getPlatformDebugOption(String.valueOf(this.plugin_name) + "/debug/useEventMode");
            if (this.value != null) {
                this.debugUseEventMode = this.value.equalsIgnoreCase("true");
            } else if (System.getProperty("CommunicationDebug.debugUseEventMode") != null) {
                this.debugUseEventMode = Boolean.valueOf(System.getProperty("CommunicationDebug.debugUseEventMode"));
            }
        }
        catch (Exception exception) {}
    }

    protected String getPlatformDebugOption(String option) {
        if (option == null) {
            return null;
        }
        try {
            Class<?> platform = Class.forName("org.eclipse.core.runtime.Platform");
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Method getDebugOption = platform.getMethod("getDebugOption", classArray);
            String value = (String)getDebugOption.invoke(null, (Object[])new String[]{option});
            return value;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String makeUTF8String(byte[] data, int offset, int length) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, offset, length, "UTF8");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized int writeBinaryLog(String id, byte[] buffer, int offset, int length) {
        int real_length;
        block3: {
            FileOutputStream f;
            real_length = Math.min(length, buffer.length - offset);
            if (real_length > 0 && (f = this.getBinaryLog(id)) != null) {
                try {
                    f.write(buffer, offset, real_length);
                    f.flush();
                }
                catch (IOException e) {
                    if (!this.debug) break block3;
                    e.printStackTrace();
                }
            }
        }
        return real_length;
    }

    public synchronized FileOutputStream getBinaryLog(String id) {
        FileOutputStream f;
        block7: {
            f = (FileOutputStream)this.binaryLogs.get(id);
            if (f == null) {
                try {
                    f = new FileOutputStream("/" + id + "-" + new Date().getTime());
                    this.binaryLogs.put(id, f);
                }
                catch (FileNotFoundException e) {
                    if (this.debug) {
                        e.printStackTrace();
                    }
                    break block7;
                }
            }
            if (!f.getChannel().isOpen()) {
                try {
                    f = new FileOutputStream("/" + id + "-" + new Date().getTime());
                    this.binaryLogs.put(id, f);
                }
                catch (FileNotFoundException e) {
                    if (!this.debug) break block7;
                    e.printStackTrace();
                }
            }
        }
        return f;
    }

    public synchronized FileOutputStream removeBinaryLog(String id) {
        FileOutputStream f = (FileOutputStream)this.binaryLogs.get(id);
        if (f != null) {
            block4: {
                if (f.getChannel().isOpen()) {
                    try {
                        f.close();
                    }
                    catch (Exception e) {
                        if (!this.debug) break block4;
                        e.printStackTrace();
                    }
                }
            }
            this.binaryLogs.remove(id);
        }
        return f;
    }
}

