/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.local.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketException;
import org.eclipse.hyades.execution.core.file.IFileLocater;
import org.eclipse.hyades.execution.core.file.IFileLocation;
import org.eclipse.hyades.execution.core.file.IFileManager;
import org.eclipse.hyades.execution.core.impl.ExecutionComponentImpl;
import org.eclipse.hyades.execution.local.file.FileLocaterImpl;
import org.eclipse.hyades.execution.security.ISecureClientParameters;
import org.eclipse.hyades.internal.execution.file.FileServiceConstants;
import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.internal.execution.local.common.Message;
import org.eclipse.hyades.internal.execution.local.control.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.local.control.Connection;
import org.eclipse.hyades.internal.execution.local.control.ConnectionImpl;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.SecureConnectionImpl;

class FileManagerLegacy
extends ExecutionComponentImpl
implements IFileManager {
    private IFileLocater locator;
    private Connection connection;

    FileManagerLegacy(Connection connection) {
        this.locator = new FileLocaterImpl(connection);
        this.connection = connection;
    }

    public void getFile(String localName, String remoteName) throws IOException {
        IFileLocation location = this.locator.getFile(remoteName);
        String directoryName = null;
        File file = new File(localName);
        directoryName = file.getParent();
        File dirFile = new File(directoryName);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        file.createNewFile();
        if (this.connection instanceof SecureConnectionImpl) {
            SecureResourceConnection resourceConnection = new SecureResourceConnection();
            try {
                resourceConnection.setParams(remoteName, 1L);
                resourceConnection.setInputStream(null);
                resourceConnection.setOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                resourceConnection.connect(this.connection.getNode(), location.getPort());
            }
            catch (AgentControllerUnavailableException agentControllerUnavailableException) {
            }
            catch (FileNotFoundException e1) {
                throw e1;
            }
        } else if (this.connection instanceof ConnectionImpl) {
            ResourceConnection resourceConnection = new ResourceConnection();
            try {
                resourceConnection.setParams(remoteName, 1L);
                resourceConnection.setInputStream(null);
                resourceConnection.setOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                resourceConnection.connect(this.connection.getNode(), location.getPort());
            }
            catch (AgentControllerUnavailableException agentControllerUnavailableException) {
            }
            catch (FileNotFoundException e1) {
                throw e1;
            }
        }
    }

    public void deleteFile(String absFileName) throws IOException {
        this.locator.deleteFile(absFileName);
    }

    public void putFile(String localName, String remoteName) throws IOException {
        IFileLocation location = this.locator.putFile(remoteName);
        File file = new File(localName);
        if (this.connection instanceof SecureConnectionImpl) {
            SecureResourceConnection resourceConnection = new SecureResourceConnection();
            try {
                resourceConnection.setParams(remoteName, 2L);
                resourceConnection.setInputStream(new BufferedInputStream(new FileInputStream(file)));
                resourceConnection.setOutputStream(null);
                resourceConnection.connect(this.connection.getNode(), location.getPort());
            }
            catch (AgentControllerUnavailableException agentControllerUnavailableException) {}
        } else if (this.connection instanceof ConnectionImpl) {
            ResourceConnection resourceConnection = new ResourceConnection();
            try {
                resourceConnection.setParams(remoteName, 2L);
                resourceConnection.setInputStream(new BufferedInputStream(new FileInputStream(file)));
                resourceConnection.setOutputStream(null);
                resourceConnection.connect(this.connection.getNode(), location.getPort());
            }
            catch (AgentControllerUnavailableException agentControllerUnavailableException) {}
        }
    }

    static interface IResourceConnection
    extends Connection {
        public void setParams(String var1, long var2);

        public void setInputStream(InputStream var1);

        public void setOutputStream(OutputStream var1);

        public OutputStream getSocketOutputStream() throws IOException;

        public InputStream getSocketInputStream() throws IOException;
    }

    class ResourceConnection
    extends ConnectionImpl
    implements IResourceConnection {
        private SocketReader socketReader;

        public ResourceConnection() {
            this.socketReader = new SocketReader(this);
        }

        protected void init() {
            try {
                this._socket.setSoTimeout(1000);
                this._socket.setTcpNoDelay(true);
            }
            catch (SocketException socketException) {}
            this.socketReader.run();
        }

        public void setInputStream(InputStream in) {
            this.socketReader.setInputStream(in);
        }

        public void setOutputStream(OutputStream out) {
            this.socketReader.setOutputStream(out);
        }

        public void setParams(String fileName, long operation) {
            this.socketReader.setFileName(fileName);
            this.socketReader.setOperation(operation);
        }

        public OutputStream getSocketOutputStream() throws IOException {
            return this._socket.getOutputStream();
        }

        public InputStream getSocketInputStream() throws IOException {
            return this._socket.getInputStream();
        }
    }

    class SecureResourceConnection
    extends SecureConnectionImpl
    implements IResourceConnection {
        private SocketReader socketReader;

        public SecureResourceConnection() {
            this.socketReader = new SocketReader(this);
        }

        protected void init() {
            try {
                this._socket.setSoTimeout(1000);
                this._socket.setTcpNoDelay(true);
            }
            catch (SocketException socketException) {}
            this.socketReader.run();
        }

        public void setInputStream(InputStream in) {
            this.socketReader.setInputStream(in);
        }

        public void setOutputStream(OutputStream out) {
            this.socketReader.setOutputStream(out);
        }

        public void setParams(String fileName, long operation) {
            this.socketReader.setFileName(fileName);
            this.socketReader.setOperation(operation);
        }

        public OutputStream getSocketOutputStream() throws IOException {
            return this._socket.getOutputStream();
        }

        public InputStream getSocketInputStream() throws IOException {
            return this._socket.getInputStream();
        }
    }

    private class SocketReader
    implements Runnable,
    FileServiceConstants,
    Constants {
        private InputStream inStream;
        private OutputStream outStream;
        private String fileName;
        private long operation;
        private boolean _isComplete = false;
        private IResourceConnection connection;
        private byte[] buffer = new byte[1024];
        private long byteCount = 0L;

        public SocketReader(IResourceConnection connection) {
            this.connection = connection;
        }

        public void setInputStream(InputStream in) {
            this.inStream = in;
        }

        public void setOutputStream(OutputStream out) {
            this.outStream = out;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setOperation(long operation) {
            this.operation = operation;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    byte[] tempFileName = this.fileName.getBytes("UTF-8");
                    OutputStream os = this.connection.getSocketOutputStream();
                    long len = this.fileName.length();
                    int offset = 0;
                    offset = Message.writeRALongToBuffer(this.buffer, 0, this.operation);
                    offset = Message.writeRALongToBuffer(this.buffer, offset, len);
                    System.arraycopy(tempFileName, 0, this.buffer, offset, tempFileName.length);
                    os.write(this.buffer);
                    if (this.inStream == null) {
                        this.inStream = this.connection.getSocketInputStream();
                    }
                    if (this.outStream == null) {
                        this.outStream = this.connection.getSocketOutputStream();
                    }
                    while (!this._isComplete) {
                        try {
                            int bytesRead;
                            block17: {
                                bytesRead = this.inStream.read(this.buffer);
                                if (bytesRead != -1) break block17;
                                if (this.byteCount > 0L) {
                                    InputStream in = this.connection.getSocketInputStream();
                                    int result = in.read();
                                    in.close();
                                    if (result != -1) throw new IOException();
                                    if (this.byteCount == 1L) {
                                        throw new IOException();
                                    }
                                }
                                break;
                            }
                            this.byteCount += (long)bytesRead;
                            this.outStream.write(this.buffer, 0, bytesRead);
                        }
                        catch (InterruptedIOException interruptedIOException) {}
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                Node node = this.connection.getNode();
                ISecureClientParameters params = node != null ? node.getSecurityParameters() : null;
                this.connection.disconnect();
                if (node != null) {
                    node.setSecurityParameters(params);
                }
                try {
                    this.outStream.close();
                    this.inStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var9_11 = null;
            }
            Node node = this.connection.getNode();
            ISecureClientParameters params = node != null ? node.getSecurityParameters() : null;
            this.connection.disconnect();
            if (node != null) {
                node.setSecurityParameters(params);
            }
            try {}
            catch (IOException iOException) {
                return;
            }
            this.outStream.close();
            this.inStream.close();
        }
    }
}

