/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.local.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended;
import org.eclipse.hyades.internal.execution.core.file.ServerNotAvailableException;

public class FileManagerLocal
implements IFileManagerExtended {
    private void copyFile(FileChannel source, FileChannel destination) {
        try {
            source.transferTo(0L, source.size(), destination);
            source.close();
            destination.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void prepareFile(File file) {
        if (file.isDirectory()) {
            file.mkdirs();
        } else if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
    }

    public void deleteDirectory(IFileManagerExtended.FileIdentifierList remoteIdentifiers) throws IOException, ServerNotAvailableException {
        this.deleteDirectory(remoteIdentifiers, null);
    }

    public void deleteDirectory(IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException, ServerNotAvailableException {
        String[] remoteFiles = remoteIdentifiers.getArray();
        int i = 0;
        while (i < remoteFiles.length) {
            this.deleteFile(remoteFiles[i]);
            ++i;
        }
    }

    public void deleteFile(IFileManagerExtended.Cookie cookie) throws IOException, ServerNotAvailableException {
    }

    public void deleteFile(IFileManagerExtended.Cookie cookie, IProgressMonitor monitor) throws IOException, ServerNotAvailableException {
    }

    public void deleteFile(IFileManagerExtended.FileIdentifierList remoteIdentifiers) throws IOException, ServerNotAvailableException {
        this.deleteFile(remoteIdentifiers, null);
    }

    public void deleteFile(IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException, ServerNotAvailableException {
        String[] remoteFiles = remoteIdentifiers.getArray();
        int i = 0;
        while (i < remoteFiles.length) {
            this.deleteFile(remoteFiles[i]);
            ++i;
        }
    }

    public void deleteFile(String absFileName) throws IOException {
        File file = new File(absFileName);
        if (file.exists()) {
            file.delete();
        }
    }

    public void getFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers) throws IOException, ServerNotAvailableException {
        int numRemoteFiles;
        int numLocalFiles = localIdentifiers.size();
        int numToCopy = numLocalFiles > (numRemoteFiles = remoteIdentifiers.size()) ? numRemoteFiles : numLocalFiles;
        int i = 0;
        while (i < numToCopy) {
            String localFileName = localIdentifiers.get(i);
            String remoteFileName = remoteIdentifiers.get(i);
            File remoteFile = new File(remoteFileName);
            if (!remoteFile.isAbsolute()) {
                remoteFileName = new String(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + remoteFileName);
                remoteIdentifiers.remove(i);
                remoteIdentifiers.add(i, remoteFileName);
            }
            this.getFile(localFileName, remoteFileName);
            ++i;
        }
    }

    public void getFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException, ServerNotAvailableException {
        this.getFile(localIdentifiers, remoteIdentifiers);
    }

    public void getFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options) throws IOException, ServerNotAvailableException {
        this.getFile(localIdentifiers, remoteIdentifiers);
    }

    public void getFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options, IProgressMonitor monitor) throws IOException, ServerNotAvailableException {
        this.getFile(localIdentifiers, remoteIdentifiers);
    }

    public void getFile(String localName, String remoteName) throws IOException {
        File localFile = new File(localName);
        String remoteNameResolved = remoteName;
        File remoteFile = new File(remoteNameResolved);
        if (!remoteFile.isAbsolute()) {
            remoteNameResolved = new String(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + remoteName);
            remoteFile = new File(remoteNameResolved);
        }
        if (localFile.equals(remoteFile)) {
            return;
        }
        this.prepareFile(localFile);
        FileInputStream sourceStream = new FileInputStream(remoteFile);
        FileOutputStream destinationStream = new FileOutputStream(localFile);
        this.copyFile(sourceStream.getChannel(), destinationStream.getChannel());
    }

    public boolean[] isDirectoryExistent(IFileManagerExtended.FileIdentifierList remoteIdentifier) throws IOException, ServerNotAvailableException {
        return new boolean[0];
    }

    public boolean[] isDirectoryExistent(IFileManagerExtended.FileIdentifierList remoteIdentifier, IProgressMonitor monitor) throws IOException, ServerNotAvailableException {
        return new boolean[0];
    }

    public boolean isServerAvailable() throws IOException {
        return true;
    }

    public IFileManagerExtended.FileIdentifierList listContent(IFileManagerExtended.FileIdentifierList remoteIdentifiers) throws IOException, ServerNotAvailableException {
        return this.listContent(remoteIdentifiers, null);
    }

    public IFileManagerExtended.FileIdentifierList listContent(IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException, ServerNotAvailableException {
        return remoteIdentifiers;
    }

    public void modifyPermission(IFileManagerExtended.FileIdentifierList remoteIdentifiers, String permissionDirective) throws IOException, ServerNotAvailableException {
    }

    public void modifyPermission(IFileManagerExtended.FileIdentifierList remoteIdentifiers, String permissionDirective, IProgressMonitor monitor) throws IOException, ServerNotAvailableException {
    }

    public void putFile(IFileManagerExtended.Cookie cookie, IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers) throws IOException, ServerNotAvailableException {
        this.putFile(localIdentifiers, remoteIdentifiers);
    }

    public void putFile(IFileManagerExtended.Cookie cookie, IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException, ServerNotAvailableException {
        this.putFile(localIdentifiers, remoteIdentifiers);
    }

    public void putFile(IFileManagerExtended.Cookie cookie, IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options) throws IOException, ServerNotAvailableException {
        this.putFile(localIdentifiers, remoteIdentifiers);
    }

    public void putFile(IFileManagerExtended.Cookie cookie, IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options, IProgressMonitor monitor) throws IOException, ServerNotAvailableException {
        this.putFile(localIdentifiers, remoteIdentifiers);
    }

    public void putFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers) throws IOException, ServerNotAvailableException {
        int numRemoteFiles;
        int numLocalFiles = localIdentifiers.size();
        int numToCopy = numLocalFiles > (numRemoteFiles = remoteIdentifiers.size()) ? numRemoteFiles : numLocalFiles;
        int i = 0;
        while (i < numToCopy) {
            String localFileName = localIdentifiers.get(i);
            String remoteFileName = remoteIdentifiers.get(i);
            File remoteFile = new File(remoteFileName);
            if (!remoteFile.isAbsolute()) {
                remoteFileName = new String(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + remoteFileName);
                remoteIdentifiers.remove(i);
                remoteIdentifiers.add(i, remoteFileName);
            }
            this.putFile(localFileName, remoteFileName);
            ++i;
        }
    }

    public void putFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException, ServerNotAvailableException {
        this.putFile(localIdentifiers, remoteIdentifiers);
    }

    public void putFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options) throws IOException, ServerNotAvailableException {
        this.putFile(localIdentifiers, remoteIdentifiers);
    }

    public void putFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options, IProgressMonitor monitor) throws IOException, ServerNotAvailableException {
        this.putFile(localIdentifiers, remoteIdentifiers);
    }

    public void putFile(String localName, String remoteName) throws IOException {
        File localFile = new File(localName);
        String remoteNameResolved = remoteName;
        File remoteFile = new File(remoteNameResolved);
        if (!remoteFile.isAbsolute()) {
            remoteNameResolved = new String(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + remoteName);
            remoteFile = new File(remoteNameResolved);
        }
        if (localFile.equals(remoteFile)) {
            return;
        }
        this.prepareFile(remoteFile);
        FileInputStream sourceStream = new FileInputStream(localFile);
        FileOutputStream destinationStream = new FileOutputStream(remoteFile);
        this.copyFile(sourceStream.getChannel(), destinationStream.getChannel());
    }

    public void reset() {
    }

    public boolean determineServerReach(String host, int port) {
        return true;
    }
}

