/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.local.file;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.hyades.execution.core.file.IFileLocation;
import org.eclipse.hyades.execution.core.file.IFileManager;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended;
import org.eclipse.hyades.execution.local.file.FileLocationImpl;
import org.eclipse.hyades.internal.execution.core.file.FileServerCommandFactory;
import org.eclipse.hyades.internal.execution.core.file.IDeleteDirectoryCommand;
import org.eclipse.hyades.internal.execution.core.file.IDeleteFileCommand;
import org.eclipse.hyades.internal.execution.core.file.IFileServerCommandFactory;
import org.eclipse.hyades.internal.execution.core.file.IGetFileCommand;
import org.eclipse.hyades.internal.execution.core.file.IPutFileCommand;
import org.eclipse.hyades.internal.execution.core.file.IQueryServerStatusCommand;
import org.eclipse.hyades.internal.execution.core.file.ServerNotAvailableException;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.local.common.ManageFileCommand;
import org.eclipse.hyades.internal.execution.local.common.ResourceLocation;
import org.eclipse.hyades.internal.execution.local.control.CommandHandler;
import org.eclipse.hyades.internal.execution.local.control.Connection;
import org.eclipse.hyades.internal.execution.local.control.Node;

class ProvisionalFileManagerExtended
implements IFileManagerExtended {
    private static final int DEFAULT_TIMEOUT = 60000;
    private static final NullProgressMonitor NULL_PROGRESS_MONITOR = new NullProgressMonitor();
    private final IFileServerCommandFactory factory;

    ProvisionalFileManagerExtended(Connection connection) {
        this.factory = FileServerCommandFactory.getInstance(this.queryFileServerLocation(connection));
    }

    public void deleteDirectory(IFileManagerExtended.FileIdentifierList remoteIdentifiers) throws IOException, ServerNotAvailableException {
        this.deleteDirectory(remoteIdentifiers, (IProgressMonitor)NULL_PROGRESS_MONITOR);
    }

    public void deleteDirectory(IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException, ServerNotAvailableException {
        if (remoteIdentifiers == null || monitor == null) {
            throw new NullPointerException();
        }
        IDeleteDirectoryCommand command = this.factory.createDeleteDirectoryCommand(remoteIdentifiers, monitor);
        command.execute();
        command.dispose();
    }

    public void deleteFile(IFileManagerExtended.Cookie cookie) throws IOException, ServerNotAvailableException {
        this.deleteFile(cookie, (IProgressMonitor)NULL_PROGRESS_MONITOR);
    }

    public void deleteFile(IFileManagerExtended.Cookie cookie, IProgressMonitor monitor) throws IOException, ServerNotAvailableException {
        if (cookie == null || monitor == null) {
            throw new NullPointerException();
        }
        throw new UnsupportedOperationException();
    }

    public void deleteFile(IFileManagerExtended.FileIdentifierList remoteIdentifiers) throws IOException, ServerNotAvailableException {
        this.deleteFile(remoteIdentifiers, (IProgressMonitor)NULL_PROGRESS_MONITOR);
    }

    public void deleteFile(IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException, ServerNotAvailableException {
        if (remoteIdentifiers == null || monitor == null) {
            throw new NullPointerException();
        }
        IDeleteFileCommand command = this.factory.createDeleteFileCommand(remoteIdentifiers, monitor);
        command.execute();
        command.dispose();
    }

    public void deleteFile(String remoteName) throws IOException {
        try {
            this.deleteFile(IFileManagerExtended.FileIdentifierList.create(remoteName));
        }
        catch (ServerNotAvailableException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public boolean determineServerReach(String host, int port) {
        return true;
    }

    public void getFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers) throws IOException, ServerNotAvailableException {
        this.getFile(localIdentifiers, remoteIdentifiers, (IProgressMonitor)NULL_PROGRESS_MONITOR);
    }

    public void getFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException, ServerNotAvailableException {
        this.getFile(localIdentifiers, remoteIdentifiers, IFileManagerExtended.Option.NONE, monitor);
    }

    public void getFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options) throws IOException, ServerNotAvailableException {
        this.getFile(localIdentifiers, remoteIdentifiers, options, (IProgressMonitor)NULL_PROGRESS_MONITOR);
    }

    public void getFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options, IProgressMonitor monitor) throws IOException, ServerNotAvailableException {
        if (localIdentifiers == null || remoteIdentifiers == null || options == null || monitor == null) {
            throw new NullPointerException();
        }
        if (localIdentifiers.size() != remoteIdentifiers.size()) {
            throw new IllegalArgumentException();
        }
        IGetFileCommand command = this.factory.createGetFileCommand(localIdentifiers, remoteIdentifiers, options, monitor);
        command.execute();
        command.dispose();
    }

    public void getFile(String localName, String remoteName) throws IOException {
        try {
            this.getFile(IFileManagerExtended.FileIdentifierList.create(localName), IFileManagerExtended.FileIdentifierList.create(remoteName));
        }
        catch (ServerNotAvailableException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public boolean[] isDirectoryExistent(IFileManagerExtended.FileIdentifierList remoteIdentifier) throws IOException, ServerNotAvailableException {
        throw new UnsupportedOperationException();
    }

    public boolean[] isDirectoryExistent(IFileManagerExtended.FileIdentifierList remoteIdentifier, IProgressMonitor monitor) throws IOException, ServerNotAvailableException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isServerAvailable() throws IOException {
        IQueryServerStatusCommand command;
        block5: {
            command = null;
            try {
                try {
                    command = this.factory.createQueryServerStatusCommand();
                    command.execute();
                }
                catch (ServerNotAvailableException serverNotAvailableException) {
                    command = null;
                }
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                if (command == null) throw throwable;
                command.dispose();
                throw throwable;
            }
            {
                Object var2_4 = null;
                if (command == null) break block5;
            }
            command.dispose();
        }
        command.dispose();
        if (command == null) return false;
        boolean bl = command.isServerAvailable();
        return bl;
    }

    public IFileManagerExtended.FileIdentifierList listContent(IFileManagerExtended.FileIdentifierList remoteIdentifiers) throws IOException, ServerNotAvailableException {
        return this.listContent(remoteIdentifiers, (IProgressMonitor)NULL_PROGRESS_MONITOR);
    }

    public IFileManagerExtended.FileIdentifierList listContent(IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException, ServerNotAvailableException {
        if (remoteIdentifiers == null || monitor == null) {
            throw new NullPointerException();
        }
        throw new UnsupportedOperationException();
    }

    public void modifyPermission(IFileManagerExtended.FileIdentifierList remoteIdentifiers, String permissionDirective) throws IOException, ServerNotAvailableException {
        this.modifyPermission(remoteIdentifiers, permissionDirective, (IProgressMonitor)NULL_PROGRESS_MONITOR);
    }

    public void modifyPermission(IFileManagerExtended.FileIdentifierList remoteIdentifiers, String permissionDirective, IProgressMonitor monitor) throws IOException, ServerNotAvailableException {
        if (remoteIdentifiers == null || permissionDirective == null || monitor == null) {
            throw new NullPointerException();
        }
        if (permissionDirective.trim().length() <= 0) {
            throw new IllegalArgumentException();
        }
        throw new UnsupportedOperationException();
    }

    public void putFile(IFileManagerExtended.Cookie cookie, IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers) throws IOException, ServerNotAvailableException {
        this.putFile(cookie, localIdentifiers, remoteIdentifiers, IFileManagerExtended.Option.NONE);
    }

    public void putFile(IFileManagerExtended.Cookie cookie, IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException, ServerNotAvailableException {
        this.putFile(cookie, localIdentifiers, remoteIdentifiers, IFileManagerExtended.Option.NONE, monitor);
    }

    public void putFile(IFileManagerExtended.Cookie cookie, IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options) throws IOException, ServerNotAvailableException {
        this.putFile(cookie, localIdentifiers, remoteIdentifiers, options, (IProgressMonitor)NULL_PROGRESS_MONITOR);
    }

    public void putFile(IFileManagerExtended.Cookie cookie, IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options, IProgressMonitor monitor) throws IOException, ServerNotAvailableException {
        if (cookie == null || localIdentifiers == null || remoteIdentifiers == null || options == null || monitor == null) {
            throw new NullPointerException();
        }
        if (localIdentifiers.size() != remoteIdentifiers.size()) {
            throw new IllegalArgumentException();
        }
        IPutFileCommand command = this.factory.createPutFileCommand(cookie, localIdentifiers, remoteIdentifiers, options, monitor);
        command.execute();
        command.dispose();
    }

    public void putFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers) throws IOException, ServerNotAvailableException {
        this.putFile(localIdentifiers, remoteIdentifiers, (IProgressMonitor)NULL_PROGRESS_MONITOR);
    }

    public void putFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException, ServerNotAvailableException {
        this.putFile(localIdentifiers, remoteIdentifiers, IFileManagerExtended.Option.NONE, monitor);
    }

    public void putFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options) throws IOException, ServerNotAvailableException {
        this.putFile(localIdentifiers, remoteIdentifiers, options, (IProgressMonitor)NULL_PROGRESS_MONITOR);
    }

    public void putFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options, IProgressMonitor monitor) throws IOException, ServerNotAvailableException {
        this.putFile(IFileManagerExtended.Cookie.NONE, localIdentifiers, remoteIdentifiers, options, monitor);
    }

    public void putFile(String localName, String remoteName) throws IOException {
        try {
            this.putFile(IFileManagerExtended.FileIdentifierList.create(localName), IFileManagerExtended.FileIdentifierList.create(remoteName));
        }
        catch (ServerNotAvailableException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IFileLocation queryFileServerLocation(Connection connection) {
        ManageFileCommand command = new ManageFileCommand();
        command.setOperation(2L);
        command.setFilename("");
        ControlMessage message = new ControlMessage();
        message.appendCommand(command);
        final FileLocationImpl result = new FileLocationImpl();
        final Object lock = new Object();
        try {
            Object object = lock;
            synchronized (object) {
                connection.sendMessage(message, new CommandHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void incommingCommand(Node node, CommandElement command) {
                        if (command.getTag() == 112L) {
                            ResourceLocation location = (ResourceLocation)command;
                            result.setInetAddress(node.getInetAddress());
                            result.setPort(location.getPort());
                            result.setJobKey(location.getJobKey());
                            Object object = lock;
                            synchronized (object) {
                                lock.notify();
                            }
                        }
                    }
                });
                lock.wait(60000L);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return result;
    }

    public void reset() {
        this.factory.reset();
    }

    static class Adapter
    implements IFileManagerExtended {
        private final IFileManager fileManager;

        Adapter(IFileManager fileManager) {
            this.fileManager = fileManager;
        }

        public void deleteDirectory(IFileManagerExtended.FileIdentifierList remoteIdentifiers) throws IOException, ServerNotAvailableException {
            throw new UnsupportedOperationException();
        }

        public void deleteDirectory(IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException, ServerNotAvailableException {
            throw new UnsupportedOperationException();
        }

        public void deleteFile(IFileManagerExtended.Cookie cookie) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void deleteFile(IFileManagerExtended.Cookie cookie, IProgressMonitor monitor) throws IOException {
            if (cookie == null || monitor == null) {
                throw new NullPointerException();
            }
            throw new UnsupportedOperationException();
        }

        public void deleteFile(IFileManagerExtended.FileIdentifierList remoteIdentifiers) throws IOException {
            Iterator identifiers = remoteIdentifiers.iterator();
            while (identifiers.hasNext()) {
                String remoteFileName = (String)identifiers.next();
                this.deleteFile(remoteFileName);
            }
        }

        public void deleteFile(IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void deleteFile(String remoteFileName) throws IOException {
            this.fileManager.deleteFile(remoteFileName);
        }

        public boolean determineServerReach(String host, int port) {
            throw new UnsupportedOperationException();
        }

        public void getFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers) throws IOException {
            Iterator localIdentifier = localIdentifiers.iterator();
            Iterator remoteIdentifier = remoteIdentifiers.iterator();
            while (localIdentifier.hasNext()) {
                String localFileName = (String)localIdentifier.next();
                String remoteFileName = (String)remoteIdentifier.next();
                this.getFile(localFileName, remoteFileName);
            }
        }

        public void getFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void getFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void getFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options, IProgressMonitor monitor) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void getFile(String localName, String remoteName) throws IOException {
            this.fileManager.getFile(localName, remoteName);
        }

        public boolean[] isDirectoryExistent(IFileManagerExtended.FileIdentifierList remoteIdentifier) throws IOException, ServerNotAvailableException {
            throw new UnsupportedOperationException();
        }

        public boolean[] isDirectoryExistent(IFileManagerExtended.FileIdentifierList remoteIdentifier, IProgressMonitor monitor) throws IOException, ServerNotAvailableException {
            throw new UnsupportedOperationException();
        }

        public boolean isServerAvailable() throws IOException {
            return true;
        }

        public IFileManagerExtended.FileIdentifierList listContent(IFileManagerExtended.FileIdentifierList remoteIdentifiers) throws IOException {
            throw new UnsupportedOperationException();
        }

        public IFileManagerExtended.FileIdentifierList listContent(IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void modifyPermission(IFileManagerExtended.FileIdentifierList remoteIdentifiers, String permissionDirective) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void modifyPermission(IFileManagerExtended.FileIdentifierList remoteIdentifiers, String permissionDirective, IProgressMonitor monitor) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void putFile(IFileManagerExtended.Cookie cookie, IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void putFile(IFileManagerExtended.Cookie cookie, IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void putFile(IFileManagerExtended.Cookie cookie, IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void putFile(IFileManagerExtended.Cookie cookie, IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options, IProgressMonitor monitor) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void putFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers) throws IOException {
            Iterator localIdentifier = localIdentifiers.iterator();
            Iterator remoteIdentifier = remoteIdentifiers.iterator();
            while (localIdentifier.hasNext()) {
                String localFileName = (String)localIdentifier.next();
                String remoteFileName = (String)remoteIdentifier.next();
                this.putFile(localFileName, remoteFileName);
            }
        }

        public void putFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void putFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void putFile(IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options, IProgressMonitor monitor) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void putFile(String localName, String remoteName) throws IOException {
            this.fileManager.putFile(localName, remoteName);
        }

        public void reset() {
        }
    }
}

