/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.local.util;

import java.util.StringTokenizer;
import org.eclipse.hyades.execution.local.util.IAgentControllerDescriptor;
import org.eclipse.hyades.internal.execution.local.common.SetNVPairCommand;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;

public class AgentControllerDescriptor
implements IAgentControllerDescriptor {
    private static final String ORG_ECLIPSE_HYADES_DATACOLLECTION = "org.eclipse.hyades.datacollection";
    private static final String ORG_ECLIPSE_TPTP_PLATFORM_COLLECTION_FRAMEWORK = "org.eclipse.hyades.execution";
    private static final String VERSION = "version";
    private Node node;

    private static boolean versionIsAtLeast(String required, String version) {
        if (required == null || version == null) {
            throw new NullPointerException();
        }
        StringTokenizer stReq = new StringTokenizer(required, ".");
        StringTokenizer stVer = new StringTokenizer(version, ".");
        int majReq = 0;
        int majVer = -1;
        if (!stReq.hasMoreTokens() || !stVer.hasMoreTokens()) {
            return false;
        }
        majReq = Integer.valueOf(stReq.nextToken());
        majVer = Integer.valueOf(stVer.nextToken());
        if (majVer < majReq) {
            return false;
        }
        if (majVer > majReq) {
            return true;
        }
        int min = Math.min(stReq.countTokens(), stVer.countTokens());
        int i = 0;
        while (i < min) {
            int minReq = 0;
            int minVer = -1;
            if (stReq.hasMoreTokens()) {
                minReq = Integer.valueOf(stReq.nextToken());
                if (stVer.hasMoreTokens()) {
                    minVer = Integer.valueOf(stVer.nextToken());
                    if (minVer < minReq) {
                        return false;
                    }
                    if (minVer > minReq) {
                        return true;
                    }
                    if (i == min - 1) {
                        if (!stReq.hasMoreTokens()) {
                            return minVer == minReq;
                        }
                        return false;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    public AgentControllerDescriptor(Node node) {
        this.node = node;
    }

    public String getProperty(String name, String type) {
        return this.getPropertyStringValue(name, type);
    }

    private String getPropertyStringValue(String name, String type) {
        SetNVPairCommand[] values = null;
        try {
            values = this.node.getPropertyValues(name, type);
        }
        catch (NotConnectedException notConnectedException) {}
        if (values != null && values.length > 0) {
            return values[0].getValue();
        }
        return null;
    }

    public String getVersion() {
        String name_3_3 = ORG_ECLIPSE_HYADES_DATACOLLECTION;
        String name_4_0 = ORG_ECLIPSE_TPTP_PLATFORM_COLLECTION_FRAMEWORK;
        String type = VERSION;
        String value = this.getPropertyStringValue(name_4_0, type);
        if (value == null) {
            value = this.getPropertyStringValue(name_3_3, type);
        }
        return value;
    }

    public boolean isVersionAtLeast(String lowerLimitInclusive) {
        return AgentControllerDescriptor.versionIsAtLeast(lowerLimitInclusive, this.getVersion());
    }

    public boolean isVersionAtMost(String upperLimitInclusive) {
        String version = this.getVersion();
        return !AgentControllerDescriptor.versionIsAtLeast(upperLimitInclusive, this.getVersion()) || upperLimitInclusive.equals(version);
    }

    public boolean isVersionEqual(String version) {
        return this.getVersion().trim().equals(version.trim());
    }

    public boolean isVersionWithin(String lowerLimitInclusive, String upperLimitInclusive) {
        return this.isVersionAtLeast(lowerLimitInclusive) && this.isVersionAtMost(upperLimitInclusive);
    }
}

