/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.hyades.execution.security.IKeystoreManager;
import org.eclipse.hyades.execution.security.X509KeyManagerImpl;
import org.eclipse.hyades.execution.security.X509TrustManagerImpl;

public class KeystoreManagerImpl
implements IKeystoreManager {
    private KeyStore keyStore;
    private X509TrustManagerImpl tm;
    private X509KeyManagerImpl keyManager;

    public void loadKeystore(String filename, String password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, CertificateException, IOException {
        boolean isNewKeystore = false;
        char[] passphrase = password.toCharArray();
        this.keyStore = KeyStore.getInstance("JKS");
        File fKeystore = new File(filename);
        if (fKeystore.exists()) {
            this.keyStore.load(new FileInputStream(filename), passphrase);
        } else {
            this.keyStore.load(null, passphrase);
            isNewKeystore = true;
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(this.keyStore, passphrase);
        String algorithm = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(algorithm);
        trustManagerFactory.init(this.keyStore);
        this.tm = new X509TrustManagerImpl(trustManagerFactory);
        this.keyManager = new X509KeyManagerImpl(keyManagerFactory);
        if (isNewKeystore) {
            FileOutputStream fout = new FileOutputStream(filename);
            this.keyStore.store(fout, password.toCharArray());
            fout.close();
        }
    }

    public KeyManager[] getKeyManagers() {
        KeyManager[] kmList = new KeyManager[]{this.keyManager};
        return kmList;
    }

    public TrustManager[] getTrustManagers() {
        TrustManager[] tmList = new TrustManager[]{this.tm};
        return tmList;
    }

    public void setProvider(Provider provider) {
    }
}

