/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.security;

import java.io.IOException;
import java.net.SocketException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.eclipse.hyades.execution.security.IConnectionHandler;
import org.eclipse.hyades.execution.security.IKeystoreManager;
import org.eclipse.hyades.execution.security.ISecureServerParameters;

public final class SecureServer
implements Runnable {
    private SSLServerSocket sslsocket;
    private IConnectionHandler connectionHandler;
    private boolean shutdown = false;

    private IKeystoreManager loadKeystore(ISecureServerParameters params) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, CertificateException, IOException {
        IKeystoreManager manager = params.getKeystoreManager();
        manager.loadKeystore(params.getKeystoreFileName(), params.getKeystoreFilepassword());
        return manager;
    }

    public void init(ISecureServerParameters params) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, CertificateException, IOException {
        int protocolOffset = 0;
        IKeystoreManager keyManager = null;
        keyManager = this.loadKeystore(params);
        String[] sslProtocols = params.getEnabledProtocols();
        if (sslProtocols == null) {
            sslProtocols = new String[]{"SSL"};
        }
        SSLContext sslContext = null;
        while (true) {
            try {
                sslContext = SSLContext.getInstance(sslProtocols[protocolOffset]);
            }
            catch (NoSuchAlgorithmException e) {
                if (++protocolOffset != sslProtocols.length) continue;
                throw e;
                if (protocolOffset < sslProtocols.length) continue;
            }
            break;
        }
        sslContext.init(keyManager.getKeyManagers(), keyManager.getTrustManagers(), null);
        this.sslsocket = (SSLServerSocket)sslContext.getServerSocketFactory().createServerSocket(params.getPort());
        this.sslsocket.setNeedClientAuth(params.clientAuthenticationRequired());
        try {
            this.sslsocket.setWantClientAuth(params.clientAuthenticationRequired());
        }
        catch (Throwable throwable) {}
        String[] cyphers = params.getEnabledCipherSuites();
        if (cyphers != null) {
            this.sslsocket.setEnabledCipherSuites(params.getEnabledCipherSuites());
        } else {
            this.sslsocket.setEnabledCipherSuites(this.sslsocket.getEnabledCipherSuites());
        }
        this.sslsocket.setEnableSessionCreation(true);
        this.connectionHandler = params.getConnectionHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                while (true) {
                    SSLSocket socket = (SSLSocket)this.sslsocket.accept();
                    socket.addHandshakeCompletedListener(new HandshakeCompletedListener(){

                        public void handshakeCompleted(HandshakeCompletedEvent event) {
                        }
                    });
                    SSLSession session = socket.getSession();
                    if (session == null || session.getCipherSuite().equals("SSL_NULL_WITH_NULL_NULL") || this.connectionHandler == null) continue;
                    this.connectionHandler.connectionAccepted(socket);
                }
            }
            catch (SocketException socketException) {
                if (!this.shutdown) continue;
                SecureServer secureServer = this;
                synchronized (secureServer) {
                }
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    public synchronized void quit() {
        try {
            this.shutdown = true;
            if (this.sslsocket != null) {
                this.sslsocket.close();
            }
        }
        catch (Throwable throwable) {}
    }
}

