/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.security;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class X509TrustManagerImpl
implements X509TrustManager {
    boolean serverAuthenticationEnabled = true;
    private X509TrustManager delegate;
    private X509Certificate[] receivedCerts;
    private X509Certificate[] certs;

    public X509TrustManagerImpl(TrustManagerFactory factory) {
        TrustManager[] managers = factory.getTrustManagers();
        int i = 0;
        while (i < managers.length) {
            if (managers[i] instanceof X509TrustManager) {
                this.delegate = (X509TrustManager)managers[i];
                this.certs = ((X509TrustManager)managers[i]).getAcceptedIssuers();
                break;
            }
            ++i;
        }
        if (this.delegate == null) {
            this.certs = new X509Certificate[0];
        }
    }

    public X509Certificate[] getReceivedCerts() {
        return this.receivedCerts;
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.certs;
    }

    public void checkClientTrusted(X509Certificate[] cert, String authType) throws CertificateException {
    }

    public void checkServerTrusted(X509Certificate[] cert, String authType) throws CertificateException {
        if (this.serverAuthenticationEnabled) {
            this.receivedCerts = cert;
            if (this.delegate != null) {
                this.delegate.checkServerTrusted(cert, authType);
            } else {
                throw new CertificateException();
            }
        }
    }

    public void disableServerAuthentication() {
        this.serverAuthenticationEnabled = false;
    }

    public void enableServerAuthentication() {
        this.serverAuthenticationEnabled = true;
    }
}

