/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.core.file.dynamic;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import org.eclipse.hyades.internal.execution.core.file.dynamic.AbstractServerInterrogationCommand;
import org.eclipse.hyades.internal.execution.core.file.dynamic.IDetermineServerReachCommand;
import org.eclipse.hyades.internal.execution.core.file.socket.ISocketChannel;

class DetermineServerReachCommand
extends AbstractServerInterrogationCommand
implements IDetermineServerReachCommand {
    private static final byte[] FALSE = new byte[1];
    private static final byte[] TRUE = new byte[]{1};
    private String host;
    private boolean isHostReachable;
    private int port;
    static /* synthetic */ Class class$0;

    public DetermineServerReachCommand(String context, ISocketChannel channel) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.hyades.internal.execution.core.file.dynamic.DetermineServerReachCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(context, clazz);
        this.isHostReachable = false;
        this.setState(new Server(channel));
    }

    public DetermineServerReachCommand(String context, ISocketChannel channel, String host, int port) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.hyades.internal.execution.core.file.dynamic.DetermineServerReachCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(context, clazz);
        this.isHostReachable = false;
        this.setState(new Client(channel));
        this.host = host;
        this.port = port;
    }

    public boolean isHostReachable() {
        return this.isHostReachable;
    }

    private class Client
    extends AbstractServerInterrogationCommand.Client {
        Client(ISocketChannel channel) {
            super(channel);
        }

        public void execute() throws IOException {
            super.execute();
            this.communicator.send(DetermineServerReachCommand.this.host);
            this.communicator.send(DetermineServerReachCommand.this.port);
            DetermineServerReachCommand.this.isHostReachable = this.receiveBoolean();
        }

        private boolean receiveBoolean() throws IOException {
            return this.communicator.receiveBytes(1)[0] == TRUE[0];
        }
    }

    private class Server
    extends AbstractServerInterrogationCommand.Server {
        Server(ISocketChannel channel) {
            super(channel);
        }

        private void determineServerReach() {
            if (DetermineServerReachCommand.this.host != null && DetermineServerReachCommand.this.port >= 0) {
                try {
                    SocketChannel sc = SocketChannel.open(new InetSocketAddress(DetermineServerReachCommand.this.host, DetermineServerReachCommand.this.port));
                    DetermineServerReachCommand.this.isHostReachable = true;
                    sc.close();
                }
                catch (Throwable throwable) {}
            }
        }

        public void execute() throws IOException {
            super.execute();
            DetermineServerReachCommand.this.host = this.communicator.receiveString();
            DetermineServerReachCommand.this.port = this.communicator.receiveInt();
            this.determineServerReach();
            this.send(DetermineServerReachCommand.this.isHostReachable);
        }

        private void send(boolean data) throws IOException {
            this.communicator.send(data ? TRUE : FALSE);
        }
    }
}

